/*
 * Decompiled with CFR 0.152.
 */
package oir1;

import TamplatePaneli.Template;
import Utill.DateCell;
import Utill.DateUtil;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import ispisJasper.IspisReporta;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import oir1.BazaOir1;
import oir1.Oir1;
import oir1.Oir1Controller;
import zastitanaradu.GlavniPanelController;

public class PopisOir1Controller
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private Button btnIspis;
    @FXML
    private TableView<Oir1> tablicaPopisOir1;
    @FXML
    private TableColumn<Oir1, String> kolPretraga;
    @FXML
    private TableColumn<Oir1, String> kolRedBr;
    @FXML
    private TableColumn<Oir1, LocalDate> kolDatumIzdavanja;
    @FXML
    private TableColumn<Oir1, String> kolNadleznaInspekcija;
    @FXML
    private TableColumn<Oir1, String> kolDogadaj;
    private static PopisOir1Controller instance;
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;
    private final ObservableList<Oir1> listaOir1 = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    BooleanProperty bp = new SimpleBooleanProperty(true);

    public static PopisOir1Controller getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediTablicuPopisOir1();
        this.popuniTablicuPopisOir1();
        this.urediFilter(this.tablicaPopisOir1);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Obrazac OIR-1")) {
                GlavniPanelController.getInstance().zatvoriTab("Obrazac OIR-1");
                GlavniPanelController.getInstance().nadodajPanel("Obrazac OIR-1", "/oir1/Oir1.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Obrazac OIR-1", "/oir1/Oir1.fxml");
            }
        });
        this.btnPromjena.setOnAction(event -> {
            Oir1 ra;
            int selectdIndex = this.tablicaPopisOir1.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (ra = (Oir1)this.tablicaPopisOir1.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Obrazac OIR-1")) {
                    GlavniPanelController.getInstance().zatvoriTab("Obrazac OIR-1");
                    GlavniPanelController.getInstance().nadodajPanel("Obrazac OIR-1", "/oir1/Oir1.fxml");
                    Oir1Controller.getInstance().izmjenaUputnice(ra);
                    this.tablicaPopisOir1.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Obrazac OIR-1", "/oir1/Oir1.fxml");
                    Oir1Controller.getInstance().izmjenaUputnice(ra);
                    this.tablicaPopisOir1.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisOir1.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && this.tablicaPopisOir1.getSelectionModel().getSelectedItems().size() < 2 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati Oir1")).showAndWait()).get() == ButtonType.OK) {
                if (BazaOir1.obrisiOir1((Oir1)this.tablicaPopisOir1.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuPopisOir1();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisan Oir1", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan Oir1", 2, "Error graphic");
                }
            }
        });
        this.btnIspis.setOnAction(e -> {
            int selectdIndex = this.tablicaPopisOir1.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                this.ispis((ObservableList<Oir1>)this.tablicaPopisOir1.getSelectionModel().getSelectedItems());
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Nadle\u017ena inspekcija"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Nadle\u017ena inspekcija");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaOir1, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Nadle\u017ena inspekcija") && pregled.getNadleznaInspekcijaOpis() != null && pregled.getNadleznaInspekcijaOpis().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediTablicuPopisOir1() {
        this.tablicaPopisOir1.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tablicaPopisOir1.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisOir1Controller.this.tablicaPopisOir1.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cellData -> ((Oir1)cellData.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOir1.widthProperty().divide(12.5));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory = param -> new DateCell();
        this.kolDatumIzdavanja.setCellValueFactory(cellData -> ((Oir1)cellData.getValue()).datumPrijaveProperty());
        this.kolDatumIzdavanja.setCellFactory(dateCellFactory);
        this.kolDatumIzdavanja.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOir1.widthProperty().divide(10.0));
        this.kolDatumIzdavanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumIzdavanja.setEditable(false);
        this.kolNadleznaInspekcija.setCellValueFactory(cellData -> ((Oir1)cellData.getValue()).nadleznaInspekcijaOpisProperty());
        this.kolNadleznaInspekcija.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOir1.widthProperty().divide(3.3333333333333335));
        this.kolNadleznaInspekcija.setStyle("-fx-alignment: CENTER;");
        this.kolDogadaj.setCellValueFactory(cellData -> ((Oir1)cellData.getValue()).dogadajOpisSaDatumomProperty());
        this.kolDogadaj.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOir1.widthProperty().divide(3.3333333333333335));
        this.kolDogadaj.setStyle("-fx-alignment: CENTER;");
        TableColumn kolPregledDjelatnika = new TableColumn("Pregled");
        kolPregledDjelatnika.setSortable(false);
        kolPregledDjelatnika.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOir1.widthProperty().divide(10.0));
        kolPregledDjelatnika.setStyle("-fx-alignment: CENTER;");
        kolPregledDjelatnika.setCellFactory((Callback)new Callback<TableColumn<Oir1, Boolean>, TableCell<Oir1, Boolean>>(){

            public TableCell<Oir1, Boolean> call(TableColumn<Oir1, Boolean> param) {
                return new ButtonCell();
            }
        });
        this.kolPretraga.setGraphic((Node)this.tbFilter);
        this.kolPretraga.getColumns().add((Object)kolPregledDjelatnika);
    }

    public void popuniTablicuPopisOir1() {
        this.tablicaPopisOir1.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaOir1.clear();
        this.tablicaPopisOir1.getItems().clear();
    }

    private Task createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(Oir1Controller.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    ResultSet rs = BazaOir1.dajOir1(GlavniPanelController.getOdabranaTvrtka());
                    PopisOir1Controller.this.popuniTablicuPopisOir1(rs);
                }
                finally {
                    Platform.runLater(() -> PopisOir1Controller.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popuniTablicuPopisOir1(ResultSet rs) {
        Oir1 ra = null;
        int br = 1;
        try {
            while (rs.next()) {
                ra = new Oir1();
                ra.setId(rs.getInt("id"));
                ra.setRedBroj(String.valueOf(br));
                ra.setInspekcijaRada1(rs.getString("nazivinspekcije1"));
                ra.setInspekcijaRada2(rs.getString("nazivinspekcije2"));
                ra.setDogadjajNastao(rs.getString("dogadjaj"));
                ra.setDatumDogadjaja(DateUtil.getLocalDate(rs.getDate("datumdogadjaja")));
                ra.setSati(rs.getString("sat"));
                ra.setIdOzljeda(rs.getString("ozljedenizaposlenici"));
                ra.setIdPoginuli(rs.getString("poginulizaposlenici"));
                ra.setOpisDogadaja(rs.getString("opisdogadaja"));
                ra.setRukovoditelj(rs.getString("rukovatelj"));
                ra.setPrisutniZaposlenici(rs.getString("prisutnizaposlenici"));
                ra.setPrimjenjeneMjere(rs.getString("primjenjenemjere"));
                ra.setPodnositelj(rs.getString("podnositelj"));
                ra.setMjestoPrijave(rs.getString("mjestoprijave"));
                ra.setDatumPrijave(DateUtil.getLocalDate(rs.getDate("datumprijave")));
                ra.setNadleznaInspekcijaOpis(rs.getString("nazivinspekcije1") + "\n" + rs.getString("nazivinspekcije2"));
                ra.setDogadajOpisSaDatumom(DateUtil.getLocalDate(rs.getDate("datumdogadjaja")).format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)) + "  -  " + rs.getString("sat") + "\n" + rs.getString("dogadjaj"));
                this.listaOir1.add((Object)ra);
                System.out.println("usao u popuni" + br);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(Oir1Controller.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(Oir1Controller.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.listaOir1.stream().forEach(s -> System.out.println(s.getDatumPrijave() + " " + s.getInspekcijaRada1() + "  " + s.getDatumDogadjaja()));
        this.tablicaPopisOir1.getItems().addAll(this.listaOir1);
    }

    private void ispis(ObservableList<Oir1> listaoir) {
        String idArray = "";
        for (int i = 0; i < listaoir.size(); ++i) {
            idArray = i == 0 ? idArray + String.valueOf(((Oir1)listaoir.get(i)).getId()) : idArray + "," + String.valueOf(((Oir1)listaoir.get(i)).getId());
        }
        String sql = " SELECT \noir1.*,\n  tvrtka.naziv_tvrtke, \n  tvrtka.adresa, \n  tvrtka.pbr, \n  tvrtka.mjesto\n\nFROM \n  public.oir1, \n  public.tvrtka\nWHERE \n  tvrtka.id = oir1.idtvrtka and oir1.id IN (select(unnest(ARRAY [" + idArray + "])))and idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "'";
        IspisReporta.ispisButtonSaSubreportom(sql, this.btnIspis, "OIR.jrxml");
    }

    private class ButtonCell
    extends TableCell<Oir1, Boolean> {
        Button cellButton = new Button("Pregled");

        ButtonCell() {
            this.cellButton.setId("btnPregled");
            this.cellButton.setContentDisplay(ContentDisplay.LEFT);
            this.cellButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    Oir1 ra;
                    int selectdIndex = PopisOir1Controller.this.tablicaPopisOir1.getSelectionModel().getSelectedIndex();
                    if (selectdIndex != -1 && (ra = (Oir1)PopisOir1Controller.this.tablicaPopisOir1.getSelectionModel().getSelectedItem()) != null) {
                        Template.getTamplate().showTemplate("oir1/Oir1.fxml", "anchorPanel", "/ro2/ro2.css");
                        Oir1Controller.getInstance().izmjenaUputnice(ra);
                        PopisOir1Controller.this.tablicaPopisOir1.getSelectionModel().clearSelection();
                    }
                }
            });
        }

        protected void updateItem(Boolean t, boolean empty) {
            super.updateItem((Object)t, empty);
            if (!empty) {
                this.setGraphic((Node)this.cellButton);
                this.cellButton.disableProperty().bind((ObservableValue)PopisOir1Controller.this.tablicaPopisOir1.getSelectionModel().selectedIndexProperty().isNotEqualTo(this.getTableRow().getIndex()));
            } else {
                this.setGraphic(null);
            }
        }
    }
}

