/*
 * Decompiled with CFR 0.152.
 */
package osposobljavanje;

import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import osposobljavanje.BazaOsposobljavanje;
import osposobljavanje.Osposobljavanje;
import osposobljavanje.UnosOsposobljavanjaController;
import zastitanaradu.GlavniPanelController;

public class PopisOsposobljavanjaController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<Osposobljavanje> tablicaPopisOsposobljavanja;
    @FXML
    private TableColumn<Osposobljavanje, String> kolPretraga;
    @FXML
    private TableColumn<Osposobljavanje, String> kolRedBr;
    @FXML
    private TableColumn<Osposobljavanje, String> kolOznaka;
    @FXML
    private TableColumn<Osposobljavanje, String> kolNaziv;
    @FXML
    private TableColumn<Osposobljavanje, String> kolVrstaOsposobljavanja;
    private static PopisOsposobljavanjaController instance;
    private final ObservableList<Osposobljavanje> listaOsposobljavanja = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static PopisOsposobljavanjaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediKoloneUTabliciOsposobljavanje();
        this.popuniTablicuOsposobljavanje();
        this.urediFilter(this.tablicaPopisOsposobljavanja);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Osposobljavanja")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos Osposobljavanja");
                GlavniPanelController.getInstance().nadodajPanel("Unos Osposobljavanja", "/osposobljavanje/UnosOsposobljavanja.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos Osposobljavanja", "/osposobljavanje/UnosOsposobljavanja.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            Osposobljavanje o;
            int selectdIndex = this.tablicaPopisOsposobljavanja.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (o = (Osposobljavanje)this.tablicaPopisOsposobljavanja.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Osposobljavanja")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos Osposobljavanja");
                    GlavniPanelController.getInstance().nadodajPanel("Unos Osposobljavanja", "/osposobljavanje/UnosOsposobljavanja.fxml");
                    UnosOsposobljavanjaController.getInstance().izmjenaOsposobljavanja(o);
                    this.tablicaPopisOsposobljavanja.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos Osposobljavanja", "/osposobljavanje/UnosOsposobljavanja.fxml");
                    UnosOsposobljavanjaController.getInstance().izmjenaOsposobljavanja(o);
                    this.tablicaPopisOsposobljavanja.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisOsposobljavanja.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati Osposobljavanje")).showAndWait()).get() == ButtonType.OK) {
                if (BazaOsposobljavanje.obrisiOsposobljavanje((Osposobljavanje)this.tablicaPopisOsposobljavanja.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuOsposobljavanje();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisano Osposobljavanje", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisano Osposobljavanje", 2, "Error graphic");
                }
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Oznaka", "Naziv", "Vrsta"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaOsposobljavanja, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Oznaka") ? pregled.getOznaka() != null && pregled.getOznaka().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv") ? pregled.getNazivOsposobljavanja() != null && pregled.getNazivOsposobljavanja().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Vrsta") && pregled.getVrstaOsposobljavanja() != null && pregled.getVrstaOsposobljavanja().toLowerCase().startsWith(lowerCaseFilter));
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediKoloneUTabliciOsposobljavanje() {
        this.tablicaPopisOsposobljavanja.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisOsposobljavanjaController.this.tablicaPopisOsposobljavanja.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory((Callback)new PropertyValueFactory("redBroj"));
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOsposobljavanja.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolOznaka.setCellValueFactory((Callback)new PropertyValueFactory("oznaka"));
        this.kolOznaka.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOsposobljavanja.widthProperty().divide(10.0));
        this.kolOznaka.setStyle("-fx-alignment: CENTER;");
        this.kolVrstaOsposobljavanja.setCellValueFactory((Callback)new PropertyValueFactory("vrstaOsposobljavanja"));
        this.kolVrstaOsposobljavanja.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOsposobljavanja.widthProperty().divide(5.0));
        this.kolVrstaOsposobljavanja.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellValueFactory((Callback)new PropertyValueFactory("nazivOsposobljavanja"));
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaPopisOsposobljavanja.widthProperty().divide(1.694915254237288));
        this.kolPretraga.setGraphic((Node)this.tbFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicu() {
        ResultSet rs = BazaOsposobljavanje.dajOsposobljavanja(GlavniPanelController.getOdabranaTvrtka());
        int br = 1;
        try {
            while (rs.next()) {
                Osposobljavanje o = new Osposobljavanje();
                o.setId(rs.getInt("id"));
                o.setRedBroj(String.valueOf(br));
                o.setOznaka(rs.getString("oznaka"));
                o.setNazivOsposobljavanja(rs.getString("nazivosposobljavanja"));
                if (rs.getString("nazivvrsteosposobljavanja") != null) {
                    o.setVrstaOsposobljavanja(rs.getString("nazivvrsteosposobljavanja"));
                } else {
                    o.setVrstaOsposobljavanja("");
                }
                o.setEk1a(rs.getBoolean("ek1a"));
                o.setEk1b(rs.getBoolean("ek1b"));
                o.setEk2(rs.getBoolean("ek2"));
                o.setLjecnickiPregled(rs.getBoolean("ljecnickipregled"));
                o.setEkZop(rs.getBoolean("ekzop"));
                o.setEkPP(rs.getBoolean("ekpp"));
                o.setNocniRad(rs.getBoolean("nocnirad"));
                this.listaOsposobljavanja.add((Object)o);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisOsposobljavanjaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisOsposobljavanjaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisOsposobljavanja.getItems().addAll(this.listaOsposobljavanja);
    }

    public void popuniTablicuOsposobljavanje() {
        this.tablicaPopisOsposobljavanja.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Random rng = new Random();
        Task<Void> task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaOsposobljavanja.clear();
        this.tablicaPopisOsposobljavanja.getItems().clear();
    }

    private Task<Void> createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisOsposobljavanjaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PopisOsposobljavanjaController.this.popuniTablicu();
                }
                finally {
                    Platform.runLater(() -> PopisOsposobljavanjaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }
}

