/*
 * Decompiled with CFR 0.152.
 */
package ostalipregledi;

import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import ostalipregledi.BazaPregled;
import ostalipregledi.Pregled;
import ostalipregledi.UnosPregledaController;
import zastitanaradu.GlavniPanelController;

public class PopisPregledaController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<Pregled> tablicaPopisPregleda;
    @FXML
    private TableColumn<Pregled, String> kolPretraga;
    @FXML
    private TableColumn<Pregled, String> kolRedBr;
    @FXML
    private TableColumn<Pregled, String> kolOznaka;
    @FXML
    private TableColumn<Pregled, String> kolNaziv;
    @FXML
    private TableColumn<Pregled, String> kolPeriodika;
    private static PopisPregledaController instance;
    private final ObservableList<Pregled> listaPregleda = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static PopisPregledaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediTablicuPopisPregleda();
        this.popuniTablicuPregledi();
        this.urediFilter(this.tablicaPopisPregleda);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos pregleda")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos pregleda");
                GlavniPanelController.getInstance().nadodajPanel("Unos pregleda", "/ostalipregledi/UnosPregleda.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos pregleda", "/ostalipregledi/UnosPregleda.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            Pregled p;
            int selectdIndex = this.tablicaPopisPregleda.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (p = (Pregled)this.tablicaPopisPregleda.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos pregleda")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos pregleda");
                    GlavniPanelController.getInstance().nadodajPanel("Unos pregleda", "/ostalipregledi/UnosPregleda.fxml");
                    UnosPregledaController.getInstance().izmjenaPregleda(p);
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos pregleda", "/ostalipregledi/UnosPregleda.fxml");
                    UnosPregledaController.getInstance().izmjenaPregleda(p);
                }
                this.tablicaPopisPregleda.getSelectionModel().clearSelection();
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisPregleda.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati pregled")).showAndWait()).get() == ButtonType.OK) {
                if (BazaPregled.obrisiPregled((Pregled)this.tablicaPopisPregleda.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuPregledi();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisan pregled", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan pregled", 2, "Error graphic");
                }
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Oznaka", "Naziv"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaPregleda, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Oznaka") ? pregled.getOznaka() != null && pregled.getOznaka().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv") && pregled.getNaziv() != null && pregled.getNaziv().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediTablicuPopisPregleda() {
        this.tablicaPopisPregleda.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisPregledaController.this.tablicaPopisPregleda.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cell -> ((Pregled)cell.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisPregleda.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolOznaka.setCellValueFactory(cell -> ((Pregled)cell.getValue()).oznakaProperty());
        this.kolOznaka.prefWidthProperty().bind((ObservableValue)this.tablicaPopisPregleda.widthProperty().divide(5.0));
        this.kolOznaka.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellValueFactory(cell -> ((Pregled)cell.getValue()).nazivProperty());
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaPopisPregleda.widthProperty().divide(1.694915254237288));
        this.kolNaziv.setStyle("-fx-alignment: CENTER;");
        this.kolPeriodika.setCellValueFactory(cell -> ((Pregled)cell.getValue()).periodikaProperty());
        this.kolPeriodika.prefWidthProperty().bind((ObservableValue)this.tablicaPopisPregleda.widthProperty().divide(10.0));
        this.kolPeriodika.setStyle("-fx-alignment: CENTER;");
        this.kolPretraga.setGraphic((Node)this.tbFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicu() {
        ResultSet rs = BazaPregled.dajPreglede(GlavniPanelController.getOdabranaTvrtka());
        Pregled p = null;
        int br = 1;
        try {
            while (rs.next()) {
                p = new Pregled();
                p.setId(rs.getInt("id"));
                p.setRedBroj(String.valueOf(br));
                p.setOznaka(rs.getString("oznaka"));
                p.setNaziv(rs.getString("naziv"));
                p.setPeriodika(rs.getString("periodika"));
                this.listaPregleda.add((Object)p);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisPregledaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisPregledaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisPregleda.getItems().addAll(this.listaPregleda);
    }

    public void popuniTablicuPregledi() {
        this.tablicaPopisPregleda.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaPregleda.clear();
        this.tablicaPopisPregleda.getItems().clear();
    }

    private Task createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisPregledaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PopisPregledaController.this.popuniTablicu();
                }
                finally {
                    Platform.runLater(() -> PopisPregledaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }
}

