/*
 * Decompiled with CFR 0.152.
 */
package postavke;

import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.Konekcija;
import com.sun.javafx.collections.ObservableListWrapper;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseButton;
import javafx.stage.Stage;
import javafx.util.Callback;
import login.PostavkeStatic;

public class PregledBazeController
implements Initializable {
    @FXML
    private TableView tablicaBaza;
    @FXML
    private TableColumn<ObservableList, String> kolNazivBaze;
    @FXML
    private TableColumn<ObservableList, String> kolOwner;
    @FXML
    private TableColumn<ObservableList, String> kolBSize;
    @FXML
    private TableView tablicaKorisnici;
    @FXML
    private TableColumn kolToken;
    @FXML
    private TableColumn kolImePrezime;
    @FXML
    private TableColumn kolUsername;
    @FXML
    private TableColumn kolHost;
    @FXML
    private TableColumn kolIPAdress;
    @FXML
    private TableColumn kolTvrtka;
    @FXML
    private TableColumn kolLogin;
    @FXML
    private TableView tablicaTabliceBaze;
    @FXML
    private TableColumn kolNazivTablice;
    @FXML
    private TableColumn kolTabSize;
    @FXML
    private TableColumn kolTabExsternalSize;
    private static PregledBazeController instance;
    private Stage scene;
    @FXML
    private Button btnLogovi;
    @FXML
    private TextField txtFilter;
    ProgressIndicator progressIndicator;
    ProgressIndicator progressIndicator1;

    public static PregledBazeController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.popuniTablicuBazaPregleda();
        this.txtFilter.setPromptText("Filter");
        this.txtFilter.setId("textField");
        this.btnLogovi.setOnAction(e -> {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati Logove");
            Optional result = alert.showAndWait();
            if (result.get() == ButtonType.OK) {
                if (PregledBazeController.obrisiLOgove()) {
                    this.tablicaKorisnici.getItems().clear();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisani logovi", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisani logovi", 2, "Error graphic");
                }
            }
        });
    }

    public void setScene(Stage s) {
        this.scene = s;
    }

    public void popuniTablicuBazaPregleda() {
        this.progressIndicator = new ProgressIndicator();
        this.tablicaBaza.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTaskBazaPregled();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.tablicaBaza.getItems().clear();
    }

    private Task createTaskBazaPregled() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PregledBazeController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PregledBazeController.this.dohvatiBaze(PregledBazeController.this.tablicaBaza);
                }
                finally {
                    Platform.runLater(() -> PregledBazeController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableView dohvatiBaze(TableView tableview) {
        Konekcija k = new Konekcija();
        tableview.setEditable(true);
        tableview.setOnMouseClicked(event -> {
            if (event.getButton().equals((Object)MouseButton.PRIMARY)) {
                int index = tableview.getSelectionModel().getSelectedIndex();
                ObservableListWrapper row = (ObservableListWrapper)tableview.getItems().get(index);
                this.popuniTablicuKorisniciPregleda((String)row.get(0));
                this.popuniTablicuTablicePregleda((String)row.get(0));
            }
        });
        ObservableList data = FXCollections.observableArrayList();
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = k.getConnection();
            stmt = conn.createStatement();
            String SQL = "  SELECT \n    datname AS DatabaseName\n    ,pg_catalog.pg_get_userbyid(datdba) AS OwnerName\n    ,CASE \n        WHEN pg_catalog.has_database_privilege(datname, 'CONNECT')\n        THEN pg_catalog.pg_size_pretty(pg_catalog.pg_database_size(datname))\n        ELSE 'No Access For You'\n    END AS DatabaseSize\nFROM pg_catalog.pg_database \nWHERE datistemplate = false and datname not in ('template0', 'template1')\nORDER BY \n    CASE \n        WHEN pg_catalog.has_database_privilege(datname, 'CONNECT')\n        THEN pg_catalog.pg_database_size(datname)\n        ELSE NULL\n    END DESC;";
            ResultSet rs = stmt.executeQuery(SQL);
            this.kolNazivBaze.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                    return new SimpleStringProperty(((ObservableList)param.getValue()).get(0).toString());
                }
            });
            this.kolNazivBaze.prefWidthProperty().bind((ObservableValue)this.tablicaBaza.widthProperty().divide(2.0));
            this.kolOwner.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                    return new SimpleStringProperty(((ObservableList)param.getValue()).get(1).toString());
                }
            });
            this.kolOwner.prefWidthProperty().bind((ObservableValue)this.tablicaBaza.widthProperty().divide(3.3333333333333335));
            this.kolBSize.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                    return new SimpleStringProperty(((ObservableList)param.getValue()).get(2).toString());
                }
            });
            this.kolBSize.prefWidthProperty().bind((ObservableValue)this.tablicaBaza.widthProperty().divide(3.4482758620689653));
            while (rs.next()) {
                ObservableList row = FXCollections.observableArrayList();
                for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                    row.add((Object)rs.getString(i));
                }
                data.add((Object)row);
            }
            tableview.setItems(data);
        }
        catch (Exception e) {
            FxDialogs.showException("Gre\u0161ka spajanja sa bazom", "ERROR: ", e);
            e.printStackTrace();
            System.out.println("Error on Building Data");
        }
        finally {
            try {
                conn.close();
                stmt.close();
            }
            catch (SQLException ex) {
                FxDialogs.showException("Gre\u0161ka spajanja sa bazom", "ERROR: ", ex);
                Logger.getLogger(PregledBazeController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return tableview;
    }

    public void popuniTablicuKorisniciPregleda(String nazivBaze) {
        this.progressIndicator1 = new ProgressIndicator();
        this.tablicaKorisnici.setPlaceholder((Node)this.progressIndicator1);
        this.progressIndicator1.setMaxSize(200.0, 200.0);
        this.progressIndicator1.setVisible(true);
        Task task = this.createTaskKorisnikPregled(nazivBaze);
        new Thread((Runnable)task).start();
        this.progressIndicator1.progressProperty().bind((ObservableValue)task.progressProperty());
        this.tablicaKorisnici.getItems().clear();
    }

    private Task createTaskKorisnikPregled(final String nazivBaze) {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PregledBazeController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PregledBazeController.this.dohvatiKorisnike(nazivBaze);
                }
                finally {
                    Platform.runLater(() -> PregledBazeController.this.progressIndicator1.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dohvatiKorisnike(String nazivBaze) {
        Konekcija k = new Konekcija(PostavkeStatic.getBazaServerNaziv(), PostavkeStatic.getBazaServerPort(), nazivBaze, PostavkeStatic.getBazaKorisnik(), PostavkeStatic.getBazaLozinka());
        ObservableList data = FXCollections.observableArrayList();
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = k.getConnection();
            stmt = conn.createStatement();
            String SQL = "        SELECT      token, imeprezime, djelatnici.username, hostname, ipadrress, djelatnici.tvrtka as nazivtvrtke, \n       logindate\n  FROM loginfo , pg_catalog.pg_database,djelatnici  where  datname ='" + nazivBaze + "' and loginfo.iddjelatnik=djelatnici.id order by logindate";
            ResultSet rs = stmt.executeQuery(SQL);
            this.kolToken.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                    return new SimpleStringProperty(((ObservableList)param.getValue()).get(0).toString());
                }
            });
            this.kolToken.prefWidthProperty().bind((ObservableValue)this.tablicaKorisnici.widthProperty().divide(5.0));
            this.kolImePrezime.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                    return new SimpleStringProperty(((ObservableList)param.getValue()).get(1).toString());
                }
            });
            this.kolImePrezime.prefWidthProperty().bind((ObservableValue)this.tablicaKorisnici.widthProperty().divide(6.666666666666667));
            this.kolUsername.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                    return new SimpleStringProperty(((ObservableList)param.getValue()).get(2).toString());
                }
            });
            this.kolUsername.prefWidthProperty().bind((ObservableValue)this.tablicaKorisnici.widthProperty().divide(10.0));
            this.kolHost.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                    return new SimpleStringProperty(((ObservableList)param.getValue()).get(3).toString());
                }
            });
            this.kolHost.prefWidthProperty().bind((ObservableValue)this.tablicaKorisnici.widthProperty().divide(6.666666666666667));
            this.kolIPAdress.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                    return new SimpleStringProperty(((ObservableList)param.getValue()).get(4).toString());
                }
            });
            this.kolIPAdress.prefWidthProperty().bind((ObservableValue)this.tablicaKorisnici.widthProperty().divide(10.0));
            this.kolTvrtka.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                    return new SimpleStringProperty(((ObservableList)param.getValue()).get(5) != null ? ((ObservableList)param.getValue()).get(5).toString() : "");
                }
            });
            this.kolTvrtka.prefWidthProperty().bind((ObservableValue)this.tablicaKorisnici.widthProperty().divide(6.666666666666667));
            this.kolLogin.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                    return new SimpleStringProperty(((ObservableList)param.getValue()).get(6) != null ? ((ObservableList)param.getValue()).get(6).toString() : "");
                }
            });
            this.kolLogin.prefWidthProperty().bind((ObservableValue)this.tablicaKorisnici.widthProperty().divide(6.666666666666667));
            while (rs.next()) {
                ObservableList row = FXCollections.observableArrayList();
                for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                    row.add((Object)rs.getString(i));
                }
                data.add((Object)row);
            }
            this.tablicaKorisnici.setItems(data);
            this.popuniFilter(this.tablicaKorisnici);
            this.btnLogovi.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tablicaKorisnici.getItems()).isEqualTo(0));
            this.txtFilter.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.tablicaKorisnici.getItems()).isEqualTo(0));
        }
        catch (Exception e) {
            FxDialogs.showException("Gre\u0161ka spajanja sa bazom", "ERROR: ", e);
            e.printStackTrace();
            System.out.println("Error on Building Data");
        }
        finally {
            try {
                conn.close();
                stmt.close();
            }
            catch (SQLException ex) {
                FxDialogs.showException("Gre\u0161ka spajanja sa bazom", "ERROR: ", ex);
                Logger.getLogger(PregledBazeController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void popuniTablicuTablicePregleda(String nazivBaze) {
        this.progressIndicator = new ProgressIndicator();
        this.tablicaTabliceBaze.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTaskTablicePregled(nazivBaze);
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.tablicaTabliceBaze.getItems().clear();
    }

    private Task createTaskTablicePregled(final String nazivBaze) {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PregledBazeController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PregledBazeController.this.dohvatiTablice(nazivBaze);
                }
                finally {
                    Platform.runLater(() -> PregledBazeController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dohvatiTablice(String nazivBaze) {
        Konekcija k = new Konekcija(PostavkeStatic.getBazaServerNaziv(), PostavkeStatic.getBazaServerPort(), nazivBaze, PostavkeStatic.getBazaKorisnik(), PostavkeStatic.getBazaLozinka());
        ObservableList data = FXCollections.observableArrayList();
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = k.getConnection();
            stmt = conn.createStatement();
            String SQL = "    SELECT\n   relname as \"Table\",\n   pg_size_pretty(pg_total_relation_size(relid)) As \"Size\",\n   pg_size_pretty(pg_total_relation_size(relid) - pg_relation_size(relid)) as \"External Size\"\n   FROM pg_catalog.pg_statio_user_tables , pg_catalog.pg_database where  datname ='" + nazivBaze + "' ORDER BY pg_total_relation_size(relid) DESC limit 10;";
            ResultSet rs = stmt.executeQuery(SQL);
            this.kolNazivTablice.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                    return new SimpleStringProperty(((ObservableList)param.getValue()).get(0).toString());
                }
            });
            this.kolNazivTablice.prefWidthProperty().bind((ObservableValue)this.tablicaTabliceBaze.widthProperty().divide(2.0));
            this.kolTabSize.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                    return new SimpleStringProperty(((ObservableList)param.getValue()).get(1).toString());
                }
            });
            this.kolTabSize.prefWidthProperty().bind((ObservableValue)this.tablicaTabliceBaze.widthProperty().divide(4.0));
            this.kolTabExsternalSize.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<ObservableList, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<ObservableList, String> param) {
                    return new SimpleStringProperty(((ObservableList)param.getValue()).get(2).toString());
                }
            });
            this.kolTabExsternalSize.prefWidthProperty().bind((ObservableValue)this.tablicaTabliceBaze.widthProperty().divide(4.3478260869565215));
            while (rs.next()) {
                ObservableList row = FXCollections.observableArrayList();
                for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                    row.add((Object)rs.getString(i));
                }
                data.add((Object)row);
            }
            this.tablicaTabliceBaze.setItems(data);
        }
        catch (Exception e) {
            FxDialogs.showException("Gre\u0161ka spajanja sa bazom", "ERROR: ", e);
            e.printStackTrace();
            System.out.println("Error on Building Data");
        }
        finally {
            try {
                conn.close();
                stmt.close();
            }
            catch (SQLException ex) {
                FxDialogs.showException("Gre\u0161ka spajanja sa bazom", "ERROR: ", ex);
                Logger.getLogger(PregledBazeController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    static boolean obrisiLOgove() {
        Konekcija k = new Konekcija();
        String sql = "delete from loginfo";
        KlasaKorisneMetode.ispisiSql(sql);
        boolean uspjelo = k.executeUpdate(sql, true);
        return uspjelo;
    }

    private void popuniFilter(final TableView tablicaKorisnici) {
        final ObservableList dataList = tablicaKorisnici.getItems();
        this.txtFilter.textProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                if (((String)PregledBazeController.this.txtFilter.textProperty().get()).isEmpty()) {
                    tablicaKorisnici.setItems(dataList);
                    return;
                }
                ObservableList tableItems = FXCollections.observableArrayList();
                ObservableList cols = tablicaKorisnici.getColumns();
                block0: for (int i = 0; i < dataList.size(); ++i) {
                    for (int j = 0; j < cols.size(); ++j) {
                        TableColumn col = (TableColumn)cols.get(j);
                        String cellValue = col.getCellData(dataList.get(i)).toString();
                        if (!(cellValue = cellValue.toLowerCase()).contains(((String)PregledBazeController.this.txtFilter.textProperty().get()).toLowerCase())) continue;
                        tableItems.add(dataList.get(i));
                        continue block0;
                    }
                }
                tablicaKorisnici.setItems(tableItems);
            }
        });
    }
}

