/*
 * Decompiled with CFR 0.152.
 */
package pregledivatrogasniaparati;

import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import pregledivatrogasniaparati.BazaVAPregled;
import pregledivatrogasniaparati.PregledVA;
import pregledivatrogasniaparati.UnosPregledaVAController;
import zastitanaradu.GlavniPanelController;

public class PopisPregledaVAController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<PregledVA> tablicaPopisVAPregleda;
    @FXML
    private TableColumn<PregledVA, String> kolPretraga;
    @FXML
    private TableColumn<PregledVA, String> kolRedBr;
    @FXML
    private TableColumn<PregledVA, String> kolOznaka;
    @FXML
    private TableColumn<PregledVA, String> kolNaziv;
    private static PopisPregledaVAController instance;
    private final ObservableList<PregledVA> listaVAPregledi = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static PopisPregledaVAController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediKoloneUTabliciVAPregled();
        this.popuniTablicuVAPregled();
        this.urediFilter(this.tablicaPopisVAPregleda);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos VA pregled")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos VA pregled");
                GlavniPanelController.getInstance().nadodajPanel("Unos VA pregled", "/pregledivatrogasniaparati/UnosPregledaVA.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos VA pregled", "/pregledivatrogasniaparati/UnosPregledaVA.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            PregledVA lp;
            int selectdIndex = this.tablicaPopisVAPregleda.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (lp = (PregledVA)this.tablicaPopisVAPregleda.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos VA pregled")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos VA pregled");
                    GlavniPanelController.getInstance().nadodajPanel("Unos VA pregled", "/pregledivatrogasniaparati/UnosPregledaVA.fxml");
                    UnosPregledaVAController.getInstance().izmjenaVAPregled(lp);
                    this.tablicaPopisVAPregleda.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos VA pregled", "/pregledivatrogasniaparati/UnosPregledaVA.fxml");
                    UnosPregledaVAController.getInstance().izmjenaVAPregled(lp);
                    this.tablicaPopisVAPregleda.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisVAPregleda.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati  pregled")).showAndWait()).get() == ButtonType.OK) {
                if (BazaVAPregled.obrisiVAPregled((PregledVA)this.tablicaPopisVAPregleda.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuVAPregled();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisano  pregled", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan  pregled", 2, "Error graphic");
                }
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Oznaka", "Naziv"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaVAPregledi, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Oznaka") ? pregled.getOznakaPregledaVA() != null && pregled.getOznakaPregledaVA().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv") && pregled.getNazivPregledaVA() != null && pregled.getNazivPregledaVA().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediKoloneUTabliciVAPregled() {
        this.tablicaPopisVAPregleda.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisPregledaVAController.this.tablicaPopisVAPregleda.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cell -> ((PregledVA)cell.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisVAPregleda.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolOznaka.setCellValueFactory(cell -> ((PregledVA)cell.getValue()).oznakaPregledaVAProperty());
        this.kolOznaka.prefWidthProperty().bind((ObservableValue)this.tablicaPopisVAPregleda.widthProperty().divide(5.0));
        this.kolOznaka.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellValueFactory(cell -> ((PregledVA)cell.getValue()).nazivPregledaVAProperty());
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaPopisVAPregleda.widthProperty().divide(1.694915254237288));
        this.kolPretraga.setGraphic((Node)this.tbFilter);
    }

    public void popuniTablicuVAPregled() {
        this.tablicaPopisVAPregleda.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaVAPregledi.clear();
        this.tablicaPopisVAPregleda.getItems().clear();
    }

    private Task createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisPregledaVAController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PopisPregledaVAController.this.popuniTablicu();
                }
                finally {
                    Platform.runLater(() -> PopisPregledaVAController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicu() {
        ResultSet rs = BazaVAPregled.dajVAPregled(GlavniPanelController.getOdabranaTvrtka());
        int br = 1;
        try {
            while (rs.next()) {
                PregledVA pva = new PregledVA();
                pva.setId(rs.getInt("id"));
                pva.setRedBroj(String.valueOf(br));
                pva.setOznakaPregledaVA(rs.getString("oznaka"));
                pva.setNazivPregledaVA(rs.getString("naziv"));
                pva.setEkva(rs.getBoolean("ekva"));
                this.listaVAPregledi.add((Object)pva);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisPregledaVAController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisPregledaVAController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisVAPregleda.getItems().addAll(this.listaVAPregledi);
    }
}

