/*
 * Decompiled with CFR 0.152.
 */
package profesionalnabolest;

import TamplatePaneli.Template;
import Utill.DateCell;
import Utill.DateUtil;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import ispisJasper.IspisReporta;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import profesionalnabolest.BazaProfesionalnaBolest;
import profesionalnabolest.ProfesionalnaBolest;
import profesionalnabolest.UnosProfesionalneBolestiController;
import zastitanaradu.GlavniPanelController;

public class PregledProfesionalnihBolestiController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private Button btnIspis;
    @FXML
    private TableView<ProfesionalnaBolest> tablicaPopisProfBolesti;
    @FXML
    private TableColumn<ProfesionalnaBolest, String> kolPretraga;
    @FXML
    private TableColumn<ProfesionalnaBolest, String> kolRedBr;
    @FXML
    private TableColumn<ProfesionalnaBolest, LocalDate> kolDatumIzdavanja;
    @FXML
    private TableColumn<ProfesionalnaBolest, String> kolOib;
    @FXML
    private TableColumn<ProfesionalnaBolest, String> kolNaziv;
    private static PregledProfesionalnihBolestiController instance;
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;
    private final ObservableList<ProfesionalnaBolest> listaBolesti = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();

    public static PregledProfesionalnihBolestiController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediTablicuPopisBolesti();
        this.popuniTablicuPopisBolesti();
        this.urediFilter(this.tablicaPopisProfBolesti);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos profesionalne bolesti")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos profesionalne bolesti");
                GlavniPanelController.getInstance().nadodajPanel("Unos profesionalne bolesti", "/profesionalnabolest/UnosProfesionalneBolesti.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos profesionalne bolesti", "/profesionalnabolest/UnosProfesionalneBolesti.fxml");
            }
        });
        this.btnPromjena.setOnAction(event -> {
            ProfesionalnaBolest pb;
            int selectdIndex = this.tablicaPopisProfBolesti.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (pb = (ProfesionalnaBolest)this.tablicaPopisProfBolesti.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos profesionalne bolesti")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos profesionalne bolesti");
                    GlavniPanelController.getInstance().nadodajPanel("Unos profesionalne bolesti", "/profesionalnabolest/UnosProfesionalneBolesti.fxml");
                    UnosProfesionalneBolestiController.getInstance().izmjenaPrijave(pb);
                    this.tablicaPopisProfBolesti.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos profesionalne bolesti", "/profesionalnabolest/UnosProfesionalneBolesti.fxml");
                    UnosProfesionalneBolestiController.getInstance().izmjenaPrijave(pb);
                    this.tablicaPopisProfBolesti.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisProfBolesti.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati prijavu")).showAndWait()).get() == ButtonType.OK) {
                if (BazaProfesionalnaBolest.obrisiPrijavu((ProfesionalnaBolest)this.tablicaPopisProfBolesti.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuPopisBolesti();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisana prijava", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisana prijava", 2, "Error graphic");
                }
            }
        });
        this.btnIspis.setOnAction(e -> {
            int selectdIndex = this.tablicaPopisProfBolesti.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                this.ispis((ObservableList<ProfesionalnaBolest>)this.tablicaPopisProfBolesti.getSelectionModel().getSelectedItems());
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Naziv", "OIB"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediTablicuPopisBolesti() {
        this.tablicaPopisProfBolesti.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tablicaPopisProfBolesti.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PregledProfesionalnihBolestiController.this.tablicaPopisProfBolesti.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cellData -> ((ProfesionalnaBolest)cellData.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisProfBolesti.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory = param -> new DateCell();
        this.kolDatumIzdavanja.setCellValueFactory(cellData -> ((ProfesionalnaBolest)cellData.getValue()).datumPodnosenjaPrijaveProperty());
        this.kolDatumIzdavanja.setCellFactory(dateCellFactory);
        this.kolDatumIzdavanja.prefWidthProperty().bind((ObservableValue)this.tablicaPopisProfBolesti.widthProperty().divide(5.0));
        this.kolDatumIzdavanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumIzdavanja.setEditable(false);
        this.kolOib.setCellValueFactory(cellData -> ((ProfesionalnaBolest)cellData.getValue()).txt12Property());
        this.kolOib.prefWidthProperty().bind((ObservableValue)this.tablicaPopisProfBolesti.widthProperty().divide(3.3333333333333335));
        this.kolOib.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellValueFactory(cellData -> ((ProfesionalnaBolest)cellData.getValue()).txt9Property());
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaPopisProfBolesti.widthProperty().divide(3.3333333333333335));
        this.kolNaziv.setStyle("-fx-alignment: CENTER;");
        TableColumn kolPregledOzljeda = new TableColumn("Pregled");
        kolPregledOzljeda.setSortable(false);
        kolPregledOzljeda.prefWidthProperty().bind((ObservableValue)this.tablicaPopisProfBolesti.widthProperty().divide(10.0));
        kolPregledOzljeda.setStyle("-fx-alignment: CENTER;");
        kolPregledOzljeda.setCellFactory((Callback)new Callback<TableColumn<ProfesionalnaBolest, Boolean>, TableCell<ProfesionalnaBolest, Boolean>>(){

            public TableCell<ProfesionalnaBolest, Boolean> call(TableColumn<ProfesionalnaBolest, Boolean> param) {
                return new ButtonCell();
            }
        });
        this.kolPretraga.setGraphic((Node)this.tbFilter);
        this.kolPretraga.getColumns().add((Object)kolPregledOzljeda);
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaBolesti, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv") ? pregled.getTxt9() != null && pregled.getTxt9().toLowerCase().contains(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("OIB") && pregled.getTxt12() != null && pregled.getTxt12().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuBolesti(ResultSet rs) {
        ProfesionalnaBolest pb = null;
        int br = 1;
        try {
            while (rs.next()) {
                pb = new ProfesionalnaBolest();
                pb.setId(rs.getInt("id"));
                pb.setIdHzzo(rs.getInt("idhzzo"));
                pb.setRedBroj(String.valueOf(br));
                pb.setTxt1(rs.getString("a1"));
                pb.setTxt2(rs.getString("a2"));
                pb.setTxt3(rs.getString("a3"));
                pb.setTxt4(rs.getString("a4"));
                pb.setTxt5(rs.getString("a5"));
                pb.setTxt6(rs.getString("a6"));
                pb.setTxt7(rs.getString("a7"));
                pb.setTxt8(rs.getString("a8"));
                pb.setTxt9(rs.getString("b9"));
                pb.setDatum10(DateUtil.getLocalDate(rs.getDate("b10")));
                pb.setTxt11Ulica(rs.getString("b11ulica"));
                pb.setTxt11KCbr(rs.getString("b11kcbr"));
                pb.setTxt11Mjesto(rs.getString("b11mjesto"));
                pb.setTxt11PBr(rs.getString("b11pbr"));
                pb.setTxt11Tel(rs.getString("b11tel"));
                pb.setTxt11Email(rs.getString("b11email"));
                pb.setTxt12(rs.getString("b12"));
                pb.setTxt13(rs.getString("b13"));
                pb.setTxt14(rs.getString("b14"));
                pb.setTxt15(rs.getString("b15"));
                pb.setTxt15Nazivdrzavljanstva(rs.getString("b15drzavljanstvo"));
                pb.setTxt16(rs.getString("b16"));
                pb.setTxt17(rs.getString("b17"));
                pb.setTxt18(rs.getString("b18"));
                pb.setTxt19Zanimanje(rs.getString("b19zanimanje"));
                pb.setTxt19OD(rs.getString("b19od"));
                pb.setTxt19DO(rs.getString("b19do"));
                pb.setTxt20a(rs.getString("b20a"));
                pb.setTxt20b(rs.getString("b20b"));
                pb.setTxt20c(rs.getString("b20c"));
                pb.setTxt21Sifra(rs.getString("b21sifra"));
                pb.setTxt21(rs.getString("b21pregledi"));
                pb.setTxt22(rs.getString("b22"));
                pb.setTxt23(rs.getString("b23"));
                pb.setTxt24(rs.getString("b24"));
                pb.setTxt25(rs.getString("b25"));
                pb.setTxt26(rs.getString("b26"));
                pb.setTxt27Ime(rs.getString("c27ime"));
                pb.setTxt27Tel(rs.getString("c27tel"));
                pb.setTxt28Adresa(rs.getString("c28adresa"));
                pb.setTxt28Email(rs.getString("c28email"));
                pb.setDatumPodnosenjaPrijave(DateUtil.getLocalDate(rs.getDate("datumpodnosenjaprijave")));
                pb.setOdgovornaOsoba(rs.getString("imeprezimeodgovorneosobe"));
                this.listaBolesti.add((Object)pb);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PregledProfesionalnihBolestiController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PregledProfesionalnihBolestiController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisProfBolesti.getItems().addAll(this.listaBolesti);
    }

    public void popuniTablicuPopisBolesti() {
        this.tablicaPopisProfBolesti.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaBolesti.clear();
        this.tablicaPopisProfBolesti.getItems().clear();
    }

    private Task createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PregledProfesionalnihBolestiController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    ResultSet rs = BazaProfesionalnaBolest.dajBolesti(GlavniPanelController.getOdabranaTvrtka());
                    PregledProfesionalnihBolestiController.this.popuniTablicuBolesti(rs);
                }
                finally {
                    Platform.runLater(() -> PregledProfesionalnihBolestiController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    private void ispis(ObservableList<ProfesionalnaBolest> listaBolesti) {
        String idArray = "";
        for (int i = 0; i < listaBolesti.size(); ++i) {
            idArray = i == 0 ? idArray + String.valueOf(((ProfesionalnaBolest)listaBolesti.get(i)).getId()) : idArray + "," + String.valueOf(((ProfesionalnaBolest)listaBolesti.get(i)).getId());
        }
        String sql = "SELECT \n  hzzo.naziv, \n  hzzo.sifra, \n  hzzo.adresa, \n  hzzo.mjesto, \n  hzzo.telefon, \n  hzzo.fax,\n  profesionalnabolest.*\nFROM \n  public.profesionalnabolest, \n  public.hzzo\nWHERE \n  profesionalnabolest.idhzzo = hzzo.id  and profesionalnabolest.id IN (select(unnest(ARRAY [" + idArray + "])))and profesionalnabolest.idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "'";
        IspisReporta.ispisButtonSaSubreportom(sql, this.btnIspis, "PrijavaOProfesionalnojBolesti.jrxml");
    }

    private class ButtonCell
    extends TableCell<ProfesionalnaBolest, Boolean> {
        Button cellButton = new Button("Pregled");

        ButtonCell() {
            this.cellButton.setId("btnPregled");
            this.cellButton.setContentDisplay(ContentDisplay.LEFT);
            this.cellButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    ProfesionalnaBolest ra;
                    int selectdIndex = PregledProfesionalnihBolestiController.this.tablicaPopisProfBolesti.getSelectionModel().getSelectedIndex();
                    if (selectdIndex != -1 && (ra = (ProfesionalnaBolest)PregledProfesionalnihBolestiController.this.tablicaPopisProfBolesti.getSelectionModel().getSelectedItem()) != null) {
                        GlavniPanelController.getInstance().setBlurEfekt(new GaussianBlur(10.0));
                        Template.getTamplate().showTemplate("profesionalnabolest/UnosProfesionalneBolesti.fxml", "anchorPanel");
                        UnosProfesionalneBolestiController.getInstance().izmjenaPrijave(ra);
                        PregledProfesionalnihBolestiController.this.tablicaPopisProfBolesti.getSelectionModel().clearSelection();
                    }
                }
            });
        }

        protected void updateItem(Boolean t, boolean empty) {
            super.updateItem((Object)t, empty);
            if (!empty) {
                this.setGraphic((Node)this.cellButton);
                this.cellButton.disableProperty().bind((ObservableValue)PregledProfesionalnihBolestiController.this.tablicaPopisProfBolesti.getSelectionModel().selectedIndexProperty().isNotEqualTo(this.getTableRow().getIndex()));
            } else {
                this.setGraphic(null);
            }
        }
    }
}

