/*
 * Decompiled with CFR 0.152.
 */
package radnaoprema;

import Utill.FxUtilTest;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TableCell;
import javafx.util.Callback;
import javafx.util.StringConverter;
import kadrovska.Djelatnik;
import radnaoprema.BazaStroj;
import radnaoprema.StrojZaduzeneOsobe;

public class ComboBoxCellDjelatnici
extends TableCell<StrojZaduzeneOsobe, String> {
    private ComboBox<Djelatnik> comboBox;

    ComboBoxCellDjelatnici(ObservableList<Djelatnik> listaDjelatnika, String pretraga) {
        this.comboBox = new ComboBox(listaDjelatnika);
        if (pretraga.toLowerCase().equals("prezime")) {
            this.comboBox.setPromptText("Pretraga po prezimenu");
            FxUtilTest.autoCompleteComboBoxPlus(this.comboBox, (typedText, itemToCompare) -> itemToCompare.getPrezime().toLowerCase().startsWith(typedText.toLowerCase()));
        }
        if (pretraga.toLowerCase().equals("sifra")) {
            this.comboBox.setPromptText("Pretraga po \u0161ifri");
            FxUtilTest.autoCompleteComboBoxPlus(this.comboBox, (typedText, itemToCompare) -> itemToCompare.getSifraDjelatnika().toLowerCase().startsWith(typedText.toLowerCase()));
        }
        FxUtilTest.getComboBoxValue(this.comboBox);
        this.comboBox.setConverter((StringConverter)new StringConverter<Djelatnik>(){

            public String toString(Djelatnik rm) {
                if (rm == null) {
                    return null;
                }
                return rm.getPrezime() + " " + rm.getIme();
            }

            public Djelatnik fromString(String userId) {
                return null;
            }
        });
        this.comboBox.setCellFactory((Callback)new Callback<ListView<Djelatnik>, ListCell<Djelatnik>>(){

            public ListCell<Djelatnik> call(ListView<Djelatnik> p) {
                ListCell<Djelatnik> cell = new ListCell<Djelatnik>(){

                    protected void updateItem(Djelatnik t, boolean bln) {
                        super.updateItem((Object)t, bln);
                        if (t != null) {
                            this.setText(t.getPrezime() + " " + t.getIme() + "  |  " + t.getSifraDjelatnika());
                        } else {
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        });
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.comboBox.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
            this.comboBox.setOnAction(e -> {
                Djelatnik d = (Djelatnik)this.comboBox.getSelectionModel().getSelectedItem();
                if (d != null) {
                    this.commitEdit(d.getPrezime() + " " + d.getIme());
                    ((StrojZaduzeneOsobe)this.getTableView().getSelectionModel().getSelectedItem()).setSifraOsobe(d.getSifraDjelatnika());
                    ((StrojZaduzeneOsobe)this.getTableView().getSelectionModel().getSelectedItem()).setNazivOsobe(d.getPrezime() + " " + d.getIme());
                    BazaStroj.unesiPromjenuZaduzeneOsobe((StrojZaduzeneOsobe)this.getTableView().getSelectionModel().getSelectedItem());
                }
            });
            this.setText(null);
            this.setGraphic((Node)this.comboBox);
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText((String)this.getItem());
        this.setGraphic(null);
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            this.setText(null);
            this.setGraphic((Node)this.comboBox);
        } else {
            this.setText((String)this.getItem());
            this.setGraphic(null);
        }
    }

    private String getString() {
        return this.getItem() == null ? "" : (String)this.getItem();
    }
}

