/*
 * Decompiled with CFR 0.152.
 */
package radnaoprema;

import TamplatePaneli.Template;
import Utill.DateUtil;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import filter.MenuButtonReporti;
import ispisJasper.IspisJasperButtonSaSubreportom;
import ispisJasper.IspisReporta;
import ispisJasper.JasperViewerFX;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import net.sf.jasperreports.engine.JasperPrint;
import radnaoprema.BazaStroj;
import radnaoprema.StrojEvidencija;
import radnaoprema.UnosStrojevaController;
import zastitanaradu.GlavniPanelController;

public class PopisEvidencijeStrojaController
implements Initializable {
    @FXML
    private AnchorPane anchorPanelStroj;
    @FXML
    private Button btnIspis;
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<StrojEvidencija> tablicaPopisStrojeva;
    @FXML
    private TableColumn<StrojEvidencija, String> kolPretraga;
    @FXML
    private TableColumn<StrojEvidencija, String> kolRedBr;
    @FXML
    private TableColumn<StrojEvidencija, String> kolSifraStroja;
    @FXML
    private TableColumn<StrojEvidencija, String> kolNazivStroja;
    @FXML
    private TableColumn<StrojEvidencija, String> kolPoslovnica;
    @FXML
    private TableColumn<StrojEvidencija, String> kolInvBroj;
    @FXML
    private TableColumn<StrojEvidencija, String> kolTvBroj;
    private static PopisEvidencijeStrojaController instance;
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;
    private final ObservableList<StrojEvidencija> listaStrojeva = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    @FXML
    private MenuButton btnIspis1;

    public static PopisEvidencijeStrojaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFIlter();
        this.popuniButtonIspis();
        this.urediTablicuPopisStrojeva();
        this.popuniTablicuPopisStrojeva();
        this.urediFilter(this.tablicaPopisStrojeva);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Stroja")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos Stroja");
                GlavniPanelController.getInstance().nadodajPanel("Unos Stroja", "/radnaoprema/UnosStrojeva.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos Stroja", "/radnaoprema/UnosStrojeva.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            StrojEvidencija se;
            int selectdIndex = this.tablicaPopisStrojeva.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (se = (StrojEvidencija)this.tablicaPopisStrojeva.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos Stroja")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos Stroja");
                    GlavniPanelController.getInstance().nadodajPanel("Unos Stroja", "/radnaoprema/UnosStrojeva.fxml");
                    UnosStrojevaController.getInstance().izmjenaStroja(se);
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos Stroja", "/radnaoprema/UnosStrojeva.fxml");
                    UnosStrojevaController.getInstance().izmjenaStroja(se);
                }
                this.tablicaPopisStrojeva.getSelectionModel().clearSelection();
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisStrojeva.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati stroj")).showAndWait()).get() == ButtonType.OK) {
                boolean uspjelo = BazaStroj.obrisiStroj((StrojEvidencija)this.tablicaPopisStrojeva.getSelectionModel().getSelectedItem(), GlavniPanelController.getOdabranaTvrtka());
                System.out.println("uspjelo brisanje  " + uspjelo);
                if (uspjelo) {
                    this.popuniTablicuPopisStrojeva();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisan stroj", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan stroj", 2, "Error graphic");
                }
            }
        });
        this.btnIspis.setOnAction(e -> {
            int selectdIndex = this.tablicaPopisStrojeva.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                this.ispisKartonStroja((ObservableList<StrojEvidencija>)this.tablicaPopisStrojeva.getSelectionModel().getSelectedItems());
            }
        });
    }

    void popuniButtonIspis() {
        this.btnIspis1.disableProperty().bind((ObservableValue)this.tablicaPopisStrojeva.getSelectionModel().selectedItemProperty().isNull());
        MenuItem kartonStroja = new MenuItem("Ispis karton stroja");
        kartonStroja.setOnAction(event -> {
            int selectdIndex = this.tablicaPopisStrojeva.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                ObservableList listaStrojeva = this.tablicaPopisStrojeva.getSelectionModel().getSelectedItems();
                String idArray = "";
                for (int i = 0; i < listaStrojeva.size(); ++i) {
                    idArray = i == 0 ? idArray + String.valueOf(((StrojEvidencija)listaStrojeva.get(i)).getId()) : idArray + "," + String.valueOf(((StrojEvidencija)listaStrojeva.get(i)).getId());
                }
                String sql = "SELECT DISTINCT  strojevi.id, strojevi.idtvrtka,  strojevi.nazivstroja, strojevi.model, strojevi.tvornickibroj, strojevi.inventurnibroj, strojevi.godinaproizvodnje, strojevi.datumstavljanjaupogon,  strojevi.vrstastroja,  strojevi.napomena,  strojevi.proizvodjac,  strojevi.sifrastroja, strojevi.rashodovan,  odjeli.nazivodjela  ,  poslovnejedinice.nazivposlovnice ,   nazivstroja.naziv,   nazivstroja.oznaka FROM \n  public.strojevi,   public.grupastrojeva,   public.poslovnejedinice,   public.odjeli,   public.nazivstroja WHERE   strojevi.grupastrojeva = grupastrojeva.id AND    strojevi.poslovnajedinica = poslovnejedinice.id AND    strojevi.odjel = odjeli.id AND    nazivstroja.id = strojevi.idstroja  and strojevi.id IN (select(unnest(ARRAY [" + idArray + "])))  and idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "' ";
                IspisReporta.ispisMenuButtonSaSubReportom(sql, this.btnIspis1, "IspisStrojeva.jrxml");
            }
        });
        MenuItem ek4 = new MenuItem("Ispis EK-4");
        ek4.setOnAction(e -> {
            int selectdIndex = this.tablicaPopisStrojeva.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                String sql = "Select  * from ek4 where id='" + ((StrojEvidencija)this.tablicaPopisStrojeva.getSelectionModel().getSelectedItem()).getId() + "' and tvrtka_id='" + GlavniPanelController.getOdabranaTvrtka().getId() + "'";
                IspisReporta.ispisMenuButtonSaSubReportom(sql, this.btnIspis1, "EK-4.jrxml");
            }
        });
        this.btnIspis1.getItems().addAll((Object[])new MenuItem[]{kartonStroja, new SeparatorMenuItem(), ek4});
    }

    private void kreirajToolBarFIlter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Inv. broj", "Tv. broj", "\u0160ifra stroja", "Naziv stroja", "Poslovna jedinica"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Inv. broj");
        this.cbFilter.setPrefWidth(200.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter, this.getMenuButton(), MenuButtonReporti.getMenuButtonIspisStrojeva()});
    }

    private MenuButton getMenuButton() {
        MenuItem m1 = new MenuItem("Prikazi sve strojeve");
        m1.setOnAction(event -> this.popuniTablicuPopisStrojeva(BazaStroj.Opcije.sve_strojeve));
        MenuItem m2 = new MenuItem("Prikazi strojeve u uporabi");
        m2.setOnAction(event -> this.popuniTablicuPopisStrojeva(BazaStroj.Opcije.strojeve_u_uporabi));
        MenuItem m3 = new MenuItem("Prikazi rashodovane strojeve");
        m3.setOnAction(event -> this.popuniTablicuPopisStrojeva(BazaStroj.Opcije.rashodovane_strojeve));
        MenuButton mb = new MenuButton("Pregled strojeva", null, new MenuItem[]{m1, m2, m3});
        return mb;
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaStrojeva, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("\u0160ifra stroja") ? pregled.getSifrastroja() != null && pregled.getSifrastroja().toLowerCase().startsWith(this.tfilter.getText().toLowerCase()) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv stroja") ? pregled.getNazivstroja() != null && pregled.getNazivstroja().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("Poslovna jedinica") ? pregled.getPoslovnajedinica() != null && pregled.getPoslovnajedinica().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("Inv. broj") ? pregled.getInventurnibroj() != null && pregled.getInventurnibroj().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Tv. broj") && pregled.getTvornickibroj() != null && pregled.getTvornickibroj().toLowerCase().startsWith(lowerCaseFilter))));
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediTablicuPopisStrojeva() {
        this.tablicaPopisStrojeva.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tablicaPopisStrojeva.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisEvidencijeStrojaController.this.tablicaPopisStrojeva.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory((Callback)new PropertyValueFactory("redBroj"));
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisStrojeva.widthProperty().divide(20.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolInvBroj.setCellValueFactory(cell -> ((StrojEvidencija)cell.getValue()).inventurnibrojProperty());
        this.kolInvBroj.prefWidthProperty().bind((ObservableValue)this.tablicaPopisStrojeva.widthProperty().divide(10.0));
        this.kolInvBroj.setStyle("-fx-alignment: CENTER;");
        this.kolTvBroj.setCellValueFactory(cell -> ((StrojEvidencija)cell.getValue()).tvornickibrojProperty());
        this.kolTvBroj.prefWidthProperty().bind((ObservableValue)this.tablicaPopisStrojeva.widthProperty().divide(10.0));
        this.kolTvBroj.setStyle("-fx-alignment: CENTER;");
        this.kolSifraStroja.setCellValueFactory((Callback)new PropertyValueFactory("sifrastroja"));
        this.kolSifraStroja.prefWidthProperty().bind((ObservableValue)this.tablicaPopisStrojeva.widthProperty().divide(10.0));
        this.kolSifraStroja.setStyle("-fx-alignment: CENTER;");
        this.kolNazivStroja.setCellValueFactory((Callback)new PropertyValueFactory("nazivstroja"));
        this.kolNazivStroja.prefWidthProperty().bind((ObservableValue)this.tablicaPopisStrojeva.widthProperty().divide(2.857142857142857));
        this.kolNazivStroja.setStyle("-fx-alignment: CENTER;");
        this.kolPoslovnica.setCellValueFactory((Callback)new PropertyValueFactory("poslovnajedinica"));
        this.kolPoslovnica.prefWidthProperty().bind((ObservableValue)this.tablicaPopisStrojeva.widthProperty().divide(5.0));
        this.kolPoslovnica.setStyle("-fx-alignment: CENTER;");
        TableColumn kolPregledDjelatnika = new TableColumn("Pregled");
        kolPregledDjelatnika.setSortable(false);
        kolPregledDjelatnika.prefWidthProperty().bind((ObservableValue)this.tablicaPopisStrojeva.widthProperty().divide(10.0));
        kolPregledDjelatnika.setStyle("-fx-alignment: CENTER;");
        kolPregledDjelatnika.setCellFactory((Callback)new Callback<TableColumn<StrojEvidencija, Boolean>, TableCell<StrojEvidencija, Boolean>>(){

            public TableCell<StrojEvidencija, Boolean> call(TableColumn<StrojEvidencija, Boolean> param) {
                return new ButtonCell();
            }
        });
        this.kolPretraga.setGraphic((Node)this.tbFilter);
        this.kolPretraga.getColumns().add((Object)kolPregledDjelatnika);
        this.tablicaPopisStrojeva.setItems(this.listaStrojeva);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuStrojeva(ResultSet rs) {
        StrojEvidencija se = null;
        int br = 1;
        try {
            while (rs.next()) {
                se = new StrojEvidencija();
                se.setId(rs.getInt("id"));
                se.setRedBroj(String.valueOf(br));
                se.setSifrastroja(rs.getString("oznaka"));
                se.setNazivstroja(rs.getString("naziv"));
                se.setProizvodjac(rs.getString("proizvodjac"));
                se.setModel(rs.getString("model"));
                se.setTvornickibroj(rs.getString("tvornickibroj"));
                se.setInventurnibroj(rs.getString("inventurnibroj"));
                se.setGodinaProizvodnje(rs.getString("godinaproizvodnje"));
                se.setDatumStavljanjauPogon(DateUtil.getLocalDate(rs.getDate("datumstavljanjaupogon")));
                se.setGrupaStroja(rs.getString("grupastrojeva"));
                se.setVrstaStroja(rs.getString("vrstastroja"));
                se.setNapomena(rs.getString("napomena"));
                se.setPoslovnajedinica(rs.getString("poslovnajedinica"));
                se.setOdjel(rs.getString("odjel"));
                se.setRashodovan(rs.getBoolean("rashodovan"));
                this.listaStrojeva.add((Object)se);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisEvidencijeStrojaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisEvidencijeStrojaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void popuniTablicuPopisStrojeva() {
        this.tablicaPopisStrojeva.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task<Void> task = this.createTask(BazaStroj.Opcije.strojeve_u_uporabi);
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaStrojeva.clear();
        this.tablicaPopisStrojeva.getItems().clear();
    }

    public void popuniTablicuPopisStrojeva(BazaStroj.Opcije opcija) {
        this.tablicaPopisStrojeva.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task<Void> task = this.createTask(opcija);
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaStrojeva.clear();
        this.tablicaPopisStrojeva.getItems().clear();
    }

    private Task<Void> createTask(final BazaStroj.Opcije opcija) {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisEvidencijeStrojaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    ResultSet rs = BazaStroj.dajStrojeve(GlavniPanelController.getOdabranaTvrtka(), opcija);
                    Platform.runLater(() -> PopisEvidencijeStrojaController.this.popuniTablicuStrojeva(rs));
                }
                finally {
                    Platform.runLater(() -> PopisEvidencijeStrojaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    private void ispisKartonStroja(ObservableList<StrojEvidencija> listaStrojeva) {
        String idArray = "";
        for (int i = 0; i < listaStrojeva.size(); ++i) {
            idArray = i == 0 ? idArray + String.valueOf(((StrojEvidencija)listaStrojeva.get(i)).getId()) : idArray + "," + String.valueOf(((StrojEvidencija)listaStrojeva.get(i)).getId());
        }
        String sql = "SELECT DISTINCT  strojevi.id, strojevi.idtvrtka,  strojevi.nazivstroja, strojevi.model, strojevi.tvornickibroj, strojevi.inventurnibroj, strojevi.godinaproizvodnje, strojevi.datumstavljanjaupogon,  strojevi.vrstastroja,  strojevi.napomena,  strojevi.proizvodjac,  strojevi.sifrastroja, strojevi.rashodovan,  odjeli.nazivodjela  ,  poslovnejedinice.nazivposlovnice ,   nazivstroja.naziv,   nazivstroja.oznaka FROM \n  public.strojevi,   public.grupastrojeva,   public.poslovnejedinice,   public.odjeli,   public.nazivstroja WHERE   strojevi.grupastrojeva = grupastrojeva.id AND    strojevi.poslovnajedinica = poslovnejedinice.id AND    strojevi.odjel = odjeli.id AND    nazivstroja.id = strojevi.idstroja  and strojevi.id IN (select(unnest(ARRAY [" + idArray + "])))  and idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "' ";
        final IspisJasperButtonSaSubreportom wb = new IspisJasperButtonSaSubreportom(this.btnIspis, sql, "IspisStrojeva.jrxml");
        wb.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                if (wb.getValue() != null) {
                    JasperViewerFX viewer = new JasperViewerFX(new Stage(), ((JasperPrint)wb.getValue()).getName(), (JasperPrint)wb.getValue());
                    viewer.show();
                }
            }
        });
        wb.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                System.out.println("Connection error.");
            }
        });
        new Thread((Runnable)((Object)wb)).start();
    }

    private class ButtonCell
    extends TableCell<StrojEvidencija, Boolean> {
        Button cellButton = new Button("Pregled");

        ButtonCell() {
            this.cellButton.setId("btnPregled");
            this.cellButton.setContentDisplay(ContentDisplay.LEFT);
            this.cellButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    StrojEvidencija se;
                    int selectdIndex = PopisEvidencijeStrojaController.this.tablicaPopisStrojeva.getSelectionModel().getSelectedIndex();
                    if (selectdIndex != -1 && (se = (StrojEvidencija)PopisEvidencijeStrojaController.this.tablicaPopisStrojeva.getSelectionModel().getSelectedItem()) != null) {
                        GlavniPanelController.getInstance().setBlurEfekt(new GaussianBlur(10.0));
                        Template.getTamplate().showTemplate("radnaoprema/UnosStrojeva.fxml", "anchorPanelStroj");
                        UnosStrojevaController.getInstance().izmjenaStroja(se);
                        PopisEvidencijeStrojaController.this.tablicaPopisStrojeva.getSelectionModel().clearSelection();
                    }
                }
            });
        }

        protected void updateItem(Boolean t, boolean empty) {
            super.updateItem((Object)t, empty);
            if (!empty) {
                this.setGraphic((Node)this.cellButton);
                this.cellButton.disableProperty().bind((ObservableValue)PopisEvidencijeStrojaController.this.tablicaPopisStrojeva.getSelectionModel().selectedIndexProperty().isNotEqualTo(this.getTableRow().getIndex()));
            } else {
                this.setGraphic(null);
            }
        }
    }
}

