/*
 * Decompiled with CFR 0.152.
 */
package radpodnadzorom;

import Utill.FxDialogs;
import Utill.FxUtil;
import ispisJasper.JasperViewerFX;
import java.io.IOException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Collection;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.HostServices;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import kadrovska.Djelatnik;
import net.sf.jasperreports.engine.JasperPrint;
import radpodnadzorom.IspisJasperButton;
import zastitanaradu.GlavniPanelController;
import zos.BazaZOS;
import zos.UnosOsposibljavanjaZOSController;

public class RadPodNadzoromController
implements Initializable {
    @FXML
    private TextField txtNazivRadnika;
    @FXML
    private Button btnPretragaDjelatnika;
    @FXML
    private TextField txtRMRadnika;
    @FXML
    private TextField txtNazivMentora;
    @FXML
    private Button btnPretragaMentora;
    @FXML
    private TextField txtTRMMentora;
    @FXML
    private ComboBox<String> cboxMjesto;
    @FXML
    private DatePicker dateDatum;
    @FXML
    private TextField txtTNazivDirektora;
    @FXML
    private Button btnPretragaDirektora;
    @FXML
    private Button btnIspis;

    public void initialize(URL url, ResourceBundle rb) {
        this.popuniCBoxMjesta();
        this.btnPretragaDjelatnika.setOnAction(e -> {
            Djelatnik d = FxDialogs.getDjelatnikDijalog();
            if (d != null) {
                this.txtNazivRadnika.setText(d.getIme() + " " + d.getPrezime());
                this.txtRMRadnika.setText(d.getRadnoMjesto());
            }
        });
        this.btnPretragaMentora.setOnAction(e -> {
            Djelatnik d = FxDialogs.getDjelatnikDijalog();
            if (d != null) {
                this.txtNazivMentora.setText(d.getIme() + " " + d.getPrezime());
                this.txtTRMMentora.setText(d.getRadnoMjesto());
            }
        });
        this.btnPretragaDirektora.setOnAction(e -> {
            Djelatnik d = FxDialogs.getDjelatnikDijalog();
            if (d != null) {
                this.txtTNazivDirektora.setText(d.getIme() + " " + d.getPrezime());
            }
        });
        this.btnIspis.setOnAction(e -> this.ispisOdluku());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniCBoxMjesta() {
        ObservableList listaMjesta = FXCollections.observableArrayList();
        ResultSet rs = BazaZOS.dajMjesta();
        try {
            while (rs.next()) {
                listaMjesta.add((Object)rs.getString("nazivgrada"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosOsposibljavanjaZOSController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosOsposibljavanjaZOSController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.cboxMjesto.getItems().addAll((Collection)listaMjesta);
        FxUtil.autoCompleteComboBox(this.cboxMjesto, FxUtil.AutoCompleteMode.STARTS_WITH);
    }

    private void ispisOdluku() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String tvrtka = GlavniPanelController.getOdabranaTvrtka().getNazivTvrtka() + "\n" + GlavniPanelController.getOdabranaTvrtka().getSjediste();
        System.out.println("tv " + tvrtka);
        parameters.put("tvrtka", tvrtka);
        parameters.put("radnik", this.txtNazivRadnika.getText());
        parameters.put("radnikradnomjesto", this.txtRMRadnika.getText());
        parameters.put("mentor", this.txtNazivMentora.getText());
        parameters.put("mentorradnomjesto", this.txtTRMMentora.getText());
        String mjesto = "";
        if (this.cboxMjesto.getValue() != null) {
            mjesto = (String)this.cboxMjesto.getValue();
        }
        String datum = "";
        if (this.dateDatum.getValue() != null) {
            datum = ", " + ((LocalDate)this.dateDatum.getValue()).format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM));
        }
        parameters.put("u", mjesto + " " + datum);
        parameters.put("direktor", this.txtTNazivDirektora.getText());
        final IspisJasperButton wb = new IspisJasperButton(this.btnIspis, "RadPodNadzorom.jrxml", parameters);
        wb.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                if (wb.getValue() != null) {
                    JasperViewerFX viewer = new JasperViewerFX(new Stage(), ((JasperPrint)wb.getValue()).getName(), (JasperPrint)wb.getValue());
                    viewer.show();
                }
            }
        });
        wb.setOnFailed((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                System.out.println("Connection error.");
            }
        });
        new Thread((Runnable)((Object)wb)).start();
        System.out.print("Done!");
    }

    static URL ucitajPostavke(String putanjaFile) {
        HostServices hosting = GlavniPanelController.getHosting();
        URL configUrl = null;
        try {
            configUrl = new URL(hosting.resolveURI(hosting.getDocumentBase(), putanjaFile));
        }
        catch (IOException e) {
            System.out.println("Unable to load config properties from: " + configUrl);
        }
        return configUrl;
    }
}

