/*
 * Decompiled with CFR 0.152.
 */
package ro2;

import TamplatePaneli.Template;
import Utill.CheckboxCell;
import Utill.DateCell;
import Utill.DateUtil;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import ispisJasper.IspisReporta;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import monitoringnovi.ServiceRestart;
import ro2.BazaRO2;
import ro2.RO2;
import ro2.RO2ObrazacController;
import zastitanaradu.GlavniPanelController;

public class PregledRO2Controller
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private Button btnIspis;
    @FXML
    private TableView<RO2> tablicaPopisRO2Uputnica;
    @FXML
    private TableColumn<RO2, Boolean> kolPregledObavljen;
    @FXML
    private TableColumn<RO2, String> kolPretraga;
    @FXML
    private TableColumn<RO2, String> kolRedBr;
    @FXML
    private TableColumn<RO2, LocalDate> kolDatumIzdavanja;
    @FXML
    private TableColumn<RO2, String> kolBrojUputnice;
    @FXML
    private TableColumn<RO2, String> kolOib;
    @FXML
    private TableColumn<RO2, String> kolPrezime;
    @FXML
    private TableColumn<RO2, String> kolIme;
    private static PregledRO2Controller instance;
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;
    private final ObservableList<RO2> listaRO2uputnica = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    BooleanProperty bp = new SimpleBooleanProperty(true);

    public static PregledRO2Controller getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediTablicuPopisRO2Uputnica();
        this.popuniTablicuPopisRO2Uputnica(1);
        this.urediFilter(this.tablicaPopisRO2Uputnica);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos RO uputnice")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos RO uputnice");
                GlavniPanelController.getInstance().nadodajPanel("Unos RO uputnice", "/ro2/RO2Obrazac.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos RO uputnice", "/ro2/RO2Obrazac.fxml");
            }
        });
        this.btnPromjena.setOnAction(event -> {
            RO2 ra;
            int selectdIndex = this.tablicaPopisRO2Uputnica.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (ra = (RO2)this.tablicaPopisRO2Uputnica.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos RO uputnice")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos RO uputnice");
                    GlavniPanelController.getInstance().nadodajPanel("Unos RO uputnice", "/ro2/RO2Obrazac.fxml");
                    RO2ObrazacController.getInstance().izmjenaUputnice(ra);
                    this.tablicaPopisRO2Uputnica.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos RO uputnice", "/ro2/RO2Obrazac.fxml");
                    RO2ObrazacController.getInstance().izmjenaUputnice(ra);
                    this.tablicaPopisRO2Uputnica.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisRO2Uputnica.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && this.tablicaPopisRO2Uputnica.getSelectionModel().getSelectedItems().size() < 2 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati uputnicu")).showAndWait()).get() == ButtonType.OK) {
                if (BazaRO2.obrisiUputnicu((RO2)this.tablicaPopisRO2Uputnica.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuPopisRO2Uputnica(1);
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisana uputnica", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisana uputnica", 2, "Error graphic");
                }
            }
        });
        this.btnIspis.setOnAction(e -> {
            int selectdIndex = this.tablicaPopisRO2Uputnica.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                this.ispis((ObservableList<RO2>)this.tablicaPopisRO2Uputnica.getSelectionModel().getSelectedItems());
            }
        });
        this.btnPromjena.disableProperty().bind((ObservableValue)this.bp.not());
        this.tablicaPopisRO2Uputnica.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            if (newSelection != null) {
                this.bp.set(!newSelection.isPregledObavljen());
            }
        });
    }

    private void ispis(ObservableList<RO2> listaRO2uputnica) {
        String idArray = "";
        for (int i = 0; i < listaRO2uputnica.size(); ++i) {
            if (i == 0) {
                idArray = idArray + String.valueOf(((RO2)listaRO2uputnica.get(i)).getId());
                System.out.println(((RO2)listaRO2uputnica.get(i)).getId() + " ime " + ((RO2)listaRO2uputnica.get(i)).imeProperty());
                continue;
            }
            idArray = idArray + "," + String.valueOf(((RO2)listaRO2uputnica.get(i)).getId());
            System.out.println(((RO2)listaRO2uputnica.get(i)).getId() + " ime " + ((RO2)listaRO2uputnica.get(i)).imeProperty());
        }
        String sql = "SELECT \n  tvrtka.naziv_tvrtke, \n  tvrtka.adresa, \n  tvrtka.mjesto, \n  tvrtka.pbr, \n  ro2obrazac.brojoi, \n  ro2obrazac.brojobrasca, \n  ro2obrazac.mjenjanoradnomjesto, \n  ro2obrazac.datumposljednjegpregleda, \n  ro2obrazac.radnistazutvrci, \n  ro2obrazac.ukupanstaz, \n  ro2obrazac.tocka, \n  ro2obrazac.radnomjesto, \n  ro2obrazac.strucnasprema, \n  ro2obrazac.zanimanje, \n  ro2obrazac.datumrodjenja, \n  ro2obrazac.imeocamajke, \n  ro2obrazac.prezime, \n  ro2obrazac.ime, \n  ro2obrazac.oib, \n  ro2obrazac.datumizdavanja\nFROM \n  public.ro2obrazac, \n  public.tvrtka\nWHERE \n  ro2obrazac.idtvrtka = tvrtka.id\n\nand ro2obrazac.id  IN (select(unnest(ARRAY [" + idArray + "])))and idtvrtka='" + GlavniPanelController.getOdabranaTvrtka().getId() + "'";
        IspisReporta.ispisButtonSaSubreportom(sql, this.btnIspis, "RO2.jrxml");
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Prezime", "Oib"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Prezime");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter, this.getMenuButton()});
    }

    private MenuButton getMenuButton() {
        MenuItem m1 = new MenuItem("Prikazi sve uputnice");
        m1.setOnAction(event -> this.popuniTablicuPopisRO2Uputnica(1));
        MenuItem m2 = new MenuItem("Prikazi samo obavljene preglede");
        m2.setOnAction(event -> this.popuniTablicuPopisRO2Uputnica(2));
        MenuItem m3 = new MenuItem("Prikazi samo neobavljene preglede");
        m3.setOnAction(event -> this.popuniTablicuPopisRO2Uputnica(3));
        MenuButton mb = new MenuButton("Pregled uputnica", null, new MenuItem[]{m1, m2, m3});
        return mb;
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaRO2uputnica, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Prezime") ? pregled.getPrezime() != null && pregled.getPrezime().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Oib") && pregled.getOib() != null && pregled.getOib().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediTablicuPopisRO2Uputnica() {
        this.tablicaPopisRO2Uputnica.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tablicaPopisRO2Uputnica.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PregledRO2Controller.this.tablicaPopisRO2Uputnica.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cellData -> ((RO2)cellData.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisRO2Uputnica.widthProperty().divide(12.5));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolPregledObavljen.setCellValueFactory(cellData -> ((RO2)cellData.getValue()).pregledObavljenProperty());
        this.kolPregledObavljen.prefWidthProperty().bind((ObservableValue)this.tablicaPopisRO2Uputnica.widthProperty().divide(10.0));
        this.kolPregledObavljen.setStyle("-fx-alignment: CENTER;");
        Callback<TableColumn<RO2, Boolean>, TableCell<RO2, Boolean>> booleanCellFactory = new Callback<TableColumn<RO2, Boolean>, TableCell<RO2, Boolean>>(){

            public TableCell<RO2, Boolean> call(TableColumn<RO2, Boolean> p) {
                return new CheckboxCell<RO2>();
            }
        };
        this.kolPregledObavljen.setCellFactory((Callback)booleanCellFactory);
        this.kolPregledObavljen.setOnEditCommit(t -> {
            ((RO2)t.getTableView().getItems().get(t.getTablePosition().getRow())).setPregledObavljen((Boolean)t.getNewValue());
            this.bp.set((Boolean)t.getNewValue() == false);
            BazaRO2.pregledObavljen((RO2)t.getTableView().getItems().get(t.getTablePosition().getRow()));
            ServiceRestart.restartService(ServiceRestart.RService.djelatnik);
        });
        Callback dateCellFactory = param -> new DateCell();
        this.kolDatumIzdavanja.setCellValueFactory(cellData -> ((RO2)cellData.getValue()).datumKreiranjaProperty());
        this.kolDatumIzdavanja.setCellFactory(dateCellFactory);
        this.kolDatumIzdavanja.prefWidthProperty().bind((ObservableValue)this.tablicaPopisRO2Uputnica.widthProperty().divide(10.0));
        this.kolDatumIzdavanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumIzdavanja.setEditable(false);
        this.kolBrojUputnice.setCellValueFactory(cellData -> ((RO2)cellData.getValue()).brojUputniceProperty());
        this.kolBrojUputnice.prefWidthProperty().bind((ObservableValue)this.tablicaPopisRO2Uputnica.widthProperty().divide(10.0));
        this.kolBrojUputnice.setStyle("-fx-alignment: CENTER;");
        this.kolOib.setCellValueFactory(cellData -> ((RO2)cellData.getValue()).oibProperty());
        this.kolOib.prefWidthProperty().bind((ObservableValue)this.tablicaPopisRO2Uputnica.widthProperty().divide(10.0));
        this.kolOib.setStyle("-fx-alignment: CENTER;");
        this.kolPrezime.setCellValueFactory(cellData -> ((RO2)cellData.getValue()).prezimeProperty());
        this.kolPrezime.prefWidthProperty().bind((ObservableValue)this.tablicaPopisRO2Uputnica.widthProperty().divide(4.0));
        this.kolPrezime.setStyle("-fx-alignment: CENTER;");
        this.kolIme.setCellValueFactory(cellData -> ((RO2)cellData.getValue()).imeProperty());
        this.kolIme.prefWidthProperty().bind((ObservableValue)this.tablicaPopisRO2Uputnica.widthProperty().divide(4.0));
        this.kolIme.setStyle("-fx-alignment: CENTER;");
        TableColumn kolPregledDjelatnika = new TableColumn("Pregled");
        kolPregledDjelatnika.setSortable(false);
        kolPregledDjelatnika.prefWidthProperty().bind((ObservableValue)this.tablicaPopisRO2Uputnica.widthProperty().divide(10.0));
        kolPregledDjelatnika.setStyle("-fx-alignment: CENTER;");
        kolPregledDjelatnika.setCellFactory((Callback)new Callback<TableColumn<RO2, Boolean>, TableCell<RO2, Boolean>>(){

            public TableCell<RO2, Boolean> call(TableColumn<RO2, Boolean> param) {
                return new ButtonCell();
            }
        });
        this.kolPretraga.setGraphic((Node)this.tbFilter);
        this.kolPretraga.getColumns().add((Object)kolPregledDjelatnika);
    }

    public void popuniTablicuPopisRO2Uputnica(int opcija) {
        this.tablicaPopisRO2Uputnica.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTask(opcija);
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaRO2uputnica.clear();
        this.tablicaPopisRO2Uputnica.getItems().clear();
    }

    private Task createTask(final int opcija) {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PregledRO2Controller.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    ResultSet rs = BazaRO2.dajRO2Uputnice(GlavniPanelController.getOdabranaTvrtka(), opcija);
                    PregledRO2Controller.this.popuniTablicuPopisRO2(rs);
                }
                finally {
                    Platform.runLater(() -> PregledRO2Controller.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuPopisRO2(ResultSet rs) {
        RO2 ra = null;
        int br = 1;
        try {
            while (rs.next()) {
                ra = new RO2();
                ra.setId(rs.getInt("id"));
                ra.setRedBroj(String.valueOf(br));
                ra.setPregledObavljen(rs.getBoolean("pregledobavljen"));
                ra.setBrojUputnice(rs.getString("brojobrasca"));
                ra.setOib(rs.getString("oib"));
                ra.setIme(rs.getString("ime"));
                ra.setPrezime(rs.getString("prezime"));
                ra.setDatumKreiranja(DateUtil.getLocalDate(rs.getDate("datumizdavanja")));
                ra.setImeOca_Majke(rs.getString("imeocamajke"));
                ra.setDatumRodjenja(DateUtil.getLocalDate(rs.getDate("datumrodjenja")));
                ra.setZanimianje(rs.getString("zanimanje"));
                ra.setStrucnaSprema(rs.getString("strucnasprema"));
                ra.setRadnoMjesto(rs.getString("radnomjesto"));
                ra.setTocka(rs.getString("tocka"));
                ra.setUkupanStaz(rs.getString("ukupanstaz"));
                ra.setRadniStazUtvrtci(rs.getString("radnistazutvrci"));
                ra.setDatumPosljednjegPregleda(DateUtil.getLocalDate(rs.getDate("datumposljednjegpregleda")));
                ra.setMjenjanoMjesto(rs.getBoolean("mjenjanoradnomjesto"));
                ra.setBrojOsobne(rs.getString("brojoi"));
                this.listaRO2uputnica.add((Object)ra);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PregledRO2Controller.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PregledRO2Controller.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisRO2Uputnica.getItems().addAll(this.listaRO2uputnica);
    }

    private class ButtonCell
    extends TableCell<RO2, Boolean> {
        Button cellButton = new Button("Pregled");

        ButtonCell() {
            this.cellButton.setId("btnPregled");
            this.cellButton.setContentDisplay(ContentDisplay.LEFT);
            this.cellButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    RO2 ra;
                    int selectdIndex = PregledRO2Controller.this.tablicaPopisRO2Uputnica.getSelectionModel().getSelectedIndex();
                    if (selectdIndex != -1 && (ra = (RO2)PregledRO2Controller.this.tablicaPopisRO2Uputnica.getSelectionModel().getSelectedItem()) != null) {
                        Template.getTamplate().showTemplate("ro2/RO2Obrazac.fxml", "anchorPanel");
                        RO2ObrazacController.getInstance().izmjenaUputnice(ra);
                        PregledRO2Controller.this.tablicaPopisRO2Uputnica.getSelectionModel().clearSelection();
                    }
                }
            });
        }

        protected void updateItem(Boolean t, boolean empty) {
            super.updateItem((Object)t, empty);
            if (!empty) {
                this.setGraphic((Node)this.cellButton);
                this.cellButton.disableProperty().bind((ObservableValue)PregledRO2Controller.this.tablicaPopisRO2Uputnica.getSelectionModel().selectedIndexProperty().isNotEqualTo(this.getTableRow().getIndex()));
            } else {
                this.setGraphic(null);
            }
        }
    }
}

