/*
 * Decompiled with CFR 0.152.
 */
package strojevi;

import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import strojevi.BazaProizvodjac;
import strojevi.Strojevi;
import strojevi.UnosStrojaController;
import zastitanaradu.GlavniPanelController;

public class PopisStrojevaController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<Strojevi> tablicaPopisStrojeva;
    @FXML
    private TableColumn<Strojevi, String> kolPretraga;
    @FXML
    private TableColumn<Strojevi, String> kolRedBr;
    @FXML
    private TableColumn<Strojevi, String> kolOznaka;
    @FXML
    private TableColumn<Strojevi, String> kolNaziv;
    private static PopisStrojevaController instance;
    private final ObservableList<Strojevi> listaStrojeva = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static PopisStrojevaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediKoloneUTabliciStrojevi();
        this.popuniTablicuStrojevi();
        this.urediFilter(this.tablicaPopisStrojeva);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos naziva stroja")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos naziva stroja");
                GlavniPanelController.getInstance().nadodajPanel("Unos naziva stroja", "/strojevi/UnosStroja.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos naziva stroja", "/strojevi/UnosStroja.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            Strojevi s;
            int selectdIndex = this.tablicaPopisStrojeva.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (s = (Strojevi)this.tablicaPopisStrojeva.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos naziva stroja")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos naziva stroja");
                    GlavniPanelController.getInstance().nadodajPanel("Unos naziva stroja", "/strojevi/UnosStroja.fxml");
                    UnosStrojaController.getInstance().izmjenaStroja(s);
                    this.tablicaPopisStrojeva.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos naziva stroja", "/strojevi/UnosStroja.fxml");
                    UnosStrojaController.getInstance().izmjenaStroja(s);
                    this.tablicaPopisStrojeva.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisStrojeva.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati Stroj")).showAndWait()).get() == ButtonType.OK) {
                if (BazaProizvodjac.obrisiStroj((Strojevi)this.tablicaPopisStrojeva.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuStrojevi();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisan Stroj", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan Stroj", 2, "Error graphic");
                }
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Oznaka", "Naziv"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaStrojeva, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Oznaka") ? pregled.getOznaka() != null && pregled.getOznaka().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv") && pregled.getNaziv() != null && pregled.getNaziv().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediKoloneUTabliciStrojevi() {
        this.tablicaPopisStrojeva.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisStrojevaController.this.tablicaPopisStrojeva.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cellData -> ((Strojevi)cellData.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisStrojeva.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolOznaka.setCellValueFactory((Callback)new PropertyValueFactory("oznaka"));
        this.kolOznaka.prefWidthProperty().bind((ObservableValue)this.tablicaPopisStrojeva.widthProperty().divide(5.0));
        this.kolOznaka.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellValueFactory((Callback)new PropertyValueFactory("naziv"));
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaPopisStrojeva.widthProperty().divide(1.4492753623188406));
        this.kolNaziv.setStyle("-fx-alignment: CENTER;");
        this.kolPretraga.setGraphic((Node)this.tbFilter);
    }

    public void popuniTablicuStrojevi() {
        this.tablicaPopisStrojeva.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Random rng = new Random();
        Task<Void> task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaStrojeva.clear();
        this.tablicaPopisStrojeva.getItems().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicu() {
        ResultSet rs = BazaProizvodjac.dajStrojeve(GlavniPanelController.getOdabranaTvrtka());
        int br = 1;
        try {
            while (rs.next()) {
                Strojevi s = new Strojevi();
                s.setId(rs.getInt("id"));
                s.setRedBroj(String.valueOf(br));
                s.setOznaka(rs.getString("oznaka"));
                s.setNaziv(rs.getString("naziv"));
                this.listaStrojeva.add((Object)s);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisStrojevaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisStrojevaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisStrojeva.getItems().addAll(this.listaStrojeva);
    }

    private Task<Void> createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisStrojevaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PopisStrojevaController.this.popuniTablicu();
                }
                finally {
                    Platform.runLater(() -> PopisStrojevaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }
}

