/*
 * Decompiled with CFR 0.152.
 */
package strojevi;

import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.ResizeComponent;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import strojevi.BazaProizvodjac;
import strojevi.PopisStrojevaController;
import strojevi.Strojevi;
import zastitanaradu.GlavniPanelController;

public class UnosStrojaController
implements Initializable {
    @FXML
    private Button btnSpremi;
    @FXML
    private TextField txtOznaka;
    @FXML
    private TextField txtNaziv;
    private static UnosStrojaController instance;
    private boolean izmjenaStroja = false;
    private Strojevi s;

    public static UnosStrojaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        ResizeComponent.makeTextFieldResize(this.txtNaziv, this.txtOznaka);
        this.btnSpremi.setOnAction(e -> this.unosStroja());
    }

    private Strojevi dajStroj() {
        Strojevi st = new Strojevi();
        st.setOznaka(this.txtOznaka.getText());
        st.setNaziv(this.txtNaziv.getText());
        return st;
    }

    public void izmjenaStroja(Strojevi s) {
        this.izmjenaStroja = true;
        this.s = s;
        this.txtNaziv.setText(s.getNaziv());
        this.txtOznaka.setText(s.getOznaka());
    }

    private void unosStroja() {
        boolean bNazivStroja = FormValidation.textFieldValidationonlyText(this.txtNaziv);
        if (bNazivStroja) {
            if (this.izmjenaStroja) {
                if (BazaProizvodjac.izmjenaStroja(GlavniPanelController.getOdabranaTvrtka(), this.dajStroj(), this.s.getId())) {
                    PopisStrojevaController.getInstance().popuniTablicuStrojevi();
                    GlavniPanelController.getInstance().zatvoriTab("Unos naziva stroja");
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena Stroja", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena  Stroja", 2, "Error graphic");
                }
            } else if (BazaProizvodjac.unesiNoviStroj(GlavniPanelController.getOdabranaTvrtka(), this.dajStroj())) {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen Stroj", 1, "Information graphic");
                PopisStrojevaController.getInstance().popuniTablicuStrojevi();
                GlavniPanelController.getInstance().zatvoriTab("Unos naziva stroja");
                this.izmjenaStroja = false;
            } else {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesen Stroj", 2, "Error graphic");
            }
        } else {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate unjeti naziv Stroja");
            alert.showAndWait();
        }
    }
}

