/*
 * Decompiled with CFR 0.152.
 */
package testovi;

import Utill.KlasaKorisneMetode;
import java.awt.Desktop;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import testovi.BazaTestovi;

public class HiperLinkCellDokument<S>
extends TableCell<S, String> {
    ProgressIndicator progressPane = new ProgressIndicator();
    Hyperlink h;
    File temp = null;

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.setText(null);
            this.setGraphic((Node)this.getHiperLink(this.getString()));
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(null);
        this.setGraphic((Node)this.getHiperLink(this.getString()));
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            this.setText(null);
            this.setGraphic((Node)this.getHiperLink(this.getString()));
        } else {
            this.setText(null);
            if (this.getHiperLink(this.getString()) != null && !this.getString().equals("")) {
                this.setGraphic((Node)this.getHiperLink(this.getString()));
            } else {
                this.setGraphic(null);
            }
        }
    }

    private String getString() {
        return this.getItem() == null ? "" : (String)this.getItem();
    }

    private Hyperlink getHiperLink(String item) {
        this.h = new Hyperlink(item);
        this.h.getStyleClass().add((Object)"myLink");
        this.h.disableProperty().bind((ObservableValue)this.getTableView().getSelectionModel().selectedIndexProperty().isNotEqualTo(this.getTableRow().getIndex()));
        this.h.setOnAction(event -> {
            int selectdIndex = this.getTableView().getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                this.setGraphic((Node)this.progressPane);
                Task<Void> task = this.createTask();
                new Thread((Runnable)task).start();
                this.progressPane.progressProperty().bind((ObservableValue)task.progressProperty());
            }
        });
        return this.h;
    }

    private Task<Void> createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(HiperLinkCellDokument.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.prikaziDokument();
                    this.updateMessage("Running...");
                }
                finally {
                    Platform.runLater(() -> HiperLinkCellDokument.this.setGraphic((Node)HiperLinkCellDokument.this.h));
                }
                return null;
            }

            private void prikaziDokument() {
                try {
                    HiperLinkCellDokument.this.writeToFileSystem(new ByteArrayInputStream(BazaTestovi.getDokument(HiperLinkCellDokument.this.h.getText())), HiperLinkCellDokument.this.h.getText());
                }
                catch (Exception ex) {
                    Logger.getLogger(HiperLinkCellDokument.class.getName()).log(Level.SEVERE, null, ex);
                }
                System.out.println("otvaram report na lokaciji " + HiperLinkCellDokument.this.temp.getAbsolutePath());
                if (HiperLinkCellDokument.this.temp.exists()) {
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().open(new File(HiperLinkCellDokument.this.temp.getAbsolutePath()));
                            HiperLinkCellDokument.this.getTableView().getSelectionModel().clearSelection();
                        }
                        catch (IOException eo) {
                            eo.printStackTrace();
                        }
                    } else {
                        System.out.println("Awt Desktop is not supported!");
                    }
                } else {
                    System.out.println("File is not exists!");
                }
            }
        };
    }

    private void writeToFileSystem(ByteArrayInputStream byteArrayInputStream, String nazivDokumenta) throws Exception {
        System.out.println("usao u export");
        try {
            this.temp = File.createTempFile(nazivDokumenta, "." + KlasaKorisneMetode.getExtension(new File(nazivDokumenta)));
            this.temp.deleteOnExit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileOutputStream fileOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        byte[] byteArray = new byte[byteArrayInputStream.available()];
        System.out.println("report name na putanji   " + this.temp.getAbsolutePath());
        fileOutputStream = new FileOutputStream(this.temp);
        byteArrayOutputStream = new ByteArrayOutputStream(byteArrayInputStream.available());
        int x = byteArrayInputStream.read(byteArray, 0, byteArrayInputStream.available());
        byteArrayOutputStream.write(byteArray, 0, x);
        byteArrayOutputStream.writeTo(fileOutputStream);
        byteArrayInputStream.close();
        byteArrayOutputStream.close();
        fileOutputStream.close();
        System.out.println("zavrsio export");
    }
}

