/*
 * Decompiled with CFR 0.152.
 */
package testovi;

import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import java.io.IOException;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import testovi.BazaTestovi;
import testovi.HiperLinkCellDokument;
import testovi.Test;
import zastitanaradu.GlavniPanelController;

public class PopisTestovaController
implements Initializable {
    @FXML
    private TableView<Test> tablicaTestovi;
    @FXML
    private TableColumn<Test, String> kolPretraga;
    @FXML
    private TableColumn<Test, String> kolRedBr;
    @FXML
    private TableColumn<Test, String> kolOznaka;
    @FXML
    private TableColumn<Test, String> kolNazivTesta;
    @FXML
    private TableColumn<Test, String> kolNazivDokumenta;
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnIspis;
    @FXML
    private Button btnBrisanje;
    private static PopisTestovaController instance;
    private final ObservableList<Test> listaTestova = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static PopisTestovaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediKoloneUTabliciTestovi();
        this.popuniTablicuTestovi();
        this.urediFilter(this.tablicaTestovi);
        this.btnIspis.setOnAction(e -> {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/testovi/IspisTestova.fxml"));
            Parent root = null;
            try {
                root = (Parent)loader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(PopisTestovaController.class.getName()).log(Level.SEVERE, null, ex);
            }
            Scene scene = new Scene(root);
            Stage stage = new Stage();
            stage.setTitle("Ispis testova");
            stage.getIcons().add((Object)new Image("/resorces/icon/printer.png"));
            stage.initModality(Modality.APPLICATION_MODAL);
            scene.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
            stage.setScene(scene);
            stage.showAndWait();
        });
        this.btnUnos.setOnAction(e -> {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/testovi/UnosTestova.fxml"));
            Parent root = null;
            try {
                root = (Parent)loader.load();
            }
            catch (IOException ex) {
                Logger.getLogger(PopisTestovaController.class.getName()).log(Level.SEVERE, null, ex);
            }
            Scene scene = new Scene(root);
            Stage stage = new Stage(StageStyle.UNDECORATED);
            stage.initModality(Modality.APPLICATION_MODAL);
            scene.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
            stage.setScene(scene);
            stage.showAndWait();
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaTestovi.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati test")).showAndWait()).get() == ButtonType.OK) {
                if (BazaTestovi.obrisiTest((Test)this.tablicaTestovi.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuTestovi();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisan test", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan test", 2, "Error graphic");
                }
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Oznaka testa", "Naziv testa"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Oznaka testa");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaTestova, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Oznaka testa") ? pregled.getOznaka() != null && pregled.getOznaka().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv testa") && pregled.getNazivTesta() != null && pregled.getNazivTesta().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediKoloneUTabliciTestovi() {
        this.tablicaTestovi.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisTestovaController.this.tablicaTestovi.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cellData -> ((Test)cellData.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaTestovi.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolOznaka.setCellValueFactory(cellData -> ((Test)cellData.getValue()).oznakaProperty());
        this.kolOznaka.prefWidthProperty().bind((ObservableValue)this.tablicaTestovi.widthProperty().divide(10.0));
        this.kolOznaka.setStyle("-fx-alignment: CENTER;");
        this.kolNazivTesta.setCellValueFactory(cellData -> ((Test)cellData.getValue()).nazivTestaProperty());
        this.kolNazivTesta.prefWidthProperty().bind((ObservableValue)this.tablicaTestovi.widthProperty().divide(2.5));
        this.kolNazivTesta.setStyle("-fx-alignment: CENTER;");
        Callback cellDokument = param -> new HiperLinkCellDokument();
        this.kolNazivDokumenta.setCellValueFactory(cellData -> ((Test)cellData.getValue()).nazivDokumentaProperty());
        this.kolNazivDokumenta.setCellFactory(cellDokument);
        this.kolNazivDokumenta.prefWidthProperty().bind((ObservableValue)this.tablicaTestovi.widthProperty().divide(2.5641025641025643));
        this.kolNazivDokumenta.setStyle("-fx-alignment: CENTER;");
        this.kolPretraga.setGraphic((Node)this.tbFilter);
    }

    public void popuniTablicuTestovi() {
        this.tablicaTestovi.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task<Void> task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaTestova.clear();
        this.tablicaTestovi.getItems().clear();
    }

    private Task<Void> createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisTestovaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PopisTestovaController.this.popuniTablicu();
                }
                finally {
                    Platform.runLater(() -> PopisTestovaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicu() {
        ResultSet rs = BazaTestovi.dajTestove();
        int br = 1;
        try {
            while (rs.next()) {
                Test t = new Test();
                t.setId(rs.getInt("id"));
                t.setRedBroj(String.valueOf(br));
                t.setOznaka(rs.getString("oznaka"));
                t.setNazivTesta(rs.getString("nazivtesta"));
                t.setNazivDokumenta(rs.getString("nazivdokumenta"));
                this.listaTestova.add((Object)t);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisTestovaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisTestovaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaTestovi.getItems().addAll(this.listaTestova);
    }
}

