/*
 * Decompiled with CFR 0.152.
 */
package uputnice;

import Utill.DateUtil;
import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.FxUtil;
import Utill.KlasaKorisneMetode;
import Utill.ResizeComponent;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import kadrovska.Djelatnik;
import kadrovska.DjelatnikLjijecnickiPregled;
import radnamjesta.RadnoMjesto;
import uputnice.BazaRA1;
import uputnice.PregledRA1Controller;
import uputnice.RAUputnica;
import zastitanaradu.GlavniPanelController;

public class RA1Controller
implements Initializable {
    @FXML
    private DatePicker dateDatumKreiranja;
    @FXML
    private AnchorPane anchorPanel;
    @FXML
    private Button btnSpremi;
    @FXML
    private TextField txtOIB;
    @FXML
    private TextField txtImeOca;
    @FXML
    private TextField txtIme;
    @FXML
    private Button btnPretragaDjelatnika;
    @FXML
    private DatePicker dateDatumRodjenja;
    @FXML
    private TextField txtZanimanje;
    @FXML
    private ComboBox<String> cboxMjesto;
    @FXML
    private ComboBox<String> cboxSkolskaSprema;
    @FXML
    private TextField txtTPPOsljednjiClanak;
    @FXML
    private TextField txtTPPosljednjiTocka;
    @FXML
    private TextField txtTPOcijena;
    @FXML
    private DatePicker datumTPPosljednjPregled;
    @FXML
    private ComboBox<String> cboxTPDrugiPropisi2;
    @FXML
    private TextField txtTPPoslovi;
    @FXML
    private TextField txtTPClanak;
    @FXML
    private TextField txtTPTocka;
    @FXML
    private TextField txtTPUkupniStaz;
    @FXML
    private TextField txtTPRadniStazNaOvimPoslovima;
    @FXML
    private Button btnTPPregledRadnihMjesta;
    @FXML
    private ComboBox<String> cboxTPDrugiPropisi1;
    @FXML
    private ComboBox<String> cboxTPZdrastveniPregled;
    @FXML
    private TextArea txtAreaOpisPosla;
    @FXML
    private CheckBox chBoxMRuZatvorenom;
    @FXML
    private CheckBox chBoxMRnaotvorenom;
    @FXML
    private CheckBox chBoxMRnaVisini;
    @FXML
    private CheckBox chBoxMRuJami;
    @FXML
    private CheckBox chBoxMRuVodi;
    @FXML
    private CheckBox chBoxMRpodVodom;
    @FXML
    private CheckBox chBoxMRuMokrom;
    @FXML
    private TextField txtStrojevi;
    @FXML
    private TextField txtPredmeti;
    @FXML
    private CheckBox chBoxORuSmjenama;
    @FXML
    private CheckBox chBoxORNocniRad;
    @FXML
    private CheckBox chBoxORTerenskiRad;
    @FXML
    private CheckBox chBoxORuGrupi;
    @FXML
    private CheckBox chBoxORsStrankama;
    @FXML
    private CheckBox chBoxORRadiSam;
    @FXML
    private CheckBox chBoxORnaTraci;
    @FXML
    private CheckBox chBoxORBrziTempo;
    @FXML
    private CheckBox chBoxORRitamOdredjen;
    @FXML
    private CheckBox chBoxORMonotonija;
    @FXML
    private CheckBox chBoxPTradStojeci;
    @FXML
    private CheckBox chBoxPTradSjedeci;
    @FXML
    private CheckBox chBoxPTraduPokretu;
    @FXML
    private CheckBox chBoxPTKombinirano;
    @FXML
    private CheckBox chBoxPTDizanjeTereta;
    @FXML
    private CheckBox chBoxPTucestaloSagibanje;
    @FXML
    private CheckBox chBoxPTZakretanjeTrupa;
    @FXML
    private CheckBox chBoxPTKlecanje;
    @FXML
    private CheckBox chBoxPTCuceci;
    @FXML
    private CheckBox chBoxPTPrenosenjeTereta;
    @FXML
    private CheckBox chBoxPTpodvlacenje;
    @FXML
    private CheckBox chBoxPTbalansiranje;
    @FXML
    private CheckBox chBoxPTuspinjanjeLjestvama;
    @FXML
    private CheckBox chBoxPTuspinjanjeStepenicama;
    @FXML
    private CheckBox chBoxPTguranjeTereta;
    @FXML
    private TextField txtPTdizanjeTereta;
    @FXML
    private TextField txtPTPrenosenjeTereta;
    @FXML
    private TextField txtPTguranjeTereta;
    @FXML
    private CheckBox chBoxPVvidNaDaljinu;
    @FXML
    private CheckBox chBoxPVvidNaBlizinu;
    @FXML
    private CheckBox chBoxPVraspoznavanjeBoja;
    @FXML
    private CheckBox chBoxPVsluh;
    @FXML
    private CheckBox chBoxPVgovor;
    @FXML
    private CheckBox chBoxURVisokaTemperatura;
    @FXML
    private CheckBox chBoxURVisokaVlaznost;
    @FXML
    private CheckBox chBoxURNiskaTemperatura;
    @FXML
    private CheckBox chBoxURBuka;
    @FXML
    private CheckBox chBoxURVibracijaStroja;
    @FXML
    private CheckBox chBoxURVibracijaPoda;
    @FXML
    private CheckBox chBoxURatmosferskiTlak;
    @FXML
    private CheckBox chBoxURPovecanaIzlozenostOzljedama;
    @FXML
    private CheckBox chBoxURIonizZracenje;
    @FXML
    private CheckBox chBoxURNeoizaciskoZracenje;
    @FXML
    private CheckBox chBoxURPrasina;
    @FXML
    private TextField txtURKemiskeTvari;
    @FXML
    private TextField txtURBioloskeStetnosti;
    @FXML
    private TextField txtPrezime;
    private static RA1Controller instance;
    ObservableList<String> listaZdrPregled = FXCollections.observableArrayList((Object[])new String[]{"Prethodni", "Periodi\u010dki", "Izvanredni", "Kontrolni"});
    private Boolean izmjenaRA1 = false;
    private Boolean kreiranjeIzDjelatnika = false;
    private RAUputnica ra;

    public static RA1Controller getInstance() {
        return instance;
    }

    public RAUputnica getRa() {
        return this.ra;
    }

    public void setRa(RAUputnica ra) {
        this.ra = ra;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        ResizeComponent.makeTextFieldResize(this.txtZanimanje, this.txtTPPoslovi, this.txtTPOcijena, this.txtStrojevi, this.txtPredmeti, this.txtURKemiskeTvari, this.txtURBioloskeStetnosti);
        ResizeComponent.makeComboBoxResize(this.cboxTPDrugiPropisi1, this.cboxTPDrugiPropisi2);
        this.popuniCBoxStrucnaSprema();
        this.popuniCBoxMjesta();
        this.popuniCBoxZdrastveniPregled();
        this.popuniCBoxZakoni();
        this.dateDatumKreiranja.setValue((Object)LocalDate.now());
        this.txtPTPrenosenjeTereta.disableProperty().bind((ObservableValue)this.chBoxPTPrenosenjeTereta.selectedProperty().not());
        this.txtPTdizanjeTereta.disableProperty().bind((ObservableValue)this.chBoxPTDizanjeTereta.selectedProperty().not());
        this.txtPTguranjeTereta.disableProperty().bind((ObservableValue)this.chBoxPTguranjeTereta.selectedProperty().not());
        this.btnPretragaDjelatnika.setOnAction(e -> {
            Djelatnik d = FxDialogs.getDjelatnikDijalog();
            if (d != null) {
                this.popuniOsobu(d);
            }
        });
        this.btnSpremi.setOnAction(e -> this.spremiRa1uputnicu());
        this.btnTPPregledRadnihMjesta.setOnAction(e -> {
            RadnoMjesto rm = FxDialogs.getRadnoMjestoDijalog();
            if (rm != null) {
                this.popuniRadnoMjesto(rm);
            }
        });
    }

    private void popuniCBoxMjesta() {
        ResultSet rs = BazaRA1.dajMjesta();
        try {
            while (rs.next()) {
                this.cboxMjesto.getItems().add((Object)rs.getString("nazivgrada"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(RA1Controller.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(RA1Controller.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        FxUtil.autoCompleteComboBox(this.cboxMjesto, FxUtil.AutoCompleteMode.STARTS_WITH);
    }

    private void popuniCBoxStrucnaSprema() {
        ResultSet rs = BazaRA1.dajStrucnuSpremu();
        try {
            while (rs.next()) {
                this.cboxSkolskaSprema.getItems().add((Object)rs.getString("naziv"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(RA1Controller.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(RA1Controller.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void popuniCBoxZdrastveniPregled() {
        this.cboxTPZdrastveniPregled.getItems().addAll(this.listaZdrPregled);
    }

    private void popuniCBoxZakoni() {
        ResultSet rs = BazaRA1.dajZakone();
        try {
            while (rs.next()) {
                this.cboxTPDrugiPropisi1.getItems().add((Object)rs.getString("naziv"));
                this.cboxTPDrugiPropisi2.getItems().add((Object)rs.getString("naziv"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(RA1Controller.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(RA1Controller.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        ResizeComponent.sizeComboBoxToText(this.cboxTPDrugiPropisi1, (String)this.cboxTPDrugiPropisi1.getValue());
        ResizeComponent.sizeComboBoxToText(this.cboxTPDrugiPropisi2, (String)this.cboxTPDrugiPropisi2.getValue());
    }

    public void popuniOsobu(Djelatnik d) {
        this.txtOIB.setText(d.getOIB());
        this.txtIme.setText(d.getIme());
        this.txtPrezime.setText(d.getPrezime());
        if (d.getImeOca().equals("")) {
            this.txtImeOca.setText(d.getImeMajke());
        } else {
            this.txtImeOca.setText(d.getImeOca());
        }
        this.dateDatumRodjenja.setValue((Object)d.getDatumRodjenja());
        this.cboxMjesto.setValue((Object)d.getMjestoRodjenja());
        this.txtZanimanje.setText(d.getZanimianje());
        this.cboxSkolskaSprema.setValue((Object)d.getStrucnaSprema());
        this.txtTPPoslovi.setText(d.getRadnoMjesto());
        this.txtTPRadniStazNaOvimPoslovima.setText(d.getStazUTvrtci());
        this.izracunajStaz(d.getDatumZaposlenja(), d.getStazIzvanTvrtke());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popuniDjelatnika(Djelatnik d, DjelatnikLjijecnickiPregled djelatnikPregled) {
        this.kreiranjeIzDjelatnika = true;
        ResultSet rs = BazaRA1.getUputnicu(d);
        RAUputnica ra = null;
        try {
            while (rs.next()) {
                ra = new RAUputnica();
                ra.setOib(rs.getString("oib"));
                ra.setIme(rs.getString("ime"));
                ra.setPrezime(rs.getString("prezime"));
                ra.setImeOca_Majke(rs.getString("imeocamajke"));
                ra.setDatumRodjenja(DateUtil.getLocalDate(rs.getDate("datumrodjenja")));
                ra.setMjestoRodjenja(rs.getString("mjestorodjenja"));
                ra.setZanimianje(rs.getString("zanimanje"));
                ra.setStrucnaSprema(rs.getString("strucnasprema"));
                ra.setRadnoMjesto(rs.getString("radnomjesto"));
                ra.setClanak(rs.getString("clanak"));
                ra.setTocka(rs.getString("tocka"));
                ra.setDrugiPropisi(rs.getString("drugipropisi"));
                ra.setZrastveniPregled(rs.getString("zrastvenipregled"));
                ra.setUkupanStaz(rs.getString("ukupanstaz"));
                ra.setRadniStazUtvrtci(rs.getString("radnistazutvrci"));
                if (djelatnikPregled != null) {
                    ra.setDatumPosljednjegPregleda(djelatnikPregled.getDatumPregleda());
                    ra.setOcjenaZrastveneSposobnosti(djelatnikPregled.getNapomenaLijecnika());
                }
                ra.setDrugiPropisi2(rs.getString("drugipropisi"));
                ra.setClanak2(rs.getString("clanak"));
                ra.setTocka2(rs.getString("tocka"));
                ra.setOpisPosla(rs.getString("opisposla"));
                ra.setStrojevi(rs.getString("strojevi"));
                ra.setPredmeti(rs.getString("predmeti"));
                ra.setMRuZatvorenom(rs.getBoolean("mruzatvorenom"));
                ra.setMRnaOtvorenom(rs.getBoolean("mrnaotvorenom"));
                ra.setMRnaVisini(rs.getBoolean("mrnavisini"));
                ra.setMRuJami(rs.getBoolean("mrujami"));
                ra.setMRuVodi(rs.getBoolean("mruvodi"));
                ra.setMRpodVodom(rs.getBoolean("mrpodvodom"));
                ra.setMRuMokrom(rs.getBoolean("mrumokrom"));
                ra.setORuSmjenama(rs.getBoolean("orusmjenama"));
                ra.setORnocniRad(rs.getBoolean("ornocnorad"));
                ra.setORterenskiRad(rs.getBoolean("orterenskirad"));
                ra.setORradiSam(rs.getBoolean("orradisam"));
                ra.setORradUGrupama(rs.getBoolean("orradugrupama"));
                ra.setORradSaStrankama(rs.getBoolean("orradsastrankama"));
                ra.setORradNaTraci(rs.getBoolean("orradnatraci"));
                ra.setORbrziTempoRada(rs.getBoolean("orbrzitemporada"));
                ra.setORritamOdredjen(rs.getBoolean("orritamodredjen"));
                ra.setORmonotonija(rs.getBoolean("ormonotomija"));
                ra.setPTradStojeci(rs.getBoolean("ptradstojeci"));
                ra.setPTradSjedeci(rs.getBoolean("ptradsjedeci"));
                ra.setPTradUPokretu(rs.getBoolean("ptradupokretu"));
                ra.setPTKombinirano(rs.getBoolean("ptkombinirano"));
                ra.setPTdizanjeTereta(rs.getBoolean("ptdizanjetereta"));
                ra.setPTDizanjeTeretaKg(rs.getString("ptdizanjeteretakg"));
                ra.setPTUcestaloSagibanje(rs.getBoolean("ptucestalosagibanje"));
                ra.setPTzakretanjeTrupa(rs.getBoolean("ptzakretanjetrupa"));
                ra.setPTklecanje(rs.getBoolean("ptklecanje"));
                ra.setPTcucanje(rs.getBoolean("ptcucanje"));
                ra.setPTprenosTereta(rs.getBoolean("ptprenostereta"));
                ra.setPTprenosTeretaKg(rs.getString("ptprenosteretakg"));
                ra.setPTpodvlacenje(rs.getBoolean("ptpodvlacenje"));
                ra.setPTbalansiranje(rs.getBoolean("ptbalansiranje"));
                ra.setPTuspinjanjeLjestvama(rs.getBoolean("ptuspinjanjeljestvama"));
                ra.setPTuspinjanjeStepenicama(rs.getBoolean("ptuspinjanjestepenicama"));
                ra.setPTguranjeTereta(rs.getBoolean("ptguranjetereta"));
                ra.setPTguranjeTeretaKg(rs.getString("ptguranjeteretakg"));
                ra.setVidNaDaljinu(rs.getBoolean("vidnadaljinu"));
                ra.setVidNaBlizinu(rs.getBoolean("vidnablizinu"));
                ra.setRaspoznavanjeBoja(rs.getBoolean("raspoznavanjeboja"));
                ra.setDobarSluh(rs.getBoolean("dobarsluh"));
                ra.setJasanGovor(rs.getBoolean("jasangovor"));
                ra.setVisokaTemperatura(rs.getBoolean("visokatemperatura"));
                ra.setVisokaVlaznost(rs.getBoolean("visokavlaznost"));
                ra.setNiskaTemperatura(rs.getBoolean("niskatemperatura"));
                ra.setBuka(rs.getBoolean("buka"));
                ra.setVibracijeStroja(rs.getBoolean("vibracijastroja"));
                ra.setVibracijePoda(rs.getBoolean("vibracijapoda"));
                ra.setPovisenATTlak(rs.getBoolean("povisenattlak"));
                ra.setPovecanaIzloOzljedama(rs.getBoolean("povecanaizlozenostozljedama"));
                ra.setIonizaciskoZracenje(rs.getBoolean("ionizaciskozracenje"));
                ra.setNeionizaciskoZracenje(rs.getBoolean("neionizaciskozracenje"));
                ra.setPrasina(rs.getBoolean("prasina"));
                ra.setKemiskeTvari(rs.getString("kemisketveri"));
                ra.setBioloskeStetnosti(rs.getString("bioloskestetnosti"));
                ra.setBrojUputnice(rs.getString("brojuputnice"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PregledRA1Controller.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PregledRA1Controller.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.izmjenaUputniceOdDjelatnika(ra);
    }

    private void izracunajStaz(LocalDate datumZaposlenja, String stazIzvanTvrtke) {
        if (datumZaposlenja != null && stazIzvanTvrtke != null) {
            LocalDate dateEnd = LocalDate.now();
            long p2 = ChronoUnit.DAYS.between(datumZaposlenja, dateEnd);
            String line = stazIzvanTvrtke;
            StringTokenizer stringTokenizer = new StringTokenizer(RA1Controller.reduceToAlphaNumerics(line));
            int y = 0;
            int m = 0;
            int d = 0;
            while (stringTokenizer.hasMoreElements()) {
                y = Integer.parseInt(stringTokenizer.nextElement().toString());
                m = Integer.parseInt(stringTokenizer.nextElement().toString());
                d = Integer.parseInt(stringTokenizer.nextElement().toString());
            }
            dateEnd = dateEnd.plus(Period.of(y, m, d));
            Period p = Period.between(datumZaposlenja, dateEnd);
            this.txtTPUkupniStaz.setText(p.getYears() + "g " + p.getMonths() + "m " + p.getDays() + "d ");
        } else {
            this.txtTPUkupniStaz.setText("0g 0m 0d");
        }
    }

    public static String reduceToAlphaNumerics(String value) {
        return value.replaceAll("[^0-9]+", " ");
    }

    void izmjenaUputnice(RAUputnica ra) {
        this.izmjenaRA1 = true;
        this.ra = ra;
        this.dateDatumKreiranja.setValue((Object)ra.getDatumIzdavanjaUputnice());
        this.txtOIB.setText(ra.getOib());
        this.txtIme.setText(ra.getIme());
        this.txtPrezime.setText(ra.getPrezime());
        this.txtImeOca.setText(ra.getImeOca_Majke());
        this.dateDatumRodjenja.setValue((Object)ra.getDatumRodjenja());
        this.cboxMjesto.setValue((Object)ra.getMjestoRodjenja());
        this.txtZanimanje.setText(ra.getZanimianje());
        this.cboxSkolskaSprema.setValue((Object)ra.getStrucnaSprema());
        this.txtTPPoslovi.setText(ra.getRadnoMjesto());
        this.txtTPClanak.setText(ra.getClanak());
        this.txtTPTocka.setText(ra.getTocka());
        this.cboxTPDrugiPropisi1.setValue((Object)ra.getDrugiPropisi());
        this.cboxTPZdrastveniPregled.setValue((Object)ra.getZrastveniPregled());
        this.txtTPUkupniStaz.setText(ra.getUkupanStaz());
        this.txtTPRadniStazNaOvimPoslovima.setText(ra.getRadniStazUtvrtci());
        this.datumTPPosljednjPregled.setValue((Object)ra.getDatumPosljednjegPregleda());
        this.cboxTPDrugiPropisi2.setValue((Object)ra.getDrugiPropisi2());
        this.txtTPPOsljednjiClanak.setText(ra.getClanak2());
        this.txtTPPosljednjiTocka.setText(ra.getTocka2());
        this.txtTPOcijena.setText(ra.getOcjenaZrastveneSposobnosti());
        this.txtAreaOpisPosla.setText(ra.getOpisPosla());
        this.txtStrojevi.setText(ra.getStrojevi());
        this.txtPredmeti.setText(ra.getPredmeti());
        this.chBoxMRuZatvorenom.setSelected(ra.isMRuZatvorenom());
        this.chBoxMRnaotvorenom.setSelected(ra.isMRnaOtvorenom());
        this.chBoxMRnaVisini.setSelected(ra.isMRnaVisini());
        this.chBoxMRuJami.setSelected(ra.isMRuJami());
        this.chBoxMRuVodi.setSelected(ra.isMRuVodi());
        this.chBoxMRpodVodom.setSelected(ra.isMRpodVodom());
        this.chBoxMRuMokrom.setSelected(ra.isMRuMokrom());
        this.chBoxORuSmjenama.setSelected(ra.isORuSmjenama());
        this.chBoxORNocniRad.setSelected(ra.isORnocniRad());
        this.chBoxORTerenskiRad.setSelected(ra.isORterenskiRad());
        this.chBoxORRadiSam.setSelected(ra.isORradiSam());
        this.chBoxORuGrupi.setSelected(ra.isORradUGrupama());
        this.chBoxORsStrankama.setSelected(ra.isORradSaStrankama());
        this.chBoxORsStrankama.setSelected(ra.isORradNaTraci());
        this.chBoxORBrziTempo.setSelected(ra.isORbrziTempoRada());
        this.chBoxORRitamOdredjen.setSelected(ra.isORritamOdredjen());
        this.chBoxORMonotonija.setSelected(ra.isORmonotonija());
        this.chBoxORnaTraci.setSelected(ra.isORradNaTraci());
        this.chBoxPTradStojeci.setSelected(ra.isPTradStojeci());
        this.chBoxPTradSjedeci.setSelected(ra.isPTradSjedeci());
        this.chBoxPTraduPokretu.setSelected(ra.isPTradUPokretu());
        this.chBoxPTKombinirano.setSelected(ra.isPTKombinirano());
        this.chBoxPTDizanjeTereta.setSelected(ra.isPTdizanjeTereta());
        this.txtPTdizanjeTereta.setText(ra.getPTDizanjeTeretaKg());
        this.chBoxPTucestaloSagibanje.setSelected(ra.isPTUcestaloSagibanje());
        this.chBoxPTZakretanjeTrupa.setSelected(ra.isPTzakretanjeTrupa());
        this.chBoxPTCuceci.setSelected(ra.isPTcucanje());
        this.chBoxPTKlecanje.setSelected(ra.isPTklecanje());
        this.chBoxPTPrenosenjeTereta.setSelected(ra.isPTprenosTereta());
        this.txtPTPrenosenjeTereta.setText(ra.getPTprenosTeretaKg());
        this.chBoxPTpodvlacenje.setSelected(ra.isPTpodvlacenje());
        this.chBoxPTbalansiranje.setSelected(ra.isPTbalansiranje());
        this.chBoxPTuspinjanjeLjestvama.setSelected(ra.isPTuspinjanjeLjestvama());
        this.chBoxPTuspinjanjeStepenicama.setSelected(ra.isPTuspinjanjeStepenicama());
        this.chBoxPTguranjeTereta.setSelected(ra.isPTguranjeTereta());
        this.txtPTguranjeTereta.setText(ra.getPTguranjeTeretaKg());
        this.chBoxPVvidNaDaljinu.setSelected(ra.isVidNaDaljinu());
        this.chBoxPVvidNaBlizinu.setSelected(ra.isVidNaBlizinu());
        this.chBoxPVraspoznavanjeBoja.setSelected(ra.isRaspoznavanjeBoja());
        this.chBoxPVsluh.setSelected(ra.isDobarSluh());
        this.chBoxPVgovor.setSelected(ra.isJasanGovor());
        this.chBoxURVisokaTemperatura.setSelected(ra.isVisokaTemperatura());
        this.chBoxURVisokaVlaznost.setSelected(ra.isVisokaVlaznost());
        this.chBoxURNiskaTemperatura.setSelected(ra.isNiskaTemperatura());
        this.chBoxURBuka.setSelected(ra.isBuka());
        this.chBoxURVibracijaStroja.setSelected(ra.isVibracijeStroja());
        this.chBoxURVibracijaPoda.setSelected(ra.isVibracijePoda());
        this.chBoxURatmosferskiTlak.setSelected(ra.isPovisenATTlak());
        this.chBoxURPovecanaIzlozenostOzljedama.setSelected(ra.isPovecanaIzloOzljedama());
        this.chBoxURIonizZracenje.setSelected(ra.isIonizaciskoZracenje());
        this.chBoxURNeoizaciskoZracenje.setSelected(ra.isNeionizaciskoZracenje());
        this.chBoxURPrasina.setSelected(ra.isPrasina());
        this.txtURKemiskeTvari.setText(ra.getKemiskeTvari());
        this.txtURBioloskeStetnosti.setText(ra.getBioloskeStetnosti());
    }

    void izmjenaUputniceOdDjelatnika(RAUputnica ra) {
        if (ra != null) {
            this.txtOIB.setText(ra.getOib());
            this.txtIme.setText(ra.getIme());
            this.txtPrezime.setText(ra.getPrezime());
            this.txtImeOca.setText(ra.getImeOca_Majke());
            this.dateDatumRodjenja.setValue((Object)ra.getDatumRodjenja());
            this.cboxMjesto.setValue((Object)ra.getMjestoRodjenja());
            this.txtZanimanje.setText(ra.getZanimianje());
            this.cboxSkolskaSprema.setValue((Object)ra.getStrucnaSprema());
            this.txtTPPoslovi.setText(ra.getRadnoMjesto());
            this.txtTPClanak.setText(ra.getClanak());
            this.txtTPTocka.setText(ra.getTocka());
            this.cboxTPDrugiPropisi1.setValue((Object)ra.getDrugiPropisi());
            this.cboxTPZdrastveniPregled.setValue((Object)ra.getZrastveniPregled());
            this.txtTPUkupniStaz.setText(ra.getUkupanStaz());
            this.txtTPRadniStazNaOvimPoslovima.setText(ra.getRadniStazUtvrtci());
            this.datumTPPosljednjPregled.setValue((Object)ra.getDatumPosljednjegPregleda());
            this.cboxTPDrugiPropisi2.setValue((Object)ra.getDrugiPropisi2());
            this.txtTPPOsljednjiClanak.setText(ra.getClanak2());
            this.txtTPPosljednjiTocka.setText(ra.getTocka2());
            this.txtTPOcijena.setText(ra.getOcjenaZrastveneSposobnosti());
            this.txtAreaOpisPosla.setText(ra.getOpisPosla());
            this.txtStrojevi.setStyle(ra.getStrojevi());
            this.txtPredmeti.setText(ra.getPredmeti());
            this.chBoxMRuZatvorenom.setSelected(ra.isMRuZatvorenom());
            this.chBoxMRnaotvorenom.setSelected(ra.isMRnaOtvorenom());
            this.chBoxMRnaVisini.setSelected(ra.isMRnaVisini());
            this.chBoxMRuJami.setSelected(ra.isMRuJami());
            this.chBoxMRuVodi.setSelected(ra.isMRuVodi());
            this.chBoxMRpodVodom.setSelected(ra.isMRpodVodom());
            this.chBoxMRuMokrom.setSelected(ra.isMRuMokrom());
            this.chBoxORuSmjenama.setSelected(ra.isORuSmjenama());
            this.chBoxORNocniRad.setSelected(ra.isORnocniRad());
            this.chBoxORTerenskiRad.setSelected(ra.isORterenskiRad());
            this.chBoxORRadiSam.setSelected(ra.isORradiSam());
            this.chBoxORuGrupi.setSelected(ra.isORradUGrupama());
            this.chBoxORsStrankama.setSelected(ra.isORradSaStrankama());
            this.chBoxORsStrankama.setSelected(ra.isORradNaTraci());
            this.chBoxORBrziTempo.setSelected(ra.isORbrziTempoRada());
            this.chBoxORRitamOdredjen.setSelected(ra.isORritamOdredjen());
            this.chBoxORMonotonija.setSelected(ra.isORmonotonija());
            this.chBoxORnaTraci.setSelected(ra.isORradNaTraci());
            this.chBoxPTradStojeci.setSelected(ra.isPTradStojeci());
            this.chBoxPTradSjedeci.setSelected(ra.isPTradSjedeci());
            this.chBoxPTraduPokretu.setSelected(ra.isPTradUPokretu());
            this.chBoxPTKombinirano.setSelected(ra.isPTKombinirano());
            this.chBoxPTDizanjeTereta.setSelected(ra.isPTdizanjeTereta());
            this.txtPTdizanjeTereta.setText(ra.getPTDizanjeTeretaKg());
            this.chBoxPTucestaloSagibanje.setSelected(ra.isPTUcestaloSagibanje());
            this.chBoxPTZakretanjeTrupa.setSelected(ra.isPTzakretanjeTrupa());
            this.chBoxPTCuceci.setSelected(ra.isPTcucanje());
            this.chBoxPTKlecanje.setSelected(ra.isPTklecanje());
            this.chBoxPTPrenosenjeTereta.setSelected(ra.isPTprenosTereta());
            this.txtPTPrenosenjeTereta.setText(ra.getPTprenosTeretaKg());
            this.chBoxPTpodvlacenje.setSelected(ra.isPTpodvlacenje());
            this.chBoxPTbalansiranje.setSelected(ra.isPTbalansiranje());
            this.chBoxPTuspinjanjeLjestvama.setSelected(ra.isPTuspinjanjeLjestvama());
            this.chBoxPTuspinjanjeStepenicama.setSelected(ra.isPTuspinjanjeStepenicama());
            this.chBoxPTguranjeTereta.setSelected(ra.isPTguranjeTereta());
            this.txtPTguranjeTereta.setText(ra.getPTguranjeTeretaKg());
            this.chBoxPVvidNaDaljinu.setSelected(ra.isVidNaDaljinu());
            this.chBoxPVvidNaBlizinu.setSelected(ra.isVidNaBlizinu());
            this.chBoxPVraspoznavanjeBoja.setSelected(ra.isRaspoznavanjeBoja());
            this.chBoxPVsluh.setSelected(ra.isDobarSluh());
            this.chBoxPVgovor.setSelected(ra.isJasanGovor());
            this.chBoxURVisokaTemperatura.setSelected(ra.isVisokaTemperatura());
            this.chBoxURVisokaVlaznost.setSelected(ra.isVisokaVlaznost());
            this.chBoxURNiskaTemperatura.setSelected(ra.isNiskaTemperatura());
            this.chBoxURBuka.setSelected(ra.isBuka());
            this.chBoxURVibracijaStroja.setSelected(ra.isVibracijeStroja());
            this.chBoxURVibracijaPoda.setSelected(ra.isVibracijePoda());
            this.chBoxURatmosferskiTlak.setSelected(ra.isPovisenATTlak());
            this.chBoxURPovecanaIzlozenostOzljedama.setSelected(ra.isPovecanaIzloOzljedama());
            this.chBoxURIonizZracenje.setSelected(ra.isIonizaciskoZracenje());
            this.chBoxURNeoizaciskoZracenje.setSelected(ra.isNeionizaciskoZracenje());
            this.chBoxURPrasina.setSelected(ra.isPrasina());
            this.txtURKemiskeTvari.setText(ra.getKemiskeTvari());
            this.txtURBioloskeStetnosti.setText(ra.getBioloskeStetnosti());
        }
    }

    private void spremiRa1uputnicu() {
        boolean bprezime;
        boolean bime;
        boolean bOib = FormValidation.textFieldValidationonlyText(this.txtOIB);
        if (bOib & (bime = FormValidation.textFieldValidationonlyText(this.txtIme)) & (bprezime = FormValidation.textFieldValidationonlyText(this.txtPrezime))) {
            if (this.izmjenaRA1.booleanValue()) {
                if (BazaRA1.izmjenaRA1Uputnice(GlavniPanelController.getOdabranaTvrtka(), this.dajRa1(), this.ra.getId())) {
                    PregledRA1Controller.getInstance().popuniTablicuPopisRA1Uputnica();
                    GlavniPanelController.getInstance().zatvoriTab("Unos RA1 uputnice");
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena uputnice", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena uputnice", 2, "Error graphic");
                }
            } else if (this.kreiranjeIzDjelatnika.booleanValue()) {
                if (BazaRA1.unesiNovuRA1Uputnicu(GlavniPanelController.getOdabranaTvrtka(), this.dajRa1())) {
                    if (!GlavniPanelController.getInstance().getTabByIdifExist("Popis RA-1 uputnica")) {
                        PregledRA1Controller.getInstance().popuniTablicuPopisRA1Uputnica();
                        GlavniPanelController.getInstance().zatvoriTab("Unos RA1 uputnice");
                    } else {
                        GlavniPanelController.getInstance().zatvoriTab("Unos RA1 uputnice");
                    }
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesena uputnica", 1, "Information graphic");
                    this.kreiranjeIzDjelatnika = false;
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesena uputnica", 2, "Error graphic");
                }
            } else if (this.izmjenaRA1 == false & this.kreiranjeIzDjelatnika == false) {
                if (BazaRA1.unesiNovuRA1Uputnicu(GlavniPanelController.getOdabranaTvrtka(), this.dajRa1())) {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesena uputnica", 1, "Information graphic");
                    PregledRA1Controller.getInstance().popuniTablicuPopisRA1Uputnica();
                    GlavniPanelController.getInstance().zatvoriTab("Unos RA1 uputnice");
                    this.izmjenaRA1 = false;
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesena uputnica", 2, "Error graphic");
                }
            }
        } else {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate popuniti sva oznacena polja");
            alert.showAndWait();
        }
    }

    private RAUputnica dajRa1() {
        RAUputnica ra = new RAUputnica();
        ra.setDatumIzdavanjaUputnice((LocalDate)this.dateDatumKreiranja.getValue());
        ra.setOib(this.txtOIB.getText());
        ra.setIme(this.txtIme.getText());
        ra.setPrezime(this.txtPrezime.getText());
        ra.setImeOca_Majke(this.txtImeOca.getText());
        ra.setDatumRodjenja((LocalDate)this.dateDatumRodjenja.getValue());
        ra.setMjestoRodjenja((String)this.cboxMjesto.getValue());
        ra.setZanimianje(this.txtZanimanje.getText());
        ra.setStrucnaSprema((String)this.cboxSkolskaSprema.getValue());
        ra.setRadnoMjesto(this.txtTPPoslovi.getText());
        ra.setClanak(this.txtTPClanak.getText());
        ra.setTocka(this.txtTPTocka.getText());
        ra.setDrugiPropisi((String)this.cboxTPDrugiPropisi1.getValue());
        ra.setZrastveniPregled((String)this.cboxTPZdrastveniPregled.getValue());
        ra.setUkupanStaz(this.txtTPUkupniStaz.getText());
        ra.setRadniStazUtvrtci(this.txtTPRadniStazNaOvimPoslovima.getText());
        ra.setDatumPosljednjegPregleda((LocalDate)this.datumTPPosljednjPregled.getValue());
        ra.setDrugiPropisi2((String)this.cboxTPDrugiPropisi2.getValue());
        ra.setClanak2(this.txtTPPOsljednjiClanak.getText());
        ra.setTocka2(this.txtTPPosljednjiTocka.getText());
        ra.setOcjenaZrastveneSposobnosti(this.txtTPOcijena.getText());
        ra.setOpisPosla(this.txtAreaOpisPosla.getText());
        ra.setStrojevi(this.txtStrojevi.getText());
        ra.setPredmeti(this.txtPredmeti.getText());
        ra.setMRuZatvorenom(this.chBoxMRuZatvorenom.isSelected());
        ra.setMRnaOtvorenom(this.chBoxMRnaotvorenom.isSelected());
        ra.setMRnaVisini(this.chBoxMRnaVisini.isSelected());
        ra.setMRuJami(this.chBoxMRuJami.isSelected());
        ra.setMRuVodi(this.chBoxMRuVodi.isSelected());
        ra.setMRpodVodom(this.chBoxMRpodVodom.isSelected());
        ra.setMRuMokrom(this.chBoxMRuMokrom.isSelected());
        ra.setORuSmjenama(this.chBoxORuSmjenama.isSelected());
        ra.setORnocniRad(this.chBoxORNocniRad.isSelected());
        ra.setORterenskiRad(this.chBoxORTerenskiRad.isSelected());
        ra.setORradiSam(this.chBoxORRadiSam.isSelected());
        ra.setORradUGrupama(this.chBoxORuGrupi.isSelected());
        ra.setORradSaStrankama(this.chBoxORsStrankama.isSelected());
        ra.setORradNaTraci(this.chBoxORnaTraci.isSelected());
        ra.setORbrziTempoRada(this.chBoxORBrziTempo.isSelected());
        ra.setORritamOdredjen(this.chBoxORRitamOdredjen.isSelected());
        ra.setORmonotonija(this.chBoxORMonotonija.isSelected());
        ra.setPTradStojeci(this.chBoxPTradStojeci.isSelected());
        ra.setPTradSjedeci(this.chBoxPTradSjedeci.isSelected());
        ra.setPTradUPokretu(this.chBoxPTraduPokretu.isSelected());
        ra.setPTKombinirano(this.chBoxPTKombinirano.isSelected());
        ra.setPTdizanjeTereta(this.chBoxPTDizanjeTereta.isSelected());
        ra.setPTDizanjeTeretaKg(this.txtPTdizanjeTereta.getText());
        ra.setPTUcestaloSagibanje(this.chBoxPTucestaloSagibanje.isSelected());
        ra.setPTzakretanjeTrupa(this.chBoxPTZakretanjeTrupa.isSelected());
        ra.setPTcucanje(this.chBoxPTCuceci.isSelected());
        ra.setPTklecanje(this.chBoxPTKlecanje.isSelected());
        ra.setPTprenosTereta(this.chBoxPTPrenosenjeTereta.isSelected());
        ra.setPTprenosTeretaKg(this.txtPTPrenosenjeTereta.getText());
        ra.setPTpodvlacenje(this.chBoxPTpodvlacenje.isSelected());
        ra.setPTbalansiranje(this.chBoxPTbalansiranje.isSelected());
        ra.setPTuspinjanjeLjestvama(this.chBoxPTuspinjanjeLjestvama.isSelected());
        ra.setPTuspinjanjeStepenicama(this.chBoxPTuspinjanjeStepenicama.isSelected());
        ra.setPTguranjeTereta(this.chBoxPTguranjeTereta.isSelected());
        ra.setPTguranjeTeretaKg(this.txtPTguranjeTereta.getText());
        ra.setVidNaDaljinu(this.chBoxPVvidNaDaljinu.isSelected());
        ra.setVidNaBlizinu(this.chBoxPVvidNaBlizinu.isSelected());
        ra.setRaspoznavanjeBoja(this.chBoxPVraspoznavanjeBoja.isSelected());
        ra.setDobarSluh(this.chBoxPVsluh.isSelected());
        ra.setJasanGovor(this.chBoxPVgovor.isSelected());
        ra.setVisokaTemperatura(this.chBoxURVisokaTemperatura.isSelected());
        ra.setVisokaVlaznost(this.chBoxURVisokaVlaznost.isSelected());
        ra.setNiskaTemperatura(this.chBoxURNiskaTemperatura.isSelected());
        ra.setBuka(this.chBoxURBuka.isSelected());
        ra.setVibracijeStroja(this.chBoxURVibracijaStroja.isSelected());
        ra.setVibracijePoda(this.chBoxURVibracijaPoda.isSelected());
        ra.setPovisenATTlak(this.chBoxURatmosferskiTlak.isSelected());
        ra.setPovecanaIzloOzljedama(this.chBoxURPovecanaIzlozenostOzljedama.isSelected());
        ra.setIonizaciskoZracenje(this.chBoxURIonizZracenje.isSelected());
        ra.setNeionizaciskoZracenje(this.chBoxURNeoizaciskoZracenje.isSelected());
        ra.setPrasina(this.chBoxURPrasina.isSelected());
        ra.setKemiskeTvari(this.txtURKemiskeTvari.getText());
        ra.setBioloskeStetnosti(this.txtURBioloskeStetnosti.getText());
        return ra;
    }

    private void popuniRadnoMjesto(RadnoMjesto rm) {
        this.txtTPPoslovi.setText(rm.getNaziv());
        this.txtTPClanak.setText(rm.getClanak());
        this.txtTPTocka.setText(rm.getTockePregleda());
        this.txtAreaOpisPosla.setText(rm.getOpisPosla());
        this.txtStrojevi.setText(rm.getStrojevi());
        this.txtPredmeti.setText(rm.getPredmeti());
        this.chBoxMRuZatvorenom.setSelected(rm.isMRuZatvorenom());
        this.chBoxMRnaotvorenom.setSelected(rm.isMRnaOtvorenom());
        this.chBoxMRnaVisini.setSelected(rm.isMRnaVisini());
        this.chBoxMRuJami.setSelected(rm.isMRuJami());
        this.chBoxMRuVodi.setSelected(rm.isMRuVodi());
        this.chBoxMRpodVodom.setSelected(rm.isMRpodVodom());
        this.chBoxMRuMokrom.setSelected(rm.isMRuMokrom());
        this.chBoxORuSmjenama.setSelected(rm.isORuSmjenama());
        this.chBoxORNocniRad.setSelected(rm.isORnocniRad());
        this.chBoxORTerenskiRad.setSelected(rm.isORterenskiRad());
        this.chBoxORRadiSam.setSelected(rm.isORradiSam());
        this.chBoxORuGrupi.setSelected(rm.isORradUGrupama());
        this.chBoxORsStrankama.setSelected(rm.isORradSaStrankama());
        this.chBoxORsStrankama.setSelected(rm.isORradNaTraci());
        this.chBoxORBrziTempo.setSelected(rm.isORbrziTempoRada());
        this.chBoxORRitamOdredjen.setSelected(rm.isORritamOdredjen());
        this.chBoxORMonotonija.setSelected(rm.isORmonotonija());
        this.chBoxORnaTraci.setSelected(rm.isORradNaTraci());
        this.chBoxPTradStojeci.setSelected(rm.isPTradStojeci());
        this.chBoxPTradSjedeci.setSelected(rm.isPTradSjedeci());
        this.chBoxPTraduPokretu.setSelected(rm.isPTradUPokretu());
        this.chBoxPTKombinirano.setSelected(rm.isPTKombinirano());
        this.chBoxPTDizanjeTereta.setSelected(rm.isPTdizanjeTereta());
        this.txtPTdizanjeTereta.setText(rm.getPTDizanjeTeretaKg());
        this.chBoxPTucestaloSagibanje.setSelected(rm.isPTUcestaloSagibanje());
        this.chBoxPTZakretanjeTrupa.setSelected(rm.isPTzakretanjeTrupa());
        this.chBoxPTCuceci.setSelected(rm.isPTcucanje());
        this.chBoxPTKlecanje.setSelected(rm.isPTklecanje());
        this.chBoxPTPrenosenjeTereta.setSelected(rm.isPTprenosTereta());
        this.txtPTPrenosenjeTereta.setText(rm.getPTprenosTeretaKg());
        this.chBoxPTpodvlacenje.setSelected(rm.isPTpodvlacenje());
        this.chBoxPTbalansiranje.setSelected(rm.isPTbalansiranje());
        this.chBoxPTuspinjanjeLjestvama.setSelected(rm.isPTuspinjanjeLjestvama());
        this.chBoxPTuspinjanjeStepenicama.setSelected(rm.isPTuspinjanjeStepenicama());
        this.chBoxPTguranjeTereta.setSelected(rm.isPTguranjeTereta());
        this.txtPTguranjeTereta.setText(rm.getPTguranjeTeretaKg());
        this.chBoxPVvidNaDaljinu.setSelected(rm.isVidNaDaljinu());
        this.chBoxPVvidNaBlizinu.setSelected(rm.isVidNaBlizinu());
        this.chBoxPVraspoznavanjeBoja.setSelected(rm.isRaspoznavanjeBoja());
        this.chBoxPVsluh.setSelected(rm.isDobarSluh());
        this.chBoxPVgovor.setSelected(rm.isJasanGovor());
        this.chBoxURVisokaTemperatura.setSelected(rm.isVisokaTemperatura());
        this.chBoxURVisokaVlaznost.setSelected(rm.isVisokaVlaznost());
        this.chBoxURNiskaTemperatura.setSelected(rm.isNiskaTemperatura());
        this.chBoxURBuka.setSelected(rm.isBuka());
        this.chBoxURVibracijaStroja.setSelected(rm.isVibracijeStroja());
        this.chBoxURVibracijaPoda.setSelected(rm.isVibracijePoda());
        this.chBoxURatmosferskiTlak.setSelected(rm.isPovisenATTlak());
        this.chBoxURPovecanaIzlozenostOzljedama.setSelected(rm.isPovecanaIzloOzljedama());
        this.chBoxURIonizZracenje.setSelected(rm.isIonizaciskoZracenje());
        this.chBoxURNeoizaciskoZracenje.setSelected(rm.isNeionizaciskoZracenje());
        this.chBoxURPrasina.setSelected(rm.isPrasina());
        this.txtURKemiskeTvari.setText(rm.getKemiskeTvari());
        this.txtURBioloskeStetnosti.setText(rm.getBioloskeStetnosti());
    }
}

