/*
 * Decompiled with CFR 0.152.
 */
package vatrogasniaparati;

import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import vatrogasniaparati.BazaVatrogasniAparati;
import vatrogasniaparati.UnosVrsteVatrogasnihAparataController;
import vatrogasniaparati.VrstaVatrogasnihAparata;
import zastitanaradu.GlavniPanelController;

public class PopisVrstaVAController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<VrstaVatrogasnihAparata> tablicaPopisVrstaVA;
    @FXML
    private TableColumn<VrstaVatrogasnihAparata, String> kolPretraga;
    @FXML
    private TableColumn<VrstaVatrogasnihAparata, String> kolRedBr;
    @FXML
    private TableColumn<VrstaVatrogasnihAparata, String> kolOznaka;
    @FXML
    private TableColumn<VrstaVatrogasnihAparata, String> kolNaziv;
    private static PopisVrstaVAController instance;
    private final ObservableList<VrstaVatrogasnihAparata> listaVrsteVA = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static PopisVrstaVAController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediKoloneUTabliciVrsteVA();
        this.popuniTablicuVrsteVA();
        this.urediFilter(this.tablicaPopisVrstaVA);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos vrste VA")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos vrste VA");
                GlavniPanelController.getInstance().nadodajPanel("Unos vrste VA", "/vatrogasniaparati/UnosVrsteVatrogasnihAparata.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos vrste VA", "/vatrogasniaparati/UnosVrsteVatrogasnihAparata.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            VrstaVatrogasnihAparata g;
            int selectdIndex = this.tablicaPopisVrstaVA.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (g = (VrstaVatrogasnihAparata)this.tablicaPopisVrstaVA.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos vrste VA")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos vrste VA");
                    GlavniPanelController.getInstance().nadodajPanel("Unos vrste VA", "/vatrogasniaparati/UnosVrsteVatrogasnihAparata.fxml");
                    UnosVrsteVatrogasnihAparataController.getInstance().izmjenaVrsteVA(g);
                    this.tablicaPopisVrstaVA.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos vrste VA", "/vatrogasniaparati/UnosVrsteVatrogasnihAparata.fxml");
                    UnosVrsteVatrogasnihAparataController.getInstance().izmjenaVrsteVA(g);
                    this.tablicaPopisVrstaVA.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisVrstaVA.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati vrstu")).showAndWait()).get() == ButtonType.OK) {
                if (BazaVatrogasniAparati.obrisiVrstuVA((VrstaVatrogasnihAparata)this.tablicaPopisVrstaVA.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuVrsteVA();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisana vrsta", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisana vrsta", 2, "Error graphic");
                }
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Oznaka", "Naziv"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaVrsteVA, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Oznaka") ? pregled.getOznaka() != null && pregled.getOznaka().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv") && pregled.getNaziv() != null && pregled.getNaziv().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediKoloneUTabliciVrsteVA() {
        this.tablicaPopisVrstaVA.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisVrstaVAController.this.tablicaPopisVrstaVA.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cell -> ((VrstaVatrogasnihAparata)cell.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisVrstaVA.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolOznaka.setCellValueFactory(cell -> ((VrstaVatrogasnihAparata)cell.getValue()).oznakaProperty());
        this.kolOznaka.prefWidthProperty().bind((ObservableValue)this.tablicaPopisVrstaVA.widthProperty().divide(5.0));
        this.kolOznaka.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellValueFactory(cell -> ((VrstaVatrogasnihAparata)cell.getValue()).nazivProperty());
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaPopisVrstaVA.widthProperty().divide(1.4492753623188406));
        this.kolNaziv.setStyle("-fx-alignment: CENTER;");
        this.kolPretraga.setGraphic((Node)this.tbFilter);
    }

    public void popuniTablicuVrsteVA() {
        this.tablicaPopisVrstaVA.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Random rng = new Random();
        Task task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaVrsteVA.clear();
        this.tablicaPopisVrstaVA.getItems().clear();
    }

    private Task createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisVrstaVAController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PopisVrstaVAController.this.popuniTablicu();
                }
                finally {
                    Platform.runLater(() -> PopisVrstaVAController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicu() {
        ResultSet rs = BazaVatrogasniAparati.dajVrsteVA(GlavniPanelController.getOdabranaTvrtka());
        VrstaVatrogasnihAparata va = null;
        int br = 1;
        try {
            while (rs.next()) {
                va = new VrstaVatrogasnihAparata();
                va.setId(rs.getInt("id"));
                va.setRedBroj(String.valueOf(br));
                va.setOznaka(rs.getString("oznaka"));
                va.setNaziv(rs.getString("naziv"));
                this.listaVrsteVA.add((Object)va);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisVrstaVAController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisVrstaVAController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisVrstaVA.getItems().addAll(this.listaVrsteVA);
    }
}

