/*
 * Decompiled with CFR 0.152.
 */
package vatrogasniaparati;

import Utill.ComboBoxCellDokument;
import Utill.DateCell;
import Utill.DateUtil;
import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.ScanDokument;
import Utill.TextAreaTableCell;
import dokumentiTvrtke.BazaDokumenti;
import dokumentiTvrtke.DokumentHiperlinkCell;
import ispisJasper.IspisReporta;
import java.io.File;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.ComboBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import javafx.util.StringConverter;
import kadrovska.BazaDjelatnik;
import kadrovska.Djelatnik;
import monitoringnovi.ServiceRestart;
import odjeli.BazaOdjeli;
import poslovnejedinice.PoslovneJedinice;
import strojevi.Strojevi;
import vatrogasniaparati.BazaVatrogasniAparati;
import vatrogasniaparati.ComboBoxCellDjelatniciVA;
import vatrogasniaparati.ComboBoxCellVAPregled;
import vatrogasniaparati.PopisVatrogasnihAparataController;
import vatrogasniaparati.VAZaduzeneOsobe;
import vatrogasniaparati.VatrogasniAparat;
import vatrogasniaparati.VatrogasniAparatPregled;
import zastitanaradu.GlavniPanelController;

public class UnosVatrogasnogAparataController
implements Initializable {
    @FXML
    private TabPane tabPanelPodaci;
    @FXML
    private Button btnSpremi;
    @FXML
    private AnchorPane anchorPanelStroj;
    @FXML
    private TextField txtSifraAparata;
    @FXML
    private TextField txtNazivAparata;
    @FXML
    private Button btnPretragaStroja;
    @FXML
    private TabPane tabPanePodaci;
    @FXML
    private ComboBox<PoslovneJedinice> cBoxPoslovnaJedinica;
    @FXML
    private ComboBox<String> cBoxOdjel;
    @FXML
    private TextField txtMjestoAdresa;
    @FXML
    private TextArea txtAreaOznakaLokacije;
    @FXML
    private ComboBox<String> cboxProizvodjac;
    @FXML
    private ComboBox<String> cboxModel;
    @FXML
    private TextField txtInventurniBroj;
    @FXML
    private TextField txtTvornickiBroj;
    @FXML
    private TextField txtGodinaProizvodnje;
    @FXML
    private DatePicker dateStavljanjeUPogon;
    @FXML
    private ComboBox<String> cBoxVrstaAparata;
    @FXML
    private CheckBox chboxAparatUVozilu;
    @FXML
    private TextField txtRegistracijaVozila;
    @FXML
    private CheckBox chBoxRazduzen;
    @FXML
    private TextArea txtAreaNapomena;
    @FXML
    private Tab tabZaduzeneOsobe;
    @FXML
    private TableView<VAZaduzeneOsobe> tablicaZaduzeneOsobe;
    @FXML
    private TableColumn<VAZaduzeneOsobe, String> kolRedBrZO;
    @FXML
    private TableColumn<VAZaduzeneOsobe, String> kolSifra;
    @FXML
    private TableColumn<VAZaduzeneOsobe, String> kolNaziv;
    @FXML
    private Button btnUnosZOsobe;
    @FXML
    private Button btnBrisanjeZOsobe;
    @FXML
    private Button btnIspisZOsobe;
    @FXML
    private Tab tabEvidencijaPregleda;
    @FXML
    private Button btnUnosPStroja;
    @FXML
    private Button btnBrisanjePStroja;
    @FXML
    private Button btnIspisEK24PStroja;
    @FXML
    private TableView<VatrogasniAparatPregled> tablicaEvidencijaPregleda;
    @FXML
    private TableColumn<VatrogasniAparatPregled, String> kolRedBrPregledStroja;
    @FXML
    private TableColumn<VatrogasniAparatPregled, LocalDate> kolDatumObavljenogPregleda;
    @FXML
    private TableColumn<VatrogasniAparatPregled, String> kolVrstaPregleda;
    @FXML
    private TableColumn<VatrogasniAparatPregled, String> kolOrganizacija;
    @FXML
    private TableColumn<VatrogasniAparatPregled, String> kolBrojIsprave;
    @FXML
    private TableColumn<VatrogasniAparatPregled, String> kolIzvrseniPopravci;
    @FXML
    private TableColumn<VatrogasniAparatPregled, String> kolBrojServisneNaljepnice;
    @FXML
    private TableColumn<VatrogasniAparatPregled, LocalDate> kolDatumServisneNaljepnica;
    @FXML
    private TableColumn<VatrogasniAparatPregled, LocalDate> kolDatumPonovogIspitivanja;
    @FXML
    private TableColumn<VatrogasniAparatPregled, String> kolIspravno;
    @FXML
    private TableColumn<VatrogasniAparatPregled, String> kolDokument;
    @FXML
    private TableColumn<VatrogasniAparatPregled, String> kolPodatkeUpisao;
    @FXML
    private Tab tabDokumenti;
    @FXML
    private TextField txtOpis;
    @FXML
    private TableView<ScanDokument> tablicaDokumenti;
    @FXML
    private TableColumn<ScanDokument, String> kolRedBr;
    @FXML
    private TableColumn<ScanDokument, String> kolNazivDokumenta;
    @FXML
    private Button btnSpremiDokument;
    @FXML
    private Button btnBrisanjeDokument;
    @FXML
    private TextField txtServisnaNaljepnica;
    @FXML
    private DatePicker dateServisnaNaljepnica;
    private static UnosVatrogasnogAparataController instance;
    private final ObservableList<String> listaVrstaAparata = FXCollections.observableArrayList();
    private ObservableList<ScanDokument> listaDokumenti = FXCollections.observableArrayList();
    private ObservableList<VatrogasniAparatPregled> listaVAPregled = FXCollections.observableArrayList();
    private ObservableList<VAZaduzeneOsobe> listaStrojZaduzeneOsobe = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();
    private Boolean izmjenaAparata = false;
    BooleanProperty bp = new SimpleBooleanProperty(false);
    private VatrogasniAparat va = null;

    public TabPane getTabPanelPodaci() {
        return this.tabPanelPodaci;
    }

    public static UnosVatrogasnogAparataController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.popuniCBoxPoslovnice();
        this.popuniCBoxProizvodjac();
        this.cboxProizvodjac.valueProperty().addListener((o, ov, nv) -> this.popuniCBoxModel((String)nv));
        this.popuniCBoxVrsteAparata();
        this.urediTablicuZaduzeneOsobe();
        this.popuniTablicuZaduzeneOsobe();
        this.cBoxPoslovnaJedinica.valueProperty().addListener((o, ov, nv) -> {
            PoslovneJedinice p = nv;
            this.popuniOdjelePoslovneJedinice(p.getId());
            this.txtMjestoAdresa.setText(p.getAdresaPoslovnice() + " ," + p.getMjesto());
        });
        this.btnPretragaStroja.setOnAction(e -> {
            Strojevi st = FxDialogs.getDialogNazivStrojeva();
            if (st != null) {
                this.txtNazivAparata.setText(st.getNaziv());
                this.txtSifraAparata.setText(st.getOznaka());
            }
        });
        this.txtRegistracijaVozila.disableProperty().bind((ObservableValue)this.chboxAparatUVozilu.selectedProperty().not());
        this.btnSpremi.setOnAction(e -> this.spremiAparat());
        this.tabDokumenti.disableProperty().bind((ObservableValue)this.bp.not());
        this.tabEvidencijaPregleda.disableProperty().bind((ObservableValue)this.bp.not());
        this.tabZaduzeneOsobe.disableProperty().bind((ObservableValue)this.bp.not());
        this.btnUnosZOsobe.setOnAction(e -> {
            VAZaduzeneOsobe zo = new VAZaduzeneOsobe();
            if (BazaVatrogasniAparati.unesiNovuZaduzenuOsobu(zo, GlavniPanelController.getOdabranaTvrtka().getId(), this.va.getId())) {
                this.popuniTablicuZaduzeneOsobe();
            } else {
                FxDialogs.showError("Gre\u0161ka unosa", "Neuspje\u0161an unos osobe");
            }
        });
        this.btnBrisanjeZOsobe.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaZaduzeneOsobe.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati djelatnika")).showAndWait()).get() == ButtonType.OK) {
                if (BazaVatrogasniAparati.obrisiZaduzenuOsobu((VAZaduzeneOsobe)this.tablicaZaduzeneOsobe.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuZaduzeneOsobe();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no brisanje ", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no brisanje", 2, "Error graphic");
                }
            }
        });
        this.urediKoloneUTabliciDokumenti();
        this.popuniTablicuDokumenti();
        this.btnBrisanjeDokument.disableProperty().bind((ObservableValue)Bindings.equal((ObservableNumberValue)this.tablicaDokumenti.getSelectionModel().selectedIndexProperty(), (int)-1));
        this.btnBrisanjeDokument.setOnAction(event -> {
            int selectedIdx = this.tablicaDokumenti.getSelectionModel().getSelectedIndex();
            ScanDokument sc = (ScanDokument)this.tablicaDokumenti.getSelectionModel().getSelectedItem();
            Alert alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje Dokumenta", "\u017delite li obrisati dokument ?");
            Optional result = alert.showAndWait();
            if (selectedIdx != -1) {
                if (result.get() == ButtonType.OK) {
                    if (BazaDokumenti.deleteDokument(sc)) {
                        this.popuniTablicuDokumenti();
                    } else {
                        Alert error = FxDialogs.getDialog(Alert.AlertType.ERROR, "Brisanje dokumenta", "Neuspjelo brisanje dokumenta");
                        error.showAndWait();
                    }
                } else {
                    this.tablicaDokumenti.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnSpremiDokument.setOnAction(e -> {
            block6: {
                boolean bopis = FormValidation.textFieldValidationonlyText(this.txtOpis);
                if (bopis) {
                    FileChooser fileChooser = new FileChooser();
                    File selectedFile = fileChooser.showOpenDialog(null);
                    if (selectedFile != null) {
                        try {
                            byte[] byteImage = KlasaKorisneMetode.ImageToByte(new File(selectedFile.getAbsolutePath()));
                            if (BazaDokumenti.addDokumentVatrogasniAparat(this.txtOpis.getText() + " (" + LocalDate.now().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)) + ")." + KlasaKorisneMetode.getExtension(selectedFile), GlavniPanelController.getOdabranaTvrtka(), this.va.getId(), byteImage, GlavniPanelController.getInstance().getKorisnik().punoIme())) {
                                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen dokument", 1, "Information graphic");
                                this.txtOpis.clear();
                                this.popuniTablicuDokumenti();
                                break block6;
                            }
                            KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesen dokument", 2, "Error graphic");
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                } else {
                    Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate unjeti naziv Dokumenta");
                    alert.showAndWait();
                }
            }
        });
        this.urediTblicuEvidencijaPregleda();
        this.popuniTablicuVAPregledi();
        this.btnUnosPStroja.setOnAction(e -> {
            VatrogasniAparatPregled pr = new VatrogasniAparatPregled();
            pr.setPodatkeUpisao(GlavniPanelController.getInstance().getKorisnik().punoIme());
            if (BazaVatrogasniAparati.unesiNoviVAPregled(pr, GlavniPanelController.getOdabranaTvrtka().getId(), this.va.getId())) {
                this.popuniTablicuVAPregledi();
            } else {
                FxDialogs.showError("Gre\u0161ka unosa", "Neuspje\u0161an unos pregleda");
            }
        });
        this.btnBrisanjePStroja.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaEvidencijaPregleda.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati  pregled")).showAndWait()).get() == ButtonType.OK) {
                if (BazaVatrogasniAparati.obrisiVAPregled((VatrogasniAparatPregled)this.tablicaEvidencijaPregleda.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuVAPregledi();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no brisanje ", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no brisanje", 2, "Error graphic");
                }
            }
        });
        this.btnIspisEK24PStroja.setOnAction(e -> {
            String sql = "SELECT \ntvrtka.id as idtvrtka,\n  tvrtka.naziv_tvrtke, \n  tvrtka.oib, \n  tvrtka.adresa, \n  tvrtka.mjesto, \n  tvrtka.pbr, \n  nazivstroja.naziv, \n  nazivstroja.oznaka, \n  poslovnejedinice.nazivposlovnice, \n  odjeli.nazivodjela, \n  vatrogasniaparati.id, \n  vatrogasniaparati.sifraaparata, \n  vatrogasniaparati.mjestoadresa, \n  vatrogasniaparati.oznakalokacije, \n  vatrogasniaparati.proizvodjac, \n  vatrogasniaparati.model, \n  vatrogasniaparati.tvornickibroj, \n  vatrogasniaparati.inventurnibroj, \n  vatrogasniaparati.godinaproizvodnje, \n  vatrogasniaparati.datumstavljanjauuporabu, \n  vatrogasniaparati.aparatuvozilu, \n  vatrogasniaparati.registracijavozila, \n  vatrogasniaparati.servisnanaljepnica, \n  vatrogasniaparati.datumservisnenaljepnice, \n  vatrogasniaparati.rashodovan, \n  vatrogasniaparati.napomena, \n  vrstavatrogasnihaparata.naziv AS vrstavatrogasnogaparata\nFROM \n  public.vatrogasniaparati, \n  public.tvrtka, \n  public.nazivstroja, \n  public.poslovnejedinice, \n  public.odjeli, \n  public.vrstavatrogasnihaparata\nWHERE \n  vatrogasniaparati.idstroja = nazivstroja.id AND\n  vatrogasniaparati.poslovnajedinica = poslovnejedinice.id AND\n  vatrogasniaparati.odjel = odjeli.id AND\n  tvrtka.id = vatrogasniaparati.idtvrtka AND\n  vrstavatrogasnihaparata.id = vatrogasniaparati.vrstaaparata   AND vatrogasniaparati.idtvrtka =tvrtka.id   and vatrogasniaparati.id ='" + this.va.getId() + "'";
            IspisReporta.ispisButtonSaSubreportom(sql, this.btnIspisEK24PStroja, "EK-VA.jrxml");
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void urediTblicuEvidencijaPregleda() {
        this.tablicaEvidencijaPregleda.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE && UnosVatrogasnogAparataController.this.tablicaEvidencijaPregleda.getEditingCell() == null) {
                    UnosVatrogasnogAparataController.this.tablicaEvidencijaPregleda.getSelectionModel().clearSelection();
                    e.consume();
                }
            }
        });
        this.kolRedBrPregledStroja.setCellValueFactory(cellData -> ((VatrogasniAparatPregled)cellData.getValue()).redBrojProperty());
        this.kolRedBrPregledStroja.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(33.333333333333336));
        this.kolRedBrPregledStroja.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory = param -> new DateCell();
        this.kolDatumObavljenogPregleda.setCellValueFactory(cellData -> ((VatrogasniAparatPregled)cellData.getValue()).datumObavljenogPregledaProperty());
        this.kolDatumObavljenogPregleda.setCellFactory(dateCellFactory);
        this.kolDatumObavljenogPregleda.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(16.666666666666668));
        this.kolDatumObavljenogPregleda.setStyle("-fx-alignment: CENTER;");
        this.kolDatumObavljenogPregleda.setOnEditCommit(t -> {
            ((VatrogasniAparatPregled)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDatumObavljenogPregleda((LocalDate)t.getNewValue());
            BazaVatrogasniAparati.unesiPromjenuVAPregled((VatrogasniAparatPregled)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        ObservableList listaVAPregled = FXCollections.observableArrayList();
        ResultSet rs = BazaVatrogasniAparati.dajVAPreglede(GlavniPanelController.getOdabranaTvrtka());
        VatrogasniAparatPregled op = null;
        try {
            while (rs.next()) {
                op = new VatrogasniAparatPregled();
                op.setId(rs.getInt("id"));
                op.setVrstaPregleda(rs.getString("naziv"));
                listaVAPregled.add((Object)op);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Callback comboCellFactoryOznaka = param -> new ComboBoxCellVAPregled((ObservableList<VatrogasniAparatPregled>)listaVAPregled, "naziv");
        this.kolVrstaPregleda.setCellValueFactory(cellData -> ((VatrogasniAparatPregled)cellData.getValue()).vrstaPregledaProperty());
        this.kolVrstaPregleda.setCellFactory(comboCellFactoryOznaka);
        this.kolVrstaPregleda.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(10.0));
        this.kolVrstaPregleda.setStyle("-fx-alignment: CENTER;");
        this.kolVrstaPregleda.setOnEditCommit(t -> ((VatrogasniAparatPregled)t.getTableView().getItems().get(t.getTablePosition().getRow())).setVrstaPregleda((String)t.getNewValue()));
        this.kolOrganizacija.setCellValueFactory(cellData -> ((VatrogasniAparatPregled)cellData.getValue()).nazivOrganizacijeIspitivanjaProperty());
        this.kolOrganizacija.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolOrganizacija.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(5.0));
        this.kolOrganizacija.setStyle("-fx-alignment: CENTER;");
        this.kolOrganizacija.setOnEditCommit(t -> {
            ((VatrogasniAparatPregled)t.getTableView().getItems().get(t.getTablePosition().getRow())).setNazivOrganizacijeIspitivanja((String)t.getNewValue());
            BazaVatrogasniAparati.unesiPromjenuVAPregled((VatrogasniAparatPregled)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolBrojIsprave.setCellValueFactory(cellData -> ((VatrogasniAparatPregled)cellData.getValue()).brojIspraveProperty());
        this.kolBrojIsprave.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolBrojIsprave.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(20.0));
        this.kolBrojIsprave.setStyle("-fx-alignment: CENTER;");
        this.kolBrojIsprave.setOnEditCommit(t -> {
            ((VatrogasniAparatPregled)t.getTableView().getItems().get(t.getTablePosition().getRow())).setBrojIsprave((String)t.getNewValue());
            BazaVatrogasniAparati.unesiPromjenuVAPregled((VatrogasniAparatPregled)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolIzvrseniPopravci.setCellValueFactory(cellData -> ((VatrogasniAparatPregled)cellData.getValue()).izvrseniPopravciProperty());
        this.kolIzvrseniPopravci.setCellFactory(TextAreaTableCell.forTableColumn());
        this.kolIzvrseniPopravci.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(10.0));
        this.kolIzvrseniPopravci.setStyle("-fx-alignment: CENTER;");
        this.kolIzvrseniPopravci.setOnEditCommit(t -> {
            ((VatrogasniAparatPregled)t.getTableView().getItems().get(t.getTablePosition().getRow())).setIzvrseniPopravci((String)t.getNewValue());
            BazaVatrogasniAparati.unesiPromjenuVAPregled((VatrogasniAparatPregled)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolBrojServisneNaljepnice.setCellValueFactory(cellData -> ((VatrogasniAparatPregled)cellData.getValue()).brojServisneNaljepniceProperty());
        this.kolBrojServisneNaljepnice.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolBrojServisneNaljepnice.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(20.0));
        this.kolBrojServisneNaljepnice.setStyle("-fx-alignment: CENTER;");
        this.kolBrojServisneNaljepnice.setOnEditCommit(t -> {
            ((VatrogasniAparatPregled)t.getTableView().getItems().get(t.getTablePosition().getRow())).setBrojServisneNaljepnice((String)t.getNewValue());
            BazaVatrogasniAparati.unesiPromjenuVAPregled((VatrogasniAparatPregled)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolDatumServisneNaljepnica.setCellValueFactory(cellData -> ((VatrogasniAparatPregled)cellData.getValue()).datumServisneNaljepniceProperty());
        this.kolDatumServisneNaljepnica.setCellFactory(dateCellFactory);
        this.kolDatumServisneNaljepnica.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(20.0));
        this.kolDatumServisneNaljepnica.setStyle("-fx-alignment: CENTER;");
        this.kolDatumServisneNaljepnica.setOnEditCommit(t -> {
            ((VatrogasniAparatPregled)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDatumServisneNaljepnice((LocalDate)t.getNewValue());
            BazaVatrogasniAparati.unesiPromjenuVAPregled((VatrogasniAparatPregled)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        ObservableList listaDaNe = FXCollections.observableArrayList((Object[])new String[]{"Da", "Ne"});
        this.kolIspravno.setCellValueFactory(cellData -> ((VatrogasniAparatPregled)cellData.getValue()).ispunjavaUvjeteProperty());
        this.kolIspravno.setCellFactory(ComboBoxTableCell.forTableColumn((ObservableList)listaDaNe));
        this.kolIspravno.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(20.0));
        this.kolIspravno.setStyle("-fx-alignment: CENTER;");
        this.kolIspravno.setOnEditCommit(t -> {
            ((VatrogasniAparatPregled)t.getTableView().getItems().get(t.getTablePosition().getRow())).setIspunjavaUvjete((String)t.getNewValue());
            BazaVatrogasniAparati.unesiPromjenuVAPregled((VatrogasniAparatPregled)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolDatumPonovogIspitivanja.setCellValueFactory(cellData -> ((VatrogasniAparatPregled)cellData.getValue()).datumPonovogIspitivanjaProperty());
        this.kolDatumPonovogIspitivanja.setCellFactory(dateCellFactory);
        this.kolDatumPonovogIspitivanja.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(20.0));
        this.kolDatumPonovogIspitivanja.setStyle("-fx-alignment: CENTER;");
        this.kolDatumPonovogIspitivanja.setOnEditCommit(t -> {
            ((VatrogasniAparatPregled)t.getTableView().getItems().get(t.getTablePosition().getRow())).setDatumPonovogIspitivanja((LocalDate)t.getNewValue());
            BazaVatrogasniAparati.unesiPromjenuVAPregled((VatrogasniAparatPregled)t.getTableView().getItems().get(t.getTablePosition().getRow()));
            ServiceRestart.restartService(ServiceRestart.RService.vatrogasni_aparat);
        });
        Callback cellDokument = param -> new ComboBoxCellDokument(this.listaDokumenti);
        this.kolDokument.setCellValueFactory(cellData -> ((VatrogasniAparatPregled)cellData.getValue()).nazivDokumentaProperty());
        this.kolDokument.setCellFactory(cellDokument);
        this.kolDokument.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(6.666666666666667));
        this.kolDokument.setStyle("-fx-alignment: CENTER;");
        this.kolDokument.setOnEditCommit(t -> {
            ((VatrogasniAparatPregled)t.getTableView().getItems().get(t.getTablePosition().getRow())).setNazivDokumenta((String)t.getNewValue());
            BazaVatrogasniAparati.unesiPromjenuVAPregled((VatrogasniAparatPregled)t.getTableView().getItems().get(t.getTablePosition().getRow()));
        });
        this.kolPodatkeUpisao.setCellValueFactory(cellData -> ((VatrogasniAparatPregled)cellData.getValue()).podatkeUpisaoProperty());
        this.kolPodatkeUpisao.prefWidthProperty().bind((ObservableValue)this.tablicaEvidencijaPregleda.widthProperty().divide(10.0));
        this.kolPodatkeUpisao.setStyle("-fx-alignment: CENTER;");
    }

    private void popuniTablicuDokumenti() {
        this.tablicaDokumenti.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTaskDokumenti();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaDokumenti.clear();
        this.tablicaDokumenti.getItems().clear();
    }

    private Task createTaskDokumenti() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    UnosVatrogasnogAparataController.this.popuniTablicuDokumentiizBaze();
                }
                finally {
                    Platform.runLater(() -> UnosVatrogasnogAparataController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    private void popuniTablicuDokumentiizBaze() {
        int br = 1;
        ResultSet rs = BazaDokumenti.getDokumentiVatrogasniAparat(GlavniPanelController.getOdabranaTvrtka().getId(), this.va.getId());
        try {
            while (rs.next()) {
                ScanDokument cd = new ScanDokument();
                cd.setId(rs.getInt("id"));
                cd.setRedBroj(String.valueOf(br));
                cd.setOpisDokumenta(rs.getString("naziv"));
                this.listaDokumenti.add((Object)cd);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.tablicaDokumenti.getItems().addAll(this.listaDokumenti);
    }

    private void urediKoloneUTabliciDokumenti() {
        this.tablicaDokumenti.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    UnosVatrogasnogAparataController.this.tablicaDokumenti.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory((Callback)new PropertyValueFactory("redBroj"));
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaDokumenti.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolNazivDokumenta.setCellValueFactory(cell -> ((ScanDokument)cell.getValue()).opisDokumentaProperty());
        this.kolNazivDokumenta.prefWidthProperty().bind((ObservableValue)this.tablicaDokumenti.widthProperty().divide(1.1235955056179776));
        this.kolNazivDokumenta.setStyle("-fx-alignment: CENTER;");
        Callback cellScanDokument = param -> new DokumentHiperlinkCell(this.listaDokumenti);
        this.kolNazivDokumenta.setCellFactory(cellScanDokument);
    }

    private void popuniCBoxProizvodjac() {
        ResultSet rs = BazaVatrogasniAparati.dajProizvodjace(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                this.cboxProizvodjac.getItems().add((Object)rs.getString("nazivproizvodjaca"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniCBoxModel(String proizvodjac) {
        this.cboxModel.getItems().clear();
        ResultSet rs = BazaVatrogasniAparati.dajProizvodjace(GlavniPanelController.getOdabranaTvrtka(), proizvodjac);
        try {
            while (rs.next()) {
                this.cboxModel.getItems().add((Object)rs.getString("tip"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniOdjelePoslovneJedinice(int idPoslovneJedinice) {
        this.cBoxOdjel.getItems().clear();
        ResultSet rs = BazaOdjeli.dajOdjel(GlavniPanelController.getOdabranaTvrtka(), idPoslovneJedinice);
        try {
            while (rs.next()) {
                this.cBoxOdjel.getItems().add((Object)rs.getString("nazivodjela"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniCBoxPoslovnice() {
        final ObservableMap map = FXCollections.observableHashMap();
        ResultSet rs = BazaDjelatnik.dajPoslovnujednicu(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                PoslovneJedinice pj = new PoslovneJedinice();
                pj.setId(rs.getInt("id"));
                pj.setNazivPoslovnice(rs.getString("nazivposlovnice"));
                pj.setAdresaPoslovnice(rs.getString("adresa"));
                pj.setMjesto(rs.getString("mjesto"));
                map.put((Object)rs.getString("nazivposlovnice"), (Object)pj);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.cBoxPoslovnaJedinica.getItems().addAll(map.values());
        this.cBoxPoslovnaJedinica.setConverter((StringConverter)new StringConverter<PoslovneJedinice>(){

            public String toString(PoslovneJedinice t) {
                if (t != null) {
                    String str = t.getNazivPoslovnice();
                    map.put((Object)str, (Object)t);
                    return str;
                }
                return "";
            }

            public PoslovneJedinice fromString(String string) {
                if (!map.containsKey((Object)string)) {
                    UnosVatrogasnogAparataController.this.cBoxPoslovnaJedinica.setValue(null);
                    UnosVatrogasnogAparataController.this.cBoxPoslovnaJedinica.getEditor().clear();
                    return null;
                }
                return (PoslovneJedinice)map.get((Object)string);
            }
        });
        this.cBoxPoslovnaJedinica.setCellFactory((Callback)new Callback<ListView<PoslovneJedinice>, ListCell<PoslovneJedinice>>(){

            public ListCell<PoslovneJedinice> call(ListView<PoslovneJedinice> p) {
                ListCell<PoslovneJedinice> cell = new ListCell<PoslovneJedinice>(){

                    protected void updateItem(PoslovneJedinice item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setText("");
                        } else {
                            this.setText(item.getNazivPoslovnice());
                            this.setAlignment(Pos.CENTER);
                            this.setPadding(new Insets(3.0, 3.0, 3.0, 0.0));
                        }
                    }
                };
                return cell;
            }
        });
    }

    private void popuniCBoxVrsteAparata() {
        ResultSet rs = BazaVatrogasniAparati.dajVrsteAparata(GlavniPanelController.getOdabranaTvrtka());
        try {
            while (rs.next()) {
                this.cBoxVrstaAparata.getItems().add((Object)rs.getString("naziv"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void urediTablicuZaduzeneOsobe() {
        this.tablicaZaduzeneOsobe.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    UnosVatrogasnogAparataController.this.tablicaZaduzeneOsobe.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBrZO.setCellValueFactory(cellData -> ((VAZaduzeneOsobe)cellData.getValue()).redBrojProperty());
        this.kolRedBrZO.prefWidthProperty().bind((ObservableValue)this.tablicaZaduzeneOsobe.widthProperty().divide(10.0));
        this.kolRedBrZO.setStyle("-fx-alignment: CENTER;");
        ObservableList listaDjelatnika = FXCollections.observableArrayList();
        ObservableList listaSifraOsobe = FXCollections.observableArrayList();
        ObservableList listaNazivOsobe = FXCollections.observableArrayList();
        ResultSet rs = BazaDjelatnik.dajDjelatnike(GlavniPanelController.getOdabranaTvrtka(), BazaDjelatnik.Opcije.zaposlene_djelatnike);
        try {
            while (rs.next()) {
                Djelatnik d = new Djelatnik();
                d.setId(rs.getInt("id"));
                d.setSifraDjelatnika(rs.getString("sifradjelatnika"));
                d.setIme(rs.getString("ime"));
                d.setPrezime(rs.getString("prezime"));
                listaDjelatnika.add((Object)d);
                listaSifraOsobe.add((Object)rs.getString("sifradjelatnika"));
                listaNazivOsobe.add((Object)(rs.getString("ime") + " " + rs.getString("prezime")));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Callback comboCellFactoryPrezime = param -> new ComboBoxCellDjelatniciVA((ObservableList<Djelatnik>)listaDjelatnika, "prezime");
        Callback comboCellFactorySifra = param -> new ComboBoxCellDjelatniciVA((ObservableList<Djelatnik>)listaDjelatnika, "sifra");
        this.kolSifra.setCellValueFactory(cellData -> ((VAZaduzeneOsobe)cellData.getValue()).sifraOsobeProperty());
        this.kolSifra.prefWidthProperty().bind((ObservableValue)this.tablicaZaduzeneOsobe.widthProperty().divide(5.0));
        this.kolSifra.setStyle("-fx-alignment: CENTER;");
        this.kolSifra.setCellFactory(comboCellFactorySifra);
        this.kolSifra.setOnEditCommit(t -> ((VAZaduzeneOsobe)t.getTableView().getItems().get(t.getTablePosition().getRow())).setSifraOsobe((String)t.getNewValue()));
        this.kolNaziv.setCellValueFactory(cellData -> ((VAZaduzeneOsobe)cellData.getValue()).nazivOsobeProperty());
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaZaduzeneOsobe.widthProperty().divide(1.4285714285714286));
        this.kolNaziv.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellFactory(comboCellFactoryPrezime);
        this.kolNaziv.setOnEditCommit(t -> ((VAZaduzeneOsobe)t.getTableView().getItems().get(t.getTablePosition().getRow())).setNazivOsobe((String)t.getNewValue()));
    }

    private void spremiAparat() {
        boolean bVrstaAparata;
        boolean bOdjel;
        boolean bPoslovnica;
        boolean bNazivStroja;
        boolean bSifraStroja = FormValidation.textFieldValidationonlyText(this.txtSifraAparata);
        if (bSifraStroja & (bNazivStroja = FormValidation.textFieldValidationonlyText(this.txtNazivAparata)) & (bPoslovnica = FormValidation.comboBoxValidationText(this.cBoxPoslovnaJedinica)) & (bOdjel = FormValidation.comboBoxValidationText(this.cBoxOdjel)) & (bVrstaAparata = FormValidation.comboBoxValidationText(this.cBoxVrstaAparata))) {
            if (this.izmjenaAparata.booleanValue()) {
                if (BazaVatrogasniAparati.izmjenaAparata(GlavniPanelController.getOdabranaTvrtka(), this.dajAparat(), this.va.getId())) {
                    if (!GlavniPanelController.getInstance().getTabByIdifExist("Popis vatrogasnih aparata")) {
                        PopisVatrogasnihAparataController.getInstance().popuniTablicuPopisAparata();
                    }
                    GlavniPanelController.getInstance().zatvoriTab("Unos vatrogasnog aparata");
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena aparata", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena aparata", 2, "Error graphic");
                }
            } else if (BazaVatrogasniAparati.unesiNoviAparat(GlavniPanelController.getOdabranaTvrtka(), this.dajAparat())) {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen aparata", 1, "Information graphic");
                PopisVatrogasnihAparataController.getInstance().popuniTablicuPopisAparata();
                GlavniPanelController.getInstance().zatvoriTab("Unos vatrogasnog aparata");
                this.izmjenaAparata = false;
            } else {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesen aparata", 2, "Error graphic");
            }
        } else {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate popuniti sva oznacena polja");
            alert.showAndWait();
        }
    }

    private VatrogasniAparat dajAparat() {
        VatrogasniAparat va = new VatrogasniAparat();
        va.setSifraAparata(this.txtSifraAparata.getText());
        va.setNazivAparata(this.txtNazivAparata.getText());
        va.setPoslovnajedinica(((PoslovneJedinice)this.cBoxPoslovnaJedinica.getValue()).getNazivPoslovnice());
        va.setOdjel((String)this.cBoxOdjel.getValue());
        va.setMjestoIAdresa(this.txtMjestoAdresa.getText());
        va.setPoblizaLokacija(this.txtAreaOznakaLokacije.getText());
        va.setProizvodjac((String)this.cboxProizvodjac.getValue());
        va.setModel((String)this.cboxModel.getValue());
        va.setInventurnibroj(this.txtInventurniBroj.getText());
        va.setTvornickibroj(this.txtTvornickiBroj.getText());
        va.setGodinaProizvodnje(this.txtGodinaProizvodnje.getText());
        va.setDatumStavljanjauPogon((LocalDate)this.dateStavljanjeUPogon.getValue());
        va.setVrstaAparata((String)this.cBoxVrstaAparata.getValue());
        va.setAparatUVozilu(this.chboxAparatUVozilu.isSelected());
        va.setRegistracijaVozila(this.txtRegistracijaVozila.getText());
        va.setServisnaNaljepnica(this.txtServisnaNaljepnica.getText());
        va.setDatumServisneNaljepnice((LocalDate)this.dateServisnaNaljepnica.getValue());
        va.setNapomena(this.txtAreaNapomena.getText());
        va.setRashodovan(this.chBoxRazduzen.isSelected());
        return va;
    }

    public void postaviPoslovnicu(String naziv) {
        this.cBoxPoslovnaJedinica.setValue(this.cBoxPoslovnaJedinica.getConverter().fromString(naziv));
    }

    public void izmjenaAparata(VatrogasniAparat va) {
        this.izmjenaAparata = true;
        this.bp.set(true);
        this.va = va;
        this.txtSifraAparata.setText(va.getSifraAparata());
        this.txtNazivAparata.setText(va.getNazivAparata());
        this.postaviPoslovnicu(va.getPoslovnajedinica());
        this.cBoxOdjel.setValue((Object)va.getOdjel());
        this.txtMjestoAdresa.setText(va.getMjestoIAdresa());
        this.txtAreaOznakaLokacije.setText(va.getPoblizaLokacija());
        this.cboxProizvodjac.setValue((Object)va.getProizvodjac());
        this.cboxModel.setValue((Object)va.getModel());
        this.txtInventurniBroj.setText(va.getInventurnibroj());
        this.txtTvornickiBroj.setText(va.getTvornickibroj());
        this.txtGodinaProizvodnje.setText(va.getGodinaProizvodnje());
        this.dateStavljanjeUPogon.setValue((Object)va.getDatumStavljanjauPogon());
        this.chboxAparatUVozilu.setSelected(va.isAparatUVozilu());
        this.txtRegistracijaVozila.setText(va.getRegistracijaVozila());
        this.txtServisnaNaljepnica.setText(va.getServisnaNaljepnica());
        this.dateServisnaNaljepnica.setValue((Object)va.getDatumServisneNaljepnice());
        this.cBoxVrstaAparata.setValue((Object)va.getVrstaAparata());
        this.txtAreaNapomena.setText(va.getNapomena());
        this.chBoxRazduzen.setSelected(va.isRashodovan());
    }

    private void popuniTablicuZaduzeneOsobe() {
        this.tablicaZaduzeneOsobe.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTaskZO();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaStrojZaduzeneOsobe.clear();
        this.tablicaZaduzeneOsobe.getItems().clear();
    }

    private Task createTaskZO() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    UnosVatrogasnogAparataController.this.popuniTablicuZaduzeneOsobePodaci();
                }
                finally {
                    Platform.runLater(() -> UnosVatrogasnogAparataController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuZaduzeneOsobePodaci() {
        ResultSet rs = BazaVatrogasniAparati.dajVAZaduzeneOsobe(GlavniPanelController.getOdabranaTvrtka().getId(), this.va.getId());
        VAZaduzeneOsobe zo = null;
        int br = 1;
        try {
            while (rs.next()) {
                zo = new VAZaduzeneOsobe();
                zo.setId(rs.getInt("id"));
                zo.setRedBroj(String.valueOf(br));
                zo.setNazivOsobe(rs.getString("nazivosobe"));
                zo.setSifraOsobe(rs.getString("sifraosobe"));
                this.listaStrojZaduzeneOsobe.add((Object)zo);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaZaduzeneOsobe.setItems(this.listaStrojZaduzeneOsobe);
    }

    public void popuniTablicuVAPregledi() {
        this.tablicaEvidencijaPregleda.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTaskVAPregled();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaVAPregled.clear();
        this.tablicaEvidencijaPregleda.getItems().clear();
    }

    private Task createTaskVAPregled() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    UnosVatrogasnogAparataController.this.popuniTablicuVAPregled();
                }
                finally {
                    Platform.runLater(() -> UnosVatrogasnogAparataController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuVAPregled() {
        ResultSet rs = BazaVatrogasniAparati.dajVAPreglede(GlavniPanelController.getOdabranaTvrtka().getId(), this.va.getId());
        VatrogasniAparatPregled vap = null;
        int br = 1;
        try {
            while (rs.next()) {
                vap = new VatrogasniAparatPregled();
                vap.setId(rs.getInt("id"));
                vap.setRedBroj(String.valueOf(br));
                vap.setDatumObavljenogPregleda(DateUtil.getLocalDate(rs.getDate("datumpregleda")));
                vap.setVrstaPregleda(rs.getString("nazivpregledava"));
                vap.setNazivOrganizacijeIspitivanja(rs.getString("nazivorganizacije"));
                vap.setBrojIsprave(rs.getString("brojisprave"));
                vap.setIzvrseniPopravci(rs.getString("popravci"));
                vap.setBrojServisneNaljepnice(rs.getString("brojservisnenaljepnice"));
                vap.setDatumServisneNaljepnice(DateUtil.getLocalDate(rs.getDate("datumservisnenaljepnice")));
                vap.setDatumPonovogIspitivanja(DateUtil.getLocalDate(rs.getDate("datumponovogpregleda")));
                vap.setIspunjavaUvjete(rs.getString("ispravan"));
                vap.setNazivDokumenta(rs.getString("dokument"));
                vap.setPodatkeUpisao(rs.getString("podatkeupisao"));
                this.listaVAPregled.add((Object)vap);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosVatrogasnogAparataController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaEvidencijaPregleda.setItems(this.listaVAPregled);
    }
}

