/*
 * Decompiled with CFR 0.152.
 */
package vatrogasniaparatiredovnipregled;

import TamplatePaneli.Template;
import Utill.DateCell;
import Utill.DateUtil;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import ispisJasper.IspisReporta;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import vatrogasniaparatiredovnipregled.BazaRedovniPregled;
import vatrogasniaparatiredovnipregled.RedovniPregled;
import vatrogasniaparatiredovnipregled.UnosRedovnogPregledaController;
import zastitanaradu.GlavniPanelController;

public class PopisRedovnogPregledaController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private Button btnIspis;
    @FXML
    private TableView<RedovniPregled> tablicaPopisPregledaAparata;
    @FXML
    private TableColumn kolPretraga;
    @FXML
    private TableColumn<RedovniPregled, String> kolRedBr;
    @FXML
    private TableColumn<RedovniPregled, LocalDate> kolDatumPregleda;
    @FXML
    private TableColumn<RedovniPregled, String> kolBrojUpisnika;
    private static PopisRedovnogPregledaController instance;
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;
    private final ObservableList<RedovniPregled> listaVA = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();

    public static PopisRedovnogPregledaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFIlter();
        this.urediTablicuPopisUpisnika();
        this.popuniTablicuPopisUpisnika();
        this.urediFilter(this.tablicaPopisPregledaAparata);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos redovnog pregleda vatrogasnih aparata")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos redovnog pregleda vatrogasnih aparata");
                GlavniPanelController.getInstance().nadodajPanel("Unos redovnog pregleda vatrogasnih aparata", "/vatrogasniaparatiredovnipregled/UnosRedovnogPregleda.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos redovnog pregleda vatrogasnih aparata", "/vatrogasniaparatiredovnipregled/UnosRedovnogPregleda.fxml");
            }
        });
        this.btnPromjena.setOnAction(event -> {
            RedovniPregled rp;
            int selectdIndex = this.tablicaPopisPregledaAparata.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (rp = (RedovniPregled)this.tablicaPopisPregledaAparata.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos redovnog pregleda vatrogasnih aparata")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos redovnog pregleda vatrogasnih aparata");
                    GlavniPanelController.getInstance().nadodajPanel("Unos redovnog pregleda vatrogasnih aparata", "/vatrogasniaparatiredovnipregled/UnosRedovnogPregleda.fxml");
                    UnosRedovnogPregledaController.getInstance().izmjenaUpisnika(rp);
                    this.tablicaPopisPregledaAparata.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos redovnog pregleda vatrogasnih aparata", "/vatrogasniaparatiredovnipregled/UnosRedovnogPregleda.fxml");
                    UnosRedovnogPregledaController.getInstance().izmjenaUpisnika(rp);
                    this.tablicaPopisPregledaAparata.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisPregledaAparata.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati upisnik")).showAndWait()).get() == ButtonType.OK) {
                boolean uspjelo = BazaRedovniPregled.obrisiUpisnik((RedovniPregled)this.tablicaPopisPregledaAparata.getSelectionModel().getSelectedItem(), GlavniPanelController.getOdabranaTvrtka());
                if (uspjelo) {
                    this.popuniTablicuPopisUpisnika();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisan upisnik", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan upisnik", 2, "Error graphic");
                }
            }
        });
        this.btnIspis.setOnAction(e -> {
            int selectdIndex = this.tablicaPopisPregledaAparata.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1) {
                this.ispis((ObservableList<RedovniPregled>)this.tablicaPopisPregledaAparata.getSelectionModel().getSelectedItems());
            }
        });
    }

    private void kreirajToolBarFIlter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Broj upisnika"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Broj upisnika");
        this.cbFilter.setPrefWidth(200.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaVA, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Broj upisnika") && pregled.getBrojUpisnika() != null && pregled.getBrojUpisnika().toLowerCase().startsWith(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediTablicuPopisUpisnika() {
        this.tablicaPopisPregledaAparata.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tablicaPopisPregledaAparata.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisRedovnogPregledaController.this.tablicaPopisPregledaAparata.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cell -> ((RedovniPregled)cell.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisPregledaAparata.widthProperty().divide(5.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory = param -> new DateCell();
        this.kolDatumPregleda.setCellValueFactory(cellData -> ((RedovniPregled)cellData.getValue()).datumKreiranjaProperty());
        this.kolDatumPregleda.setCellFactory(dateCellFactory);
        this.kolDatumPregleda.prefWidthProperty().bind((ObservableValue)this.tablicaPopisPregledaAparata.widthProperty().divide(5.0));
        this.kolDatumPregleda.setStyle("-fx-alignment: CENTER;");
        this.kolDatumPregleda.setEditable(false);
        this.kolBrojUpisnika.setCellValueFactory(cell -> ((RedovniPregled)cell.getValue()).brojUpisnikaProperty());
        this.kolBrojUpisnika.prefWidthProperty().bind((ObservableValue)this.tablicaPopisPregledaAparata.widthProperty().divide(5.0));
        this.kolBrojUpisnika.setStyle("-fx-alignment: CENTER;");
        TableColumn kolPregledDjelatnika = new TableColumn("Pregled");
        kolPregledDjelatnika.setSortable(false);
        kolPregledDjelatnika.prefWidthProperty().bind((ObservableValue)this.tablicaPopisPregledaAparata.widthProperty().divide(5.0));
        kolPregledDjelatnika.setStyle("-fx-alignment: CENTER;");
        kolPregledDjelatnika.setCellFactory((Callback)new Callback<TableColumn<RedovniPregled, Boolean>, TableCell<RedovniPregled, Boolean>>(){

            public TableCell<RedovniPregled, Boolean> call(TableColumn<RedovniPregled, Boolean> param) {
                return new ButtonCell();
            }
        });
        this.kolPretraga.setGraphic((Node)this.tbFilter);
        this.kolPretraga.getColumns().add((Object)kolPregledDjelatnika);
    }

    public void popuniTablicuPopisUpisnika() {
        this.tablicaPopisPregledaAparata.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaVA.clear();
        this.tablicaPopisPregledaAparata.getItems().clear();
    }

    private Task createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisRedovnogPregledaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    ResultSet rs = BazaRedovniPregled.dajUpisnike(GlavniPanelController.getOdabranaTvrtka());
                    PopisRedovnogPregledaController.this.popuniTablicuUpisnika(rs);
                }
                finally {
                    Platform.runLater(() -> PopisRedovnogPregledaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuUpisnika(ResultSet rs) {
        RedovniPregled rp = null;
        int br = 1;
        try {
            while (rs.next()) {
                rp = new RedovniPregled();
                rp.setId(rs.getInt("id"));
                rp.setRedBroj(String.valueOf(br));
                rp.setBrojUpisnika(rs.getString("brojupisnika"));
                rp.setOpisNedostataka(rs.getString("nedostaci"));
                rp.setNedostatkeOtklonio(rs.getString("nedostatkeotklonio"));
                rp.setNedostaciDatum(DateUtil.getLocalDate(rs.getDate("nedostacidatum")));
                rp.setNedostaciSat(rs.getString("nedostacisat"));
                rp.setNedostaciOdgovornaOsoba(rs.getString("nedostaciodgovornaosoba"));
                rp.setNazivPravneOsobe(rs.getString("pravnaosoba"));
                rp.setMjestoPregleda(rs.getString("mjesto"));
                rp.setVoditelj(rs.getString("voditelj"));
                rp.setDatumKreiranja(DateUtil.getLocalDate(rs.getDate("datumkreiranjaupisnika")));
                this.listaVA.add((Object)rp);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisRedovnogPregledaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisRedovnogPregledaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisPregledaAparata.getItems().addAll(this.listaVA);
    }

    private void ispis(ObservableList<RedovniPregled> lista) {
        String idArray = "";
        for (int i = 0; i < lista.size(); ++i) {
            idArray = i == 0 ? idArray + String.valueOf(((RedovniPregled)lista.get(i)).getId()) : idArray + "," + String.valueOf(((RedovniPregled)lista.get(i)).getId());
        }
        String sql = "SELECT \nredovnipregledvatrogasnogaparata.*,\n  tvrtka.naziv_tvrtke, \n  tvrtka.adresa, \n  tvrtka.pbr, \n  tvrtka.mjesto as tvrtkamjesto\n\nFROM \n  public.redovnipregledvatrogasnogaparata, \n  public.tvrtka\nWHERE \n  tvrtka.id = redovnipregledvatrogasnogaparata.idtvrtka    and redovnipregledvatrogasnogaparata.id  IN (select(unnest(ARRAY [" + idArray + "])))";
        IspisReporta.ispisButtonSaSubreportom(sql, this.btnIspis, "UpisnikRedovnogPregledaVA.jrxml");
    }

    private class ButtonCell
    extends TableCell<RedovniPregled, Boolean> {
        Button cellButton = new Button("Pregled");

        ButtonCell() {
            this.cellButton.setId("btnPregled");
            this.cellButton.setContentDisplay(ContentDisplay.LEFT);
            this.cellButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    RedovniPregled va;
                    int selectdIndex = PopisRedovnogPregledaController.this.tablicaPopisPregledaAparata.getSelectionModel().getSelectedIndex();
                    if (selectdIndex != -1 && (va = (RedovniPregled)PopisRedovnogPregledaController.this.tablicaPopisPregledaAparata.getSelectionModel().getSelectedItem()) != null) {
                        Template.getTamplate().showTemplate("vatrogasniaparatiredovnipregled/UnosRedovnogPregleda.fxml", "anchorPanel", "/ro2/ro2.css");
                        UnosRedovnogPregledaController.getInstance().izmjenaUpisnika(va);
                        PopisRedovnogPregledaController.this.tablicaPopisPregledaAparata.getSelectionModel().clearSelection();
                    }
                }
            });
        }

        protected void updateItem(Boolean t, boolean empty) {
            super.updateItem((Object)t, empty);
            if (!empty) {
                this.setGraphic((Node)this.cellButton);
                this.cellButton.disableProperty().bind((ObservableValue)PopisRedovnogPregledaController.this.tablicaPopisPregledaAparata.getSelectionModel().selectedIndexProperty().isNotEqualTo(this.getTableRow().getIndex()));
            } else {
                this.setGraphic(null);
            }
        }
    }
}

