/*
 * Decompiled with CFR 0.152.
 */
package webview;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.HBox;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javafx.util.Callback;

public class BrowserHistory
extends HBox {
    public BrowserHistory(WebView webView) {
        this.setSpacing(4.0);
        this.setAlignment(Pos.CENTER_LEFT);
        this.setStyle("-fx-padding: 10;-fx-border-style: solid inside;-fx-border-width: 2;-fx-border-insets: 5;-fx-border-radius: 5;-fx-border-color: gray;");
        final WebHistory history = webView.getEngine().getHistory();
        Label label = new Label("Povjest pregledavanja:");
        label.setStyle("-fx-font-weight:bold");
        final Button backButton = new Button("Back");
        backButton.setDisable(true);
        final Button forwardButton = new Button("Forward");
        forwardButton.setDisable(true);
        backButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                history.go(-1);
            }
        });
        forwardButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                history.go(1);
            }
        });
        history.currentIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldvalue, Number newvalue) {
                int currentIndex = newvalue.intValue();
                if (currentIndex <= 0) {
                    backButton.setDisable(true);
                } else {
                    backButton.setDisable(false);
                }
                if (currentIndex >= history.getEntries().size()) {
                    forwardButton.setDisable(true);
                } else {
                    forwardButton.setDisable(false);
                }
            }
        });
        final ComboBox historyList = new ComboBox();
        historyList.setPrefWidth(150.0);
        historyList.setItems(history.getEntries());
        historyList.setCellFactory((Callback)new Callback<ListView<WebHistory.Entry>, ListCell<WebHistory.Entry>>(){

            public ListCell<WebHistory.Entry> call(ListView<WebHistory.Entry> list) {
                ListCell<WebHistory.Entry> cell = new ListCell<WebHistory.Entry>(){

                    public void updateItem(WebHistory.Entry item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            String pageTitle = item.getTitle();
                            this.setText(pageTitle);
                        }
                    }
                };
                return cell;
            }
        });
        historyList.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                int currentIndex = history.getCurrentIndex();
                WebHistory.Entry selectedEntry = (WebHistory.Entry)historyList.getValue();
                int selectedIndex = historyList.getItems().indexOf((Object)selectedEntry);
                int offset = selectedIndex - currentIndex;
                history.go(offset);
            }
        });
        this.getChildren().addAll((Object[])new Node[]{backButton, forwardButton, label, historyList});
    }
}

