/*
 * Decompiled with CFR 0.152.
 */
package webview;

import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.web.WebView;

public class WebMenu
extends MenuButton {
    public WebMenu(final WebView webView) {
        this.setText("Options");
        webView.addEventFilter(KeyEvent.KEY_RELEASED, e -> {
            if (e.getCode() == KeyCode.ADD || e.getCode() == KeyCode.EQUALS || e.getCode() == KeyCode.PLUS) {
                webView.setZoom(webView.getZoom() * 1.1);
            } else if (e.getCode() == KeyCode.SUBTRACT || e.getCode() == KeyCode.MINUS) {
                webView.setZoom(webView.getZoom() / 1.1);
            }
        });
        CheckMenuItem ctxMenu = new CheckMenuItem("Enable Context Menu");
        ctxMenu.setSelected(true);
        MenuItem normalFontMenu = new MenuItem("Normal");
        MenuItem biggerFontMenu = new MenuItem("10% Bigger");
        MenuItem smallerFontMenu = new MenuItem("10% Smaller");
        MenuItem normalZoomMenu = new MenuItem("Normal");
        MenuItem biggerZoomMenu = new MenuItem("10% Bigger");
        MenuItem smallerZoomMenu = new MenuItem("10% Smaller");
        RadioMenuItem grayMenu = new RadioMenuItem("GRAY");
        grayMenu.setSelected(true);
        RadioMenuItem lcdMenu = new RadioMenuItem("LCD");
        Menu scalingMenu = new Menu("Font Scale");
        scalingMenu.textProperty().bind((ObservableValue)new SimpleStringProperty("Font Scale ").concat((Object)webView.fontScaleProperty().multiply(100.0)).concat((Object)"%"));
        Menu smoothingMenu = new Menu("Font Smoothing");
        Menu zoomMenu = new Menu("Zoom");
        zoomMenu.textProperty().bind((ObservableValue)new SimpleStringProperty("Zoom ").concat((Object)webView.zoomProperty().multiply(100.0)).concat((Object)"%"));
        scalingMenu.getItems().addAll((Object[])new MenuItem[]{normalFontMenu, biggerFontMenu, smallerFontMenu});
        smoothingMenu.getItems().addAll((Object[])new MenuItem[]{grayMenu, lcdMenu});
        zoomMenu.getItems().addAll((Object[])new MenuItem[]{normalZoomMenu, biggerZoomMenu, smallerZoomMenu});
        new ToggleGroup().getToggles().addAll((Object[])new Toggle[]{lcdMenu, grayMenu});
        normalFontMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                webView.setFontScale(1.0);
            }
        });
        biggerFontMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                webView.setFontScale(webView.getFontScale() + 0.1);
            }
        });
        smallerFontMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                webView.setFontScale(webView.getFontScale() - 0.1);
            }
        });
        grayMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                webView.setFontSmoothingType(FontSmoothingType.GRAY);
            }
        });
        lcdMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                webView.setFontSmoothingType(FontSmoothingType.LCD);
            }
        });
        normalZoomMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                webView.setZoom(1.0);
            }
        });
        biggerZoomMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                webView.setZoom(webView.getZoom() + 0.1);
            }
        });
        smallerZoomMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                webView.setZoom(webView.getZoom() - 0.1);
            }
        });
        webView.contextMenuEnabledProperty().bind((ObservableValue)ctxMenu.selectedProperty());
        CheckMenuItem scriptMenu = new CheckMenuItem("Enable JavaScript");
        scriptMenu.setSelected(true);
        webView.getEngine().javaScriptEnabledProperty().bind((ObservableValue)scriptMenu.selectedProperty());
        this.getItems().addAll((Object[])new MenuItem[]{ctxMenu, scalingMenu, smoothingMenu, zoomMenu, new SeparatorMenuItem(), scriptMenu});
    }
}

