/*
 * Decompiled with CFR 0.152.
 */
package zakoni;

import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import zakoni.BazaZakon;
import zakoni.UnosZakonaController;
import zakoni.Zakon;
import zastitanaradu.GlavniPanelController;

public class PregledZakonaController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<Zakon> tablicaZakoni;
    @FXML
    private TableColumn<Zakon, String> kolPretraga;
    @FXML
    private TableColumn<Zakon, String> kolRedBr;
    @FXML
    private TableColumn<Zakon, String> kolNaziv;
    @FXML
    private TableColumn<Zakon, String> kolGodina;
    @FXML
    private TableColumn<Zakon, String> kolNN;
    @FXML
    private TableColumn<Zakon, String> kolPodrucije;
    @FXML
    private TableColumn<Zakon, Boolean> kolNaSnazi;
    private static PregledZakonaController instance;
    private final ObservableList<Zakon> listaZakona = FXCollections.observableArrayList();
    private ProgressIndicator progressIndicator = new ProgressIndicator();
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;

    public static PregledZakonaController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediKoloneUTabliciZakoni();
        this.popuniTablicuZakon();
        this.urediFilter(this.tablicaZakoni);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos zakona/pravilnika")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos zakona/pravilnika");
                GlavniPanelController.getInstance().nadodajPanel("Unos zakona/pravilnika", "/zakoni/UnosZakona.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos zakona/pravilnika", "/zakoni/UnosZakona.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            Zakon z;
            int selectdIndex = this.tablicaZakoni.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (z = (Zakon)this.tablicaZakoni.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos zakona/pravilnika")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos zakona/pravilnika");
                    GlavniPanelController.getInstance().nadodajPanel("Unos zakona/pravilnika", "/zakoni/UnosZakona.fxml");
                    UnosZakonaController.getInstance().izmjenaOdjela(z);
                    this.tablicaZakoni.getSelectionModel().clearSelection();
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos zakona/pravilnika", "/zakoni/UnosZakona.fxml");
                    UnosZakonaController.getInstance().izmjenaOdjela(z);
                    this.tablicaZakoni.getSelectionModel().clearSelection();
                }
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaZakoni.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati zakon")).showAndWait()).get() == ButtonType.OK) {
                if (BazaZakon.obrisiZakon((Zakon)this.tablicaZakoni.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuZakon();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisan zakon", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisan zakon", 2, "Error graphic");
                }
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Podru\u010dije", "Naziv", "NN broj", "Godina"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaZakona, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Podru\u010dije") ? pregled.getPodrucije() != null && pregled.getPodrucije().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv") ? pregled.getNaziv() != null && pregled.getNaziv().toLowerCase().startsWith(lowerCaseFilter) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("NN broj") ? pregled.getNN() != null && pregled.getNN().toLowerCase().startsWith(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Godina") && pregled.getGodina() != null && pregled.getGodina().toLowerCase().startsWith(lowerCaseFilter)));
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediKoloneUTabliciZakoni() {
        this.tablicaZakoni.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PregledZakonaController.this.tablicaZakoni.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory((Callback)new PropertyValueFactory("redBroj"));
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaZakoni.widthProperty().divide(10.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        this.kolNaziv.setCellValueFactory((Callback)new PropertyValueFactory("naziv"));
        this.kolNaziv.prefWidthProperty().bind((ObservableValue)this.tablicaZakoni.widthProperty().divide(2.5));
        this.kolNaziv.setStyle("-fx-alignment: CENTER;");
        this.kolGodina.setCellValueFactory((Callback)new PropertyValueFactory("godina"));
        this.kolGodina.prefWidthProperty().bind((ObservableValue)this.tablicaZakoni.widthProperty().divide(10.0));
        this.kolGodina.setStyle("-fx-alignment: CENTER;");
        this.kolNN.setCellValueFactory((Callback)new PropertyValueFactory("NN"));
        this.kolNN.prefWidthProperty().bind((ObservableValue)this.tablicaZakoni.widthProperty().divide(10.0));
        this.kolNN.setStyle("-fx-alignment: CENTER;");
        this.kolPodrucije.setCellValueFactory((Callback)new PropertyValueFactory("podrucije"));
        this.kolPodrucije.prefWidthProperty().bind((ObservableValue)this.tablicaZakoni.widthProperty().divide(5.0));
        this.kolPodrucije.setStyle("-fx-alignment: CENTER;");
        this.kolNaSnazi.setCellValueFactory((Callback)new PropertyValueFactory("nasnazi"));
        this.kolNaSnazi.prefWidthProperty().bind((ObservableValue)this.tablicaZakoni.widthProperty().divide(11.11111111111111));
        this.kolNaSnazi.setStyle("-fx-alignment: CENTER;");
        this.kolNaSnazi.setCellFactory((Callback)new Callback<TableColumn<Zakon, Boolean>, TableCell<Zakon, Boolean>>(){

            public TableCell<Zakon, Boolean> call(TableColumn<Zakon, Boolean> p) {
                return new CheckBoxTableCell<Zakon, Boolean>();
            }
        });
        this.kolPretraga.setGraphic((Node)this.tbFilter);
    }

    void popuniTablicuZakon() {
        this.tablicaZakoni.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Random rng = new Random();
        Task<Void> task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaZakona.clear();
        this.tablicaZakoni.getItems().clear();
    }

    private Task<Void> createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PregledZakonaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    PregledZakonaController.this.popuniTablicu();
                }
                finally {
                    Platform.runLater(() -> PregledZakonaController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicu() {
        ResultSet rs = BazaZakon.dajZakone(GlavniPanelController.getOdabranaTvrtka());
        int br = 1;
        try {
            while (rs.next()) {
                Zakon z = new Zakon();
                z.setId(rs.getInt("id"));
                z.setRedBroj(String.valueOf(br));
                z.setNaziv(rs.getString("naziv"));
                z.setPodrucije(rs.getString("podrucije"));
                z.setNN(rs.getString("nn"));
                z.setGodina(rs.getString("godina"));
                z.setNasnazi(rs.getBoolean("nasnazi"));
                this.listaZakona.add((Object)z);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PregledZakonaController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PregledZakonaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaZakoni.getItems().addAll(this.listaZakona);
    }

    public static class CheckBoxTableCell<S, T>
    extends TableCell<S, T> {
        private final CheckBox checkBox = new CheckBox();
        private ObservableValue<T> ov;

        public CheckBoxTableCell() {
            this.checkBox.setDisable(true);
            this.checkBox.setStyle("-fx-opacity: 1");
            this.checkBox.setAlignment(Pos.CENTER);
            this.setAlignment(Pos.CENTER);
            this.setGraphic((Node)this.checkBox);
        }

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                this.setGraphic((Node)this.checkBox);
                if (this.ov instanceof BooleanProperty) {
                    this.checkBox.selectedProperty().unbindBidirectional((Property)((BooleanProperty)this.ov));
                }
                this.ov = this.getTableColumn().getCellObservableValue(this.getIndex());
                if (this.ov instanceof BooleanProperty) {
                    this.checkBox.selectedProperty().bindBidirectional((Property)((BooleanProperty)this.ov));
                }
            }
        }
    }
}

