/*
 * Decompiled with CFR 0.152.
 */
package zastitanaradu;

import TamplatePaneli.Template;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import Utill.Postavke;
import Utill.ResizeComponent;
import Utill.SplitPaneDividerSlider;
import java.io.IOException;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.HostServices;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Accordion;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import javafx.util.Duration;
import kalendar.CalendarController;
import login.LogFileMonitoring;
import login.LoginControler;
import login.LoginManager;
import monitoringnovi.MonitoringNoviController;
import monitoringnovi.TjedniPregledController;
import postavke.PostavkePrograma;
import tvrtka.Korisnik;
import tvrtka.Tvrtka;
import tvrtka.TvrtkaController;
import tvrtka.UnosKorisnikaController;
import update.UpdateController;
import update.Updater;
import zastitanaradu.DraggableTab;

public class GlavniPanelController
implements Initializable {
    @FXML
    private HBox hBoxMenuButton;
    @FXML
    private Button btnTvrtka;
    @FXML
    private ToggleButton btnOtvori;
    @FXML
    Label labelNaslov;
    @FXML
    Label lblNazivKorisnika;
    @FXML
    Label lblNazivTvrtke;
    @FXML
    private AnchorPane topPanel;
    @FXML
    private AnchorPane root;
    @FXML
    private AnchorPane bottomPanel;
    @FXML
    private Accordion meniAccordian;
    @FXML
    private BorderPane borderPanelRoot;
    @FXML
    private SplitPane splitPanel;
    @FXML
    private TitledPane maticniPodaci;
    @FXML
    private TitledPane opcije;
    @FXML
    private TabPane tabPanel;
    @FXML
    private TitledPane znr;
    @FXML
    private Label sat;
    @FXML
    private TreeView stabloZNR;
    @FXML
    private TreeView stabloSifarnik;
    @FXML
    private TreeView stabloOpcije;
    @FXML
    private TitledPane osposobljavanja;
    @FXML
    private TreeView stabloOsposobljavanja;
    @FXML
    Label copyright;
    @FXML
    private Label lblVerPrograma;
    @FXML
    private Button btnLogOut;
    @FXML
    private MenuButton menBtnCloseTabs;
    @FXML
    private Text titleText;
    public static Tvrtka tvrtka;
    private static GlavniPanelController instance;
    public static HostServices hosting;
    private Korisnik korisnik;
    private SplitPaneDividerSlider leftSplitPaneDividerSlider;
    private String css;
    String COPYRIGHT = "\u00a9";
    private ContextMenu men;
    public static double VERZIJA_PROGRAMA;
    private DraggableTab t;
    private final List<Stage> draggableTabStageList = new ArrayList<Stage>();

    public static final void setHosting(HostServices hosting) {
        GlavniPanelController.hosting = hosting;
    }

    public static HostServices getHosting() {
        return hosting;
    }

    public static Tvrtka getOdabranaTvrtka() {
        return tvrtka;
    }

    public String getCss() {
        return this.css;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.promjeniFont(Postavke.getInstance().getFont());
        this.kreirajGlavniPanel();
        this.popuniStabloZNR();
        this.popuniStabloOsposobljavanja();
        this.popuniStabloSifarnik();
        this.popuniStabloOpcije();
        if (LoginControler.getLoginUser().getKorisnik().equals("Korisnik")) {
            if (PostavkePrograma.getInstance().isZastitaNaRadu() && PostavkePrograma.getInstance().isNadzoristekaperiodika()) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GlavniPanelController.this.btnOtvori.setSelected(true);
                        GlavniPanelController.this.nadodajPanel("Nadzor isteka periodika", "/monitoringnovi/MonitoringNovi.fxml");
                    }
                });
            }
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    GlavniPanelController.this.btnOtvori.setSelected(true);
                    GlavniPanelController.this.nadodajPanel("Nadzor isteka periodika", "/monitoringnovi/MonitoringNovi.fxml");
                }
            });
        }
    }

    public static GlavniPanelController getInstance() {
        return instance;
    }

    public void postaviKorisnika(Korisnik korisnik, Tvrtka tvrtka) {
        this.lblNazivKorisnika.setText("");
        this.lblNazivTvrtke.setText("");
        GlavniPanelController.tvrtka = tvrtka;
        this.korisnik = korisnik;
        this.lblNazivKorisnika.setText(korisnik.getIme() + " " + korisnik.getPrezime() + " - " + korisnik.getKorisnik());
        this.lblNazivTvrtke.setText(tvrtka.getNazivTvrtka());
    }

    public void zatvoriTab(String nazivTaba) {
        this.tabPanel.getTabs().remove((Object)this.getTabById(nazivTaba));
    }

    private void kreirajGlavniPanel() {
        this.copyright.setText("Copyright " + this.COPYRIGHT + " 2016-2020, EK-systems ver." + String.valueOf(VERZIJA_PROGRAMA));
        this.napraviSat();
        this.provjeriNadogradnjuPrograma();
        ResizeComponent.makeLabelResize(this.lblNazivTvrtke);
        MenuItem resizeItem = new MenuItem("Ukloni sve kartice");
        resizeItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (!GlavniPanelController.this.tabPanel.getTabs().isEmpty()) {
                    GlavniPanelController.this.ukloniTabove();
                    GlavniPanelController.this.tabPanel.setContextMenu(null);
                }
            }
        });
        this.men = new ContextMenu(new MenuItem[]{resizeItem});
        this.leftSplitPaneDividerSlider = new SplitPaneDividerSlider(this.splitPanel, 0, SplitPaneDividerSlider.Direction.LEFT, Duration.millis((double)1000.0));
        this.btnOtvori.selectedProperty().addListener((ov, t, t1) -> {
            this.leftSplitPaneDividerSlider.setAimContentVisible((boolean)t);
            if (t.booleanValue()) {
                this.btnOtvori.getStyleClass().remove((Object)"show-right");
                this.btnOtvori.getStyleClass().add((Object)"hide-left");
            } else {
                this.btnOtvori.getStyleClass().remove((Object)"hide-left");
                this.btnOtvori.getStyleClass().add((Object)"show-right");
            }
        });
    }

    public void popuniStabloZNR() {
        TreeItem root = new TreeItem((Object)"Dokumenti");
        root.setExpanded(true);
        TreeItem nadzor = new TreeItem((Object)"Nadzor");
        TreeItem nadzorIstekaPeriodika = new TreeItem((Object)"Nadzor isteka periodika");
        TreeItem tjedniPregled = new TreeItem((Object)"Tjedni pregled");
        TreeItem kadrovska = new TreeItem((Object)"Kadrovska evidencija");
        TreeItem popisRadnika = new TreeItem((Object)"Popis radnika");
        TreeItem ra1 = new TreeItem((Object)"Obrazac RA-1");
        TreeItem nr1 = new TreeItem((Object)"Obrazac NR-1");
        TreeItem oir1 = new TreeItem((Object)"Popis OIR-1");
        TreeItem or = new TreeItem((Object)"Prijava ozljede na radu (OR)");
        TreeItem pb = new TreeItem((Object)"Prijava profesionalne bolesti (PB)");
        TreeItem gi = new TreeItem((Object)"Godi\u0161nji izvje\u0161taj o ozljedama na radu");
        TreeItem alkotestiranje = new TreeItem((Object)"Alkotestiranje");
        TreeItem strojevi = new TreeItem((Object)"Radna oprema");
        TreeItem pregledStrojeva = new TreeItem((Object)"Pregled strojeva");
        TreeItem mjernaOprema = new TreeItem((Object)"Mjerna i ispitna oprema");
        TreeItem mjerniInstrumenti = new TreeItem((Object)"Mjerni instrumenti");
        TreeItem radniokolis = new TreeItem((Object)"Radna okolina");
        TreeItem fro = new TreeItem((Object)"Popis mjernih mjesta (FRO)");
        TreeItem ispitivanja = new TreeItem((Object)"Ispitivanja");
        TreeItem popisIspitivanjaObjekta = new TreeItem((Object)"Popis ispitivanja objekata");
        TreeItem va = new TreeItem((Object)"Vatrogasni aparati");
        TreeItem popisVatrogasnohAparata = new TreeItem((Object)"Popis vatrogasnih aparata");
        TreeItem PopisRedovnihPregledaVA = new TreeItem((Object)"Popis redovnih pregleda vatrogasnih aparata");
        if (LoginControler.getLoginUser().getKorisnik().equals("Korisnik")) {
            if (!PostavkePrograma.getInstance().isZastitaNaRadu()) {
                this.meniAccordian.getPanes().remove((Object)this.znr);
            }
            if (PostavkePrograma.getInstance().isNadzoristekaperiodika()) {
                nadzor.getChildren().add((Object)nadzorIstekaPeriodika);
            }
            if (PostavkePrograma.getInstance().isTjednipregled()) {
                nadzor.getChildren().add((Object)tjedniPregled);
            }
            if (PostavkePrograma.getInstance().isPopisRadnika()) {
                kadrovska.getChildren().add((Object)popisRadnika);
            }
            if (PostavkePrograma.getInstance().isObrazacRA1()) {
                kadrovska.getChildren().add((Object)ra1);
            }
            if (PostavkePrograma.getInstance().isObrazacNR1()) {
                kadrovska.getChildren().add((Object)nr1);
            }
            if (PostavkePrograma.getInstance().isPopisOIR1()) {
                kadrovska.getChildren().add((Object)oir1);
            }
            if (PostavkePrograma.getInstance().isPrijavaOzljedenNaRadu()) {
                kadrovska.getChildren().add((Object)or);
            }
            if (PostavkePrograma.getInstance().isPrijavaProfesionalneBolesti()) {
                kadrovska.getChildren().add((Object)pb);
            }
            if (PostavkePrograma.getInstance().isGodisnjiIzvjestaj()) {
                kadrovska.getChildren().add((Object)gi);
            }
            if (PostavkePrograma.getInstance().isAlkotestiranje()) {
                kadrovska.getChildren().add((Object)alkotestiranje);
            }
            if (PostavkePrograma.getInstance().isPregledStrojeva()) {
                strojevi.getChildren().add((Object)pregledStrojeva);
            }
            if (PostavkePrograma.getInstance().isMjerniInstrumenti()) {
                strojevi.getChildren().add((Object)mjerniInstrumenti);
            }
            if (PostavkePrograma.getInstance().isPopisMjernihMjesta()) {
                radniokolis.getChildren().add((Object)fro);
            }
            if (PostavkePrograma.getInstance().isPopisIspitivanjaObjekata()) {
                ispitivanja.getChildren().add((Object)popisIspitivanjaObjekta);
            }
            if (PostavkePrograma.getInstance().isPopisVatrogasnihAparata()) {
                va.getChildren().add((Object)popisVatrogasnohAparata);
            }
            if (PostavkePrograma.getInstance().isPopisRedovnihPregledaVatrogasnihAparata()) {
                va.getChildren().add((Object)PopisRedovnihPregledaVA);
            }
            if (!nadzor.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{nadzor});
            }
            if (!kadrovska.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{kadrovska});
            }
            if (!strojevi.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{strojevi});
            }
            if (!mjernaOprema.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{mjernaOprema});
            }
            if (!radniokolis.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{radniokolis});
            }
            if (!ispitivanja.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{ispitivanja});
            }
            if (!va.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{va});
            }
        } else {
            nadzor.getChildren().addAll(new Object[]{nadzorIstekaPeriodika, tjedniPregled});
            kadrovska.getChildren().addAll(new Object[]{popisRadnika, ra1, nr1, oir1, or, pb, gi, alkotestiranje});
            strojevi.getChildren().addAll(new Object[]{pregledStrojeva});
            mjernaOprema.getChildren().addAll(new Object[]{mjerniInstrumenti});
            radniokolis.getChildren().addAll(new Object[]{fro});
            ispitivanja.getChildren().addAll(new Object[]{popisIspitivanjaObjekta});
            va.getChildren().addAll(new Object[]{popisVatrogasnohAparata, PopisRedovnihPregledaVA});
            root.getChildren().addAll(new Object[]{nadzor, kadrovska, strojevi, mjernaOprema, radniokolis, ispitivanja, va});
        }
        this.stabloZNR.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.stabloZNR.setCellFactory((Callback)new Callback<TreeView<String>, TreeCell<String>>(){

            public TreeCell<String> call(TreeView<String> paramP) {
                return new TreeCell<String>(){

                    protected void updateItem(String paramT, boolean paramBoolean) {
                        super.updateItem((Object)paramT, paramBoolean);
                        if (!this.isEmpty()) {
                            this.setGraphic((Node)new Label(paramT));
                            final 1 this$ = this;
                            this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                                public void handle(MouseEvent event) {
                                    if (event.getClickCount() == 2) {
                                        String nodeValue = (String)this$.getItem();
                                        if (((String)this$.getItem()).equals("Nadzor isteka periodika stari")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/monitoring/Monitoring.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Nadzor isteka periodika")) {
                                            if (MonitoringNoviController.getInstance() != null && MonitoringNoviController.getInstance().isIsShowing()) {
                                                GlavniPanelController.this.getTabByIdifExist((String)this$.getItem());
                                            } else {
                                                GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/monitoringnovi/MonitoringNovi.fxml");
                                            }
                                        }
                                        if (((String)this$.getItem()).equals("Tjedni pregled stari")) {
                                            if (TjedniPregledController.getInstance() != null && TjedniPregledController.getInstance().isIsShowing()) {
                                                GlavniPanelController.this.getTabByIdifExist((String)this$.getItem());
                                            } else {
                                                GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/monitoringnovi/TjedniPregled.fxml");
                                            }
                                        }
                                        if (((String)this$.getItem()).equals("Tjedni pregled")) {
                                            if (CalendarController.getInstance() != null && CalendarController.getInstance().isIsShowing()) {
                                                GlavniPanelController.this.getTabByIdifExist((String)this$.getItem());
                                            } else {
                                                GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/kalendar/fxcalendar.fxml");
                                            }
                                        }
                                        if (((String)this$.getItem()).equals("Popis radnika")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/kadrovska/PopisDjelatnika.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Pregled strojeva")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/radnaoprema/PopisEvidencijeStroja.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Mjerni instrumenti")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/mjerniinstrumenti/PopisMjernihUredjaja.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis mjernih mjesta (FRO)")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/radniokolis/PregledMjernoMjestoFRO.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Obrazac RA-1")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/uputnice/PregledRA1.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Prijava ozljede na radu (OR)")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/ozljedanaradu/PregledOzljedaNaRadu.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Prijava profesionalne bolesti (PB)")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/profesionalnabolest/PregledProfesionalnihBolesti.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis ispitivanja objekata")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/objektiispitivanja/PregledObjektIspitivanje.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Obrazac RO-2")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/ro2/PregledRO2.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Obrazac RO-1")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/ro1/Ro1Obrazac.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Obrazac NR-1")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/nr1/PregledNR1.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis OIR-1")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/oir1/PopisOir1.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Godi\u0161nji izvje\u0161taj o ozljedama na radu")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/godisnjiizvjestaj/PregledGodisnjiIzvjestaj.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Alkotestiranje")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/alkotestiranje/PopisAlkotestiranja.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis vatrogasnih aparata")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/vatrogasniaparati/PopisVatrogasnihAparata.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis redovnih pregleda vatrogasnih aparata")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/vatrogasniaparatiredovnipregled/PopisRedovnogPregleda.fxml");
                                        }
                                    }
                                }
                            });
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        this.stabloZNR.setShowRoot(false);
        this.stabloZNR.setRoot(root);
    }

    public void popuniStabloSifarnik() {
        TreeItem root = new TreeItem((Object)"Dokumenti");
        root.setExpanded(true);
        TreeItem tvrtka = new TreeItem((Object)"Tvrtka");
        TreeItem opciPodaci = new TreeItem((Object)"Op\u0107i podaci");
        TreeItem popisPoslovnihJedinica = new TreeItem((Object)"Popis Poslovnih jedinica");
        TreeItem popisOdjela = new TreeItem((Object)"Popis odjela");
        TreeItem popisRM = new TreeItem((Object)"Popis radnih mjesta");
        TreeItem odbor = new TreeItem((Object)"Odbor za\u0161tite na radu");
        TreeItem zdrastvenaUstnova = new TreeItem((Object)"Ugovorena zdrastvena ustanova");
        TreeItem dokumentiTvrtke = new TreeItem((Object)"Popis dokumenata tvrtke");
        TreeItem ozs = new TreeItem((Object)"Osobna za\u0161titna oprema (OZO)");
        TreeItem popisOZO = new TreeItem((Object)"Popis OZO");
        TreeItem popisGrupeOzo = new TreeItem((Object)"Popis grupe OZO");
        TreeItem zakoni = new TreeItem((Object)"Zakoni/Pravilnici");
        TreeItem popisZakona = new TreeItem((Object)"Popis zakona/pravilnika");
        TreeItem ispitivanja = new TreeItem((Object)"Ispitivanja");
        TreeItem popisIspitivanja = new TreeItem((Object)"Popis ispitivanja");
        TreeItem osposobljavanja = new TreeItem((Object)"Osposobljavanja");
        TreeItem popisOsposobljavanja = new TreeItem((Object)"Popis osposobljavanja");
        TreeItem vrsteOsposobljavanja = new TreeItem((Object)"Vrste osposobljavanja");
        TreeItem strojevi = new TreeItem((Object)"Strojevi , ure\u0111aji i vatrogasni aparati");
        TreeItem nazivStrojeva = new TreeItem((Object)"Naziv strojeva , ure\u0111aja i vatrogasnih aparata");
        TreeItem popisProizvodaca = new TreeItem((Object)"Popis proizvo\u0111a\u010da");
        TreeItem popisGrupaStrojeva = new TreeItem((Object)"Popis grupa strojeva");
        TreeItem popisVrsteVA = new TreeItem((Object)"Popis vrste vatrogasnih aparata");
        TreeItem popisPregledaVA = new TreeItem((Object)"Popis pregleda vatrogasnih aparata");
        TreeItem ljecnickipregledi = new TreeItem((Object)"Lje\u010dni\u010dki pregledi");
        TreeItem popisLjecnickihPregleda = new TreeItem((Object)"Popis lje\u010dni\u010dkih pregleda");
        TreeItem ostalipregledi = new TreeItem((Object)"Ostali pregledi");
        TreeItem popisPregleda = new TreeItem((Object)"Popis pregleda");
        TreeItem hzzo = new TreeItem((Object)" HZZO ispostave");
        TreeItem popisHzzo = new TreeItem((Object)"Popis HZZO ispostava");
        TreeItem ispitivaci = new TreeItem((Object)"Ispitiva\u010di");
        TreeItem popisIspitivaca = new TreeItem((Object)"Popis ispitiva\u010da");
        if (LoginControler.getLoginUser().getKorisnik().equals("Korisnik")) {
            if (!PostavkePrograma.getInstance().isMaticniPodaci()) {
                this.meniAccordian.getPanes().remove((Object)this.maticniPodaci);
            }
            if (PostavkePrograma.getInstance().isOpciPodaci()) {
                tvrtka.getChildren().add((Object)opciPodaci);
            }
            if (PostavkePrograma.getInstance().isPopisPoslovnihedinica()) {
                tvrtka.getChildren().add((Object)popisPoslovnihJedinica);
            }
            if (PostavkePrograma.getInstance().isPopisOdjela()) {
                tvrtka.getChildren().add((Object)popisOdjela);
            }
            if (PostavkePrograma.getInstance().isPopisRadnihMjesta()) {
                tvrtka.getChildren().add((Object)popisRM);
            }
            if (PostavkePrograma.getInstance().isOdborZNR()) {
                tvrtka.getChildren().add((Object)odbor);
            }
            if (PostavkePrograma.getInstance().isUgovorenaZrastvenaUstanova()) {
                tvrtka.getChildren().add((Object)zdrastvenaUstnova);
            }
            if (PostavkePrograma.getInstance().isPopisDokumenataTvtke()) {
                tvrtka.getChildren().add((Object)dokumentiTvrtke);
            }
            if (PostavkePrograma.getInstance().isPopisOZO()) {
                ozs.getChildren().add((Object)popisOZO);
            }
            if (PostavkePrograma.getInstance().isPopisGrupeOZO()) {
                ozs.getChildren().add((Object)popisGrupeOzo);
            }
            if (PostavkePrograma.getInstance().isPopisZakona()) {
                zakoni.getChildren().add((Object)popisZakona);
            }
            if (PostavkePrograma.getInstance().isPopisIspitivanja()) {
                ispitivanja.getChildren().add((Object)popisIspitivanja);
            }
            if (PostavkePrograma.getInstance().isPopisOsposobljavanja()) {
                osposobljavanja.getChildren().add((Object)popisOsposobljavanja);
            }
            if (PostavkePrograma.getInstance().isVrsteOsposobljavanja()) {
                osposobljavanja.getChildren().add((Object)vrsteOsposobljavanja);
            }
            if (PostavkePrograma.getInstance().isNazivStrojevaUredajaVatrogasnihAparata()) {
                strojevi.getChildren().add((Object)nazivStrojeva);
            }
            if (PostavkePrograma.getInstance().isPopisProizvodaca()) {
                strojevi.getChildren().add((Object)popisProizvodaca);
            }
            if (PostavkePrograma.getInstance().isPopisGrupaStrojeva()) {
                strojevi.getChildren().add((Object)popisGrupaStrojeva);
            }
            if (PostavkePrograma.getInstance().isPopisVrsteVatrogasnihAparata()) {
                strojevi.getChildren().add((Object)popisVrsteVA);
            }
            if (PostavkePrograma.getInstance().isPopisPregledaVatrogasnihAparata()) {
                strojevi.getChildren().add((Object)popisPregledaVA);
            }
            if (PostavkePrograma.getInstance().isPopisLjecnickihPregleda()) {
                ljecnickipregledi.getChildren().add((Object)popisLjecnickihPregleda);
            }
            if (PostavkePrograma.getInstance().isPopisOstalihPregleda()) {
                ostalipregledi.getChildren().add((Object)popisPregleda);
            }
            if (PostavkePrograma.getInstance().isPopisHZZOIspostava()) {
                hzzo.getChildren().add((Object)popisHzzo);
            }
            if (PostavkePrograma.getInstance().isPopisIspitivaca()) {
                ispitivaci.getChildren().add((Object)popisIspitivaca);
            }
            if (!tvrtka.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{tvrtka});
            }
            if (!ozs.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{ozs});
            }
            if (!zakoni.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{zakoni});
            }
            if (!ispitivanja.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{ispitivanja});
            }
            if (!osposobljavanja.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{osposobljavanja});
            }
            if (!strojevi.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{strojevi});
            }
            if (!ljecnickipregledi.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{ljecnickipregledi});
            }
            if (!ostalipregledi.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{ostalipregledi});
            }
            if (!hzzo.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{hzzo});
            }
            if (!ispitivaci.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{ispitivaci});
            }
        } else {
            tvrtka.getChildren().addAll(new Object[]{opciPodaci, popisPoslovnihJedinica, popisOdjela, popisRM, odbor, zdrastvenaUstnova, dokumentiTvrtke});
            ozs.getChildren().addAll(new Object[]{popisOZO, popisGrupeOzo});
            zakoni.getChildren().addAll(new Object[]{popisZakona});
            ispitivanja.getChildren().addAll(new Object[]{popisIspitivanja});
            osposobljavanja.getChildren().addAll(new Object[]{popisOsposobljavanja, vrsteOsposobljavanja});
            strojevi.getChildren().addAll(new Object[]{nazivStrojeva, popisProizvodaca, popisGrupaStrojeva, popisVrsteVA, popisPregledaVA});
            ljecnickipregledi.getChildren().addAll(new Object[]{popisLjecnickihPregleda});
            ostalipregledi.getChildren().addAll(new Object[]{popisPregleda});
            hzzo.getChildren().addAll(new Object[]{popisHzzo});
            ispitivaci.getChildren().addAll(new Object[]{popisIspitivaca});
            root.getChildren().addAll(new Object[]{tvrtka, ozs, zakoni, ispitivanja, osposobljavanja, strojevi, ljecnickipregledi, ostalipregledi, hzzo, ispitivaci});
        }
        this.stabloSifarnik.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.stabloSifarnik.setCellFactory((Callback)new Callback<TreeView<String>, TreeCell<String>>(){

            public TreeCell<String> call(TreeView<String> paramP) {
                return new TreeCell<String>(){

                    protected void updateItem(String paramT, boolean paramBoolean) {
                        super.updateItem((Object)paramT, paramBoolean);
                        if (!this.isEmpty()) {
                            this.setGraphic((Node)new Label(paramT));
                            final 1 this$ = this;
                            this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                                public void handle(MouseEvent event) {
                                    if (event.getClickCount() == 2) {
                                        if (((String)this$.getItem()).equals("Op\u0107i podaci")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/tvrtka/TvrtkaMain.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis Poslovnih jedinica")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/poslovnejedinice/PregledPoslovnihJedinica.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis odjela")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/odjeli/PopisOdjela.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis radnih mjesta")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/radnamjesta/PregledRadnihMjesta.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Odbor za\u0161tite na radu")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/odbor/Odbor.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Ugovorena zdrastvena ustanova")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/zrastvenaustanova/PopisZrastveneUstanove.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis dokumenata tvrtke")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/dokumentiTvrtke/DokumentiTvrtke.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis OZO")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/ozs/Ozs.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis grupe OZO")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/grupeozs/PopisGrupaOZS.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis zakona/pravilnika")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/zakoni/PregledZakona.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis ispitivanja")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/ispitivanja/PopisIspitivanja.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis osposobljavanja")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/osposobljavanje/PopisOsposobljavanja.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis proizvo\u0111a\u010da")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/strojevi/PopisProizvodjaca.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Vrste osposobljavanja")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/osposobljavanje/PopisVrsteOsposobljavanja.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Naziv strojeva , ure\u0111aja i vatrogasnih aparata")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/strojevi/PopisStrojeva.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis grupa strojeva")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/strojevi/PopisGrupaStrojeva.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis pregleda")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/ostalipregledi/PopisPregleda.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis HZZO ispostava")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/hzzo/PopisHzzo.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis lje\u010dni\u010dkih pregleda")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/ljecnickipregledi/PopisLjecnickiPregled.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis vrste vatrogasnih aparata")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/vatrogasniaparati/PopisVrstaVA.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis pregleda vatrogasnih aparata")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/pregledivatrogasniaparati/PopisPregledaVA.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis ispitiva\u010da")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/ispitivaci/PopisIspitivaca.fxml");
                                        }
                                    }
                                }
                            });
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        this.stabloSifarnik.setRoot(root);
        this.stabloSifarnik.setShowRoot(false);
    }

    private void popuniStabloOpcije() {
        TreeItem root = new TreeItem((Object)"Dokumenti");
        root.setExpanded(true);
        TreeItem administracija = new TreeItem((Object)"Administracija");
        TreeItem promjenePass = new TreeItem((Object)"Promjena pasworda");
        TreeItem nadogradnjaPrograma = new TreeItem((Object)"Nadogradnja programa");
        TreeItem postavkePrograma = new TreeItem((Object)"Postavke programa");
        TreeItem periodika = new TreeItem((Object)"Periodike i zakonske regulative");
        TreeItem prikaziPeroidiku = new TreeItem((Object)"Prika\u017ei periodiku");
        TreeItem prikaziGospodarskeDjelatnosti = new TreeItem((Object)"Prika\u017ei gospodarske djelatnosti( sukladno NKD klasifikaciji)");
        TreeItem prikaziZanimanja = new TreeItem((Object)"Prika\u017ei zanimanja (sukladno NKZ - 10 klasifikaciji)");
        TreeItem pregledZakonskeRegulative = new TreeItem((Object)"Pregled zakonske regulative");
        TreeItem font = new TreeItem((Object)"Veli\u010dina fonta");
        font.getChildren().addAll(new Object[]{new TreeItem((Object)"Mali"), new TreeItem((Object)"Srednji"), new TreeItem((Object)"Veliki")});
        if (LoginControler.getLoginUser().getKorisnik().equals("Korisnik")) {
            if (!PostavkePrograma.getInstance().isOpcijePrograma()) {
                this.meniAccordian.getPanes().remove((Object)this.opcije);
            }
            if (PostavkePrograma.getInstance().isPromjenaPasworda()) {
                administracija.getChildren().add((Object)promjenePass);
            }
            if (PostavkePrograma.getInstance().isNadogradnjaPrograma()) {
                administracija.getChildren().add((Object)nadogradnjaPrograma);
            }
            if (PostavkePrograma.getInstance().isPrikaziPeriodiku()) {
                periodika.getChildren().add((Object)prikaziPeroidiku);
            }
            if (PostavkePrograma.getInstance().isPrikaziGospodarskeDjelatnosti()) {
                periodika.getChildren().add((Object)prikaziGospodarskeDjelatnosti);
            }
            if (PostavkePrograma.getInstance().isPrikaziZanimanja()) {
                periodika.getChildren().add((Object)prikaziZanimanja);
            }
            if (PostavkePrograma.getInstance().isPregledZakonskeRegulative()) {
                periodika.getChildren().add((Object)pregledZakonskeRegulative);
            }
            if (!administracija.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{administracija});
            }
            if (!periodika.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{periodika});
            }
        } else {
            administracija.getChildren().addAll(new Object[]{promjenePass, nadogradnjaPrograma, postavkePrograma});
            periodika.getChildren().addAll(new Object[]{prikaziPeroidiku, prikaziGospodarskeDjelatnosti, prikaziZanimanja, pregledZakonskeRegulative});
            root.getChildren().addAll(new Object[]{administracija, periodika});
        }
        root.getChildren().addAll(new Object[]{font});
        this.stabloOpcije.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.stabloOpcije.setCellFactory((Callback)new Callback<TreeView<String>, TreeCell<String>>(){

            public TreeCell<String> call(TreeView<String> paramP) {
                return new TreeCell<String>(){

                    protected void updateItem(String paramT, boolean paramBoolean) {
                        super.updateItem((Object)paramT, paramBoolean);
                        if (!this.isEmpty()) {
                            this.setGraphic((Node)new Label(paramT));
                            final 1 this$ = this;
                            this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                                public void handle(MouseEvent event) {
                                    if (event.getClickCount() == 2) {
                                        Scene scene;
                                        Stage dialog;
                                        FXMLLoader loader;
                                        String nodeValue = (String)this$.getItem();
                                        if (((String)this$.getItem()).equals("Unos iz CSV")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/csv/UnosDjelatnikaCSV.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Postavke programa")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/postavke/PostavkePrograma.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Nadogradnja programa")) {
                                            if (GlavniPanelController.this.tabPanel.getTabs().isEmpty() & GlavniPanelController.this.draggableTabStageList.isEmpty()) {
                                                loader = new FXMLLoader(this.getClass().getResource("/update/Update.fxml"));
                                                dialog = new Stage();
                                                dialog.initStyle(StageStyle.UNDECORATED);
                                                dialog.initModality(Modality.APPLICATION_MODAL);
                                                dialog.setTitle("Nadogradnja programa");
                                                scene = null;
                                                AnchorPane root = null;
                                                try {
                                                    root = new AnchorPane(new Node[]{(Parent)loader.load()});
                                                }
                                                catch (IOException ex) {
                                                    Logger.getLogger(GlavniPanelController.class.getName()).log(Level.SEVERE, null, ex);
                                                }
                                                root.setStyle("-fx-padding: 5; -fx-background-color:white; -fx-border-width:5; -fx-border-style: solid;-fx-background-insets: 0, 1, 2;-fx-border-color: #046272 ");
                                                root.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
                                                scene = new Scene((Parent)root);
                                                dialog.setScene(scene);
                                                dialog.show();
                                                UpdateController.getInstance().setScene(dialog);
                                            } else {
                                                Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate zatvoriti sve otvorene dokumente");
                                                alert.showAndWait();
                                            }
                                        }
                                        if (((String)this$.getItem()).equals("Mali")) {
                                            GlavniPanelController.this.promjeniFont(10);
                                        }
                                        if (((String)this$.getItem()).equals("Srednji")) {
                                            GlavniPanelController.this.promjeniFont(12);
                                        }
                                        if (((String)this$.getItem()).equals("Veliki")) {
                                            GlavniPanelController.this.promjeniFont(15);
                                        }
                                        if (((String)this$.getItem()).equals("Prika\u017ei periodiku")) {
                                            GlavniPanelController.getInstance().setBlurEfekt(new GaussianBlur(10.0));
                                            Template.getTamplate().prikaziPeriodiku("Popis periodika :", "pregledi");
                                        }
                                        if (((String)this$.getItem()).equals("Prika\u017ei gospodarske djelatnosti( sukladno NKD klasifikaciji)")) {
                                            GlavniPanelController.getInstance().setBlurEfekt(new GaussianBlur(10.0));
                                            Template.getTamplate().prikaziPeriodiku("Gospodarska djelatnost (sukladno NKD klasifikaciji):", "popisdjelatnostinkd");
                                        }
                                        if (((String)this$.getItem()).equals("Prika\u017ei zanimanja (sukladno NKZ - 10 klasifikaciji)")) {
                                            GlavniPanelController.getInstance().setBlurEfekt(new GaussianBlur(10.0));
                                            Template.getTamplate().prikaziPeriodiku("Zanimanja (sukladno NKZ - 10 klasifikaciji):", "zamimanjankz");
                                        }
                                        if (((String)this$.getItem()).equals("Pregled zakonske regulative")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/webview/WebPregled.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Promjena pasworda")) {
                                            GlavniPanelController.getInstance().setBlurEfekt(new GaussianBlur(10.0));
                                            loader = new FXMLLoader(this.getClass().getResource("/tvrtka/UnosKorisnika.fxml"));
                                            dialog = new Stage();
                                            dialog.initStyle(StageStyle.TRANSPARENT);
                                            dialog.initModality(Modality.APPLICATION_MODAL);
                                            dialog.setTitle("Unos korisnika");
                                            scene = null;
                                            try {
                                                Parent p1 = (Parent)loader.load();
                                                AnchorPane p = (AnchorPane)p1.lookup("#panelUnos");
                                                p.setStyle("-fx-padding: 5; -fx-background-color:white; -fx-border-width:5; -fx-border-style: solid;-fx-background-insets: 0, 1, 2;-fx-border-color: #046272 ");
                                                AnchorPane root = new AnchorPane(new Node[]{p});
                                                root.getStylesheets().add((Object)GlavniPanelController.getInstance().getCss());
                                                scene = new Scene((Parent)root);
                                            }
                                            catch (IOException ex) {
                                                Logger.getLogger(TvrtkaController.class.getName()).log(Level.SEVERE, null, ex);
                                            }
                                            dialog.setScene(scene);
                                            dialog.show();
                                            UnosKorisnikaController.getInstance().setScene(dialog);
                                            UnosKorisnikaController.getInstance().setKorisnik(LoginControler.getLoginUser());
                                        }
                                    }
                                }
                            });
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        this.stabloOpcije.setShowRoot(false);
        this.stabloOpcije.setRoot(root);
    }

    private void promjeniFont(int velFonta) {
        switch (velFonta) {
            case 10: {
                this.css = GlavniPanelController.class.getResource("GlavniPanel10.css").toExternalForm();
                this.root.getStylesheets().clear();
                this.root.getStylesheets().add((Object)this.css);
                Postavke.getInstance().setFont(10);
                break;
            }
            case 12: {
                this.css = GlavniPanelController.class.getResource("GlavniPanel.css").toExternalForm();
                this.root.getStylesheets().clear();
                this.root.getStylesheets().add((Object)this.css);
                Postavke.getInstance().setFont(12);
                break;
            }
            case 15: {
                this.css = GlavniPanelController.class.getResource("GlavniPanel15.css").toExternalForm();
                this.root.getStylesheets().clear();
                this.root.getStylesheets().add((Object)this.css);
                Postavke.getInstance().setFont(15);
                break;
            }
            default: {
                this.css = GlavniPanelController.class.getResource("GlavniPanel.css").toExternalForm();
                this.root.getStylesheets().clear();
                this.root.getStylesheets().add((Object)this.css);
                Postavke.getInstance().setFont(12);
            }
        }
    }

    private void napraviSat() {
        Timeline satTime = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), event -> this.sat.setText("  " + LocalDateTime.now().format(DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM)) + "  |  " + LocalDateTime.now().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM))), new KeyValue[0])});
        satTime.setCycleCount(-1);
        satTime.play();
    }

    public void setListStage(Stage draggableTabStage) {
        this.draggableTabStageList.add(draggableTabStage);
    }

    public void deleteListStage(Stage draggableTabStage) {
        this.draggableTabStageList.remove(draggableTabStage);
    }

    public void ukloniTabove() {
        this.tabPanel.getTabs().removeAll((Collection)this.tabPanel.getTabs());
        if (MonitoringNoviController.getInstance() != null && MonitoringNoviController.getInstance().isIsShowing()) {
            MonitoringNoviController.getInstance().setIsShowing(false);
        }
        if (TjedniPregledController.getInstance() != null && TjedniPregledController.getInstance().isIsShowing()) {
            TjedniPregledController.getInstance().setIsShowing(false);
        }
        if (CalendarController.getInstance() != null && CalendarController.getInstance().isIsShowing()) {
            CalendarController.getInstance().setIsShowing(false);
        }
        this.draggableTabStageList.stream().forEach(s -> s.close());
        this.draggableTabStageList.clear();
    }

    public boolean getTabByIdifExist(String id) {
        for (Tab tab : this.tabPanel.getTabs()) {
            if (!tab.getId().equals(id)) continue;
            this.tabPanel.getSelectionModel().select((Object)tab);
            return false;
        }
        return true;
    }

    public Tab getTabById(String id) {
        for (Tab tab : this.tabPanel.getTabs()) {
            if (!tab.getId().equals(id)) continue;
            return tab;
        }
        return null;
    }

    public void selectTab(Tab tab) {
        this.tabPanel.getSelectionModel().select((Object)tab);
    }

    public void nadodajPanel(String nazivTaba, String putanjaFxmlDatoteke) {
        if (this.getTabByIdifExist(nazivTaba)) {
            Label tabLabel = new Label(nazivTaba);
            this.t = new DraggableTab(tabLabel);
            this.t.setId(nazivTaba);
            this.t.setClosable(true);
            this.t.setGraphic((Node)tabLabel);
            tabLabel.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && mouseEvent.getClickCount() == 2) {
                        if (GlavniPanelController.this.leftSplitPaneDividerSlider.isAimContentVisible()) {
                            GlavniPanelController.this.btnOtvori.setSelected(true);
                        } else {
                            GlavniPanelController.this.btnOtvori.setSelected(false);
                        }
                    }
                }
            });
            Parent root = null;
            try {
                root = (Parent)FXMLLoader.load((URL)this.getClass().getResource(putanjaFxmlDatoteke));
            }
            catch (IOException ex) {
                Logger.getLogger(GlavniPanelController.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.t.setContent((Node)root);
            this.tabPanel.setTabClosingPolicy(TabPane.TabClosingPolicy.SELECTED_TAB);
            this.tabPanel.getTabs().add((Object)this.t);
            this.selectTab(this.t);
            this.tabPanel.setOnMouseClicked(event -> {
                if (MouseButton.SECONDARY.equals((Object)event.getButton())) {
                    if (event.getY() < 50.0 & !this.tabPanel.getTabs().isEmpty() & !this.men.isShowing()) {
                        this.men.show((Node)this.tabPanel, event.getScreenX(), event.getScreenY());
                    } else {
                        this.men.hide();
                    }
                }
                if (MouseButton.PRIMARY.equals((Object)event.getButton())) {
                    this.men.hide();
                }
            });
        }
    }

    public void initSessionID(final LoginManager loginManager) {
        this.btnLogOut.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (GlavniPanelController.this.tabPanel.getTabs().isEmpty() & GlavniPanelController.this.draggableTabStageList.isEmpty()) {
                    LogFileMonitoring.obrisiULogInfo();
                    loginManager.logout();
                } else {
                    Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate zatvoriti sve otvorene dokumente");
                    alert.showAndWait();
                }
            }
        });
        this.btnTvrtka.setOnAction(e -> {
            if (this.tabPanel.getTabs().isEmpty() & this.draggableTabStageList.isEmpty()) {
                loginManager.authenticated();
            } else {
                Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate zatvoriti sve otvorene dokumente");
                alert.showAndWait();
            }
        });
    }

    public void setBlurEfekt(GaussianBlur gb) {
    }

    public Tvrtka getTvrtka() {
        return tvrtka;
    }

    public URL ucitajPostavke(String putanjaFile) {
        URL configUrl = null;
        try {
            configUrl = new URL(hosting.resolveURI(hosting.getDocumentBase(), putanjaFile));
            System.out.println("Loading config properties from: " + configUrl);
        }
        catch (IOException e) {
            System.out.println("Unable to load config properties from: " + configUrl);
        }
        return configUrl;
    }

    public Korisnik getKorisnik() {
        return this.korisnik;
    }

    private void provjeriNadogradnjuPrograma() {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                try {
                    double d = Double.parseDouble(Updater.getLatestVersion());
                    GlavniPanelController.getInstance();
                    if (d > VERZIJA_PROGRAMA) {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, "Nova verzija programa je spremna za nadogradnju", 8, "Information graphic");
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        };
        new Thread((Runnable)task).start();
    }

    private void popuniStabloOsposobljavanja() {
        TreeItem root = new TreeItem((Object)"Dokumenti");
        root.setExpanded(true);
        TreeItem osposobljavanjeradnika = new TreeItem((Object)"Osposobljavanja radnika");
        TreeItem zos = new TreeItem((Object)"Obrazac (ZOS)");
        TreeItem zoop = new TreeItem((Object)"Obrazac (ZOOP)");
        TreeItem testovi = new TreeItem((Object)"Popis testova");
        if (LoginControler.getLoginUser().getKorisnik().equals("Korisnik")) {
            if (!PostavkePrograma.getInstance().isOsposobljavanje()) {
                this.meniAccordian.getPanes().remove((Object)this.osposobljavanja);
            }
            if (PostavkePrograma.getInstance().isZos()) {
                osposobljavanjeradnika.getChildren().add((Object)zos);
            }
            if (PostavkePrograma.getInstance().isZoop()) {
                osposobljavanjeradnika.getChildren().add((Object)zoop);
            }
            if (PostavkePrograma.getInstance().isTestovi()) {
                osposobljavanjeradnika.getChildren().add((Object)testovi);
            }
            if (!osposobljavanjeradnika.getChildren().isEmpty()) {
                root.getChildren().addAll(new Object[]{osposobljavanjeradnika});
            }
        } else {
            osposobljavanjeradnika.getChildren().addAll(new Object[]{zos, zoop, testovi});
            root.getChildren().addAll(new Object[]{osposobljavanjeradnika});
        }
        this.stabloOsposobljavanja.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        this.stabloOsposobljavanja.setCellFactory((Callback)new Callback<TreeView<String>, TreeCell<String>>(){

            public TreeCell<String> call(TreeView<String> paramP) {
                return new TreeCell<String>(){

                    protected void updateItem(String paramT, boolean paramBoolean) {
                        super.updateItem((Object)paramT, paramBoolean);
                        if (!this.isEmpty()) {
                            this.setGraphic((Node)new Label(paramT));
                            final 1 this$ = this;
                            this.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                                public void handle(MouseEvent event) {
                                    if (event.getClickCount() == 2) {
                                        String nodeValue = (String)this$.getItem();
                                        if (((String)this$.getItem()).equals("Obrazac (ZOS)")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/zos/PopisOsposobljavanjaZOS.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Obrazac (ZOOP)")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/zoop/PopisZOOP.fxml");
                                        }
                                        if (((String)this$.getItem()).equals("Popis testova")) {
                                            GlavniPanelController.this.nadodajPanel((String)this$.getItem(), "/testovi/PopisTestova.fxml");
                                        }
                                    }
                                }
                            });
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
            }
        });
        this.stabloOsposobljavanja.setShowRoot(false);
        this.stabloOsposobljavanja.setRoot(root);
    }

    static {
        VERZIJA_PROGRAMA = 1.3;
    }
}

