/*
 * Decompiled with CFR 0.152.
 */
package zoop;

import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.FxUtil;
import Utill.KlasaKorisneMetode;
import ispitivaci.Ispitivac;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import kadrovska.Djelatnik;
import zastitanaradu.GlavniPanelController;
import zoop.BazaZoop;
import zoop.PopisZOOPController;
import zoop.Zoop;
import zos.BazaZOS;

public class UnosZOOPController
implements Initializable {
    @FXML
    private Button btnSpremi;
    @FXML
    private AnchorPane anchorPanel;
    @FXML
    private TextField txtTNazivRadnika;
    @FXML
    private Button btnPretragaDjelatnika;
    @FXML
    private TextField txtTOibRadnika;
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<Zoop> tablicaPoslovi;
    @FXML
    private TableColumn<Zoop, String> kolPoslovi;
    @FXML
    private TableColumn<Zoop, String> kolMjestoPoslova;
    @FXML
    private CheckBox chboxT1;
    @FXML
    private CheckBox chboxT2;
    @FXML
    private CheckBox chboxT3;
    @FXML
    private CheckBox chboxT4;
    @FXML
    private CheckBox chboxT5;
    @FXML
    private CheckBox chboxT6;
    @FXML
    private CheckBox chboxT7;
    @FXML
    private ComboBox<String> cboxTMjesto;
    @FXML
    private DatePicker dateTOsposobljavanja;
    @FXML
    private Button btnUnosOsobe;
    @FXML
    private Button btnBrisanjeOsobe;
    @FXML
    private TableView<Zoop> tablicaOsobe;
    @FXML
    private TableColumn<Zoop, String> kolImeOsobe;
    @FXML
    private TableColumn<Zoop, String> kolOib;
    @FXML
    private TextField txtTStrucnjakZNR;
    @FXML
    private TextField txtTOvlastenik;
    @FXML
    private TextArea txtAreaUZaglavlje;
    @FXML
    private TextField txtUBrojUvjerenja;
    @FXML
    private TextField txtUPolaznik;
    @FXML
    private TextField txtURoden;
    @FXML
    private TextField txtUMjestoRodjenja;
    @FXML
    private TextField txtUOpcina;
    @FXML
    private TextField txtUZaposlenU;
    @FXML
    private TextField txtURadnoMjesto;
    @FXML
    private DatePicker dateUOsposobljavanja;
    @FXML
    private TextArea txtAreaUProgram;
    @FXML
    private TextField txtUUvjerenjeVrijediU;
    @FXML
    private TextArea txtAreaUOpisZaUvjerenje;
    @FXML
    private ComboBox<String> cboxUMjesto;
    @FXML
    private DatePicker dateUUvjerenja;
    @FXML
    private TextField txtUovlasteniPotpisnik;
    @FXML
    private TextArea txtAreaUPodnozje;
    @FXML
    private MenuButton btnUnosPoslova;
    @FXML
    private MenuButton btnUnosOsoba;
    @FXML
    private Button btnSZNR;
    private static UnosZOOPController instance;
    private final ObservableList<Zoop> listaPoslovi = FXCollections.observableArrayList();
    private final ObservableList<Zoop> listaOsobe = FXCollections.observableArrayList();
    private boolean izmjenaZOOP = false;
    private Zoop zoopIzmjena;
    private Djelatnik d;
    String zaglavlje = "Temeljom odredbi \u010dlanka 27.Zakona o za\u0161titi na radu(NN 71/14,118/14,154/14,94/18,96/18),\u010dl.5 Pravilnika o ovla\u0161tenjima za poslove za\u0161tite na radu (NN 112/14) i \u010dl.3 Pravilnika o osposobljavanju iz za\u0161tite na radu i polaganja stru\u010dnog ispita (NN 112/14) izdaje se:";
    String opisUvjerenja = "do nastupanja okolnosti koje prema odredbi \u010dl.27.Zakona o za\u0161titi na radu (NN 71/14,118/14,154/14,94/18,96/18) zahtjevaju ponovnu provjeru znanja.";
    String podnozje = "Osposobljavanje je obavljeno temeljom rje\u0161enja Zavoda za unapre\u0111ivanje za\u0161tite na radu Republike Hrvatske klasa:UP/I-115-01/15-01/42,ur.br.:425-01/1-15-3 od 19.06.2015.";

    public static UnosZOOPController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.urediTablicuPopisRM();
        this.urediTablicuPopisOsoba();
        this.popuniCBoxMjesta();
        this.popuniMenuButtonUnosPoslova();
        this.popuniMenuButtonUnosOsoba();
        this.tablicaPoslovi.setItems(this.listaPoslovi);
        this.tablicaOsobe.setItems(this.listaOsobe);
        this.btnUnos.setOnAction(e -> {
            Zoop zoop = new Zoop();
            this.listaPoslovi.add((Object)zoop);
        });
        this.btnBrisanje.disableProperty().bind((ObservableValue)this.tablicaPoslovi.getSelectionModel().selectedItemProperty().isNull());
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int index = this.tablicaPoslovi.getSelectionModel().getSelectedIndex();
            if (index != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati posao")).showAndWait()).get() == ButtonType.OK) {
                this.listaPoslovi.remove(index);
            }
        });
        this.btnUnosOsobe.setOnAction(e -> {
            Zoop zoop = new Zoop();
            this.listaOsobe.add((Object)zoop);
        });
        this.btnBrisanjeOsobe.disableProperty().bind((ObservableValue)this.tablicaOsobe.getSelectionModel().selectedItemProperty().isNull());
        this.btnBrisanjeOsobe.setOnAction(e -> {
            Alert alert;
            Optional result;
            int index = this.tablicaOsobe.getSelectionModel().getSelectedIndex();
            if (index != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati osobu")).showAndWait()).get() == ButtonType.OK) {
                this.listaOsobe.remove(index);
            }
        });
        this.btnPretragaDjelatnika.setOnAction(e -> {
            this.d = FxDialogs.getDjelatnikDijalog();
            if (this.d != null) {
                this.popuniDjelatnika(this.d);
            }
        });
        this.btnSpremi.setOnAction(e -> this.unosZOOP());
        this.btnSZNR.setOnAction(e -> {
            Ispitivac is = FxDialogs.getIspitivaciDijalog();
            if (is != null) {
                this.txtTStrucnjakZNR.setText(is.getIme());
            }
        });
    }

    private void popuniDjelatnika(Djelatnik d) {
        this.txtTNazivRadnika.setText(d.getIme() + " " + d.getPrezime());
        this.txtTOibRadnika.setText(d.getOIB());
        this.txtTOvlastenik.setText(d.getIme() + " " + d.getPrezime());
        this.txtAreaUZaglavlje.setText(this.zaglavlje);
        this.txtUPolaznik.setText(d.getIme() + " " + d.getPrezime());
        this.txtURoden.setText(d.getDatumRodjenja().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
        this.txtUMjestoRodjenja.setText(d.getMjestoRodjenja());
        this.txtUOpcina.setText(d.getOpcinaRodjenja());
        this.txtUZaposlenU.setText(GlavniPanelController.getOdabranaTvrtka().getNazivTvrtka() + "  " + GlavniPanelController.getOdabranaTvrtka().getMjesto() + " ," + GlavniPanelController.getOdabranaTvrtka().getAdresa());
        this.txtUUvjerenjeVrijediU.setText(GlavniPanelController.getOdabranaTvrtka().getNazivTvrtka());
        this.txtAreaUOpisZaUvjerenje.setText(this.opisUvjerenja);
        this.txtURadnoMjesto.setText(d.getRadnoMjesto());
        this.txtAreaUPodnozje.setText(this.podnozje);
    }

    private void urediTablicuPopisRM() {
        this.tablicaPoslovi.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    UnosZOOPController.this.tablicaPoslovi.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolPoslovi.setCellValueFactory(cellData -> ((Zoop)cellData.getValue()).tNazivPoslovaProperty());
        this.kolPoslovi.prefWidthProperty().bind((ObservableValue)this.tablicaPoslovi.widthProperty().divide(2.0));
        this.kolPoslovi.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolPoslovi.setStyle("-fx-alignment: CENTER;");
        this.kolMjestoPoslova.setCellValueFactory(cellData -> ((Zoop)cellData.getValue()).tMjestoObavljanjaPoslovaProperty());
        this.kolMjestoPoslova.prefWidthProperty().bind((ObservableValue)this.tablicaPoslovi.widthProperty().divide(2.0408163265306123));
        this.kolMjestoPoslova.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolMjestoPoslova.setStyle("-fx-alignment: CENTER;");
    }

    private void urediTablicuPopisOsoba() {
        this.tablicaOsobe.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    UnosZOOPController.this.tablicaOsobe.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolImeOsobe.setCellValueFactory(cellData -> ((Zoop)cellData.getValue()).tImeOsobeOsposobljavanjeProperty());
        this.kolImeOsobe.prefWidthProperty().bind((ObservableValue)this.tablicaOsobe.widthProperty().divide(1.4285714285714286));
        this.kolImeOsobe.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolImeOsobe.setStyle("-fx-alignment: CENTER;");
        this.kolOib.setCellValueFactory(cellData -> ((Zoop)cellData.getValue()).tOibOsobeOsposobljavanjeProperty());
        this.kolOib.prefWidthProperty().bind((ObservableValue)this.tablicaOsobe.widthProperty().divide(3.4482758620689653));
        this.kolOib.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolOib.setStyle("-fx-alignment: CENTER;");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniCBoxMjesta() {
        ObservableList listaMjesta = FXCollections.observableArrayList();
        ResultSet rs = BazaZoop.dajMjesta();
        try {
            while (rs.next()) {
                listaMjesta.add((Object)rs.getString("nazivgrada"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosZOOPController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosZOOPController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.cboxTMjesto.getItems().addAll((Collection)listaMjesta);
        this.cboxUMjesto.getItems().addAll((Collection)listaMjesta);
        FxUtil.autoCompleteComboBox(this.cboxTMjesto, FxUtil.AutoCompleteMode.STARTS_WITH);
        FxUtil.autoCompleteComboBox(this.cboxUMjesto, FxUtil.AutoCompleteMode.STARTS_WITH);
    }

    private void unosZOOP() {
        boolean boib;
        boolean bNazivRadnika = FormValidation.textFieldValidationonlyText(this.txtTNazivRadnika);
        if (bNazivRadnika & (boib = FormValidation.textFieldValidationonlyText(this.txtTOibRadnika))) {
            if (this.izmjenaZOOP) {
                if (BazaZoop.izmjenaZOOP(GlavniPanelController.getOdabranaTvrtka(), this.dajZOOP(), this.zoopIzmjena.getId())) {
                    PopisZOOPController.getInstance().popuniTablicuPopisZOOP();
                    GlavniPanelController.getInstance().zatvoriTab("Unos ZOOP");
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena zoop", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena zoop", 2, "Error graphic");
                }
            } else if (BazaZoop.unesiNoviZOOP(GlavniPanelController.getOdabranaTvrtka(), this.dajZOOP())) {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen zoop", 1, "Information graphic");
                PopisZOOPController.getInstance().popuniTablicuPopisZOOP();
                GlavniPanelController.getInstance().zatvoriTab("Unos ZOOP");
                this.izmjenaZOOP = false;
            } else {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no uneseno zoop", 2, "Error graphic");
            }
        } else {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate unjeti text");
            alert.showAndWait();
        }
    }

    private Zoop dajZOOP() {
        Zoop z = new Zoop();
        z.setNazivRadnika(this.txtTNazivRadnika.getText());
        z.setOibRadnika(this.txtTOibRadnika.getText());
        z.setPoslovi(this.getPoslovi(this.listaPoslovi));
        if (this.cboxTMjesto.getValue() != null) {
            z.setTeorijaMjestoOsposobljavanja((String)this.cboxTMjesto.getValue());
        } else {
            z.setTeorijaMjestoOsposobljavanja("");
        }
        z.setDatumTOsposobljavanja((LocalDate)this.dateTOsposobljavanja.getValue());
        z.setOsobe(this.getOsobe(this.listaOsobe));
        z.settStrucnjakZNR(this.txtTStrucnjakZNR.getText());
        z.settOsposobljeniRadnik(this.txtTOvlastenik.getText());
        z.setP1(this.chboxT1.isSelected());
        z.setP2(this.chboxT2.isSelected());
        z.setP3(this.chboxT3.isSelected());
        z.setP4(this.chboxT4.isSelected());
        z.setP5(this.chboxT5.isSelected());
        z.setP6(this.chboxT6.isSelected());
        z.setP7(this.chboxT7.isSelected());
        z.setuZaglavlje(this.txtAreaUZaglavlje.getText());
        z.setuBrojUvjerenja(this.txtUBrojUvjerenja.getText());
        z.setuPolaznik(this.txtUPolaznik.getText());
        z.setuRodjen(this.txtURoden.getText());
        z.setuMjesto(this.txtUMjestoRodjenja.getText());
        z.setuOpcina(this.txtUOpcina.getText());
        z.setuZaposlenU(this.txtUZaposlenU.getText());
        z.setuRadnoMjesto(this.txtURadnoMjesto.getText());
        z.setDatumUOsposobljavanja((LocalDate)this.dateUOsposobljavanja.getValue());
        z.setuProgramOsposobljavanja(this.txtAreaUProgram.getText());
        z.setuUvjerenjeOpis(this.txtAreaUOpisZaUvjerenje.getText());
        z.setuUvjerenjeVrijediU(this.txtUUvjerenjeVrijediU.getText());
        if (this.cboxUMjesto.getValue() != null) {
            z.setuMjestoUvjerenja((String)this.cboxUMjesto.getValue());
        } else {
            z.setuMjestoUvjerenja("");
        }
        z.setDatumUUvjerenja((LocalDate)this.dateUUvjerenja.getValue());
        z.setuOvlasteniPotpisnik(this.txtUovlasteniPotpisnik.getText());
        z.setUpodnozje(this.txtAreaUPodnozje.getText());
        return z;
    }

    private String getPoslovi(ObservableList<Zoop> lista) {
        String idArray = "";
        for (int i = 0; i < lista.size(); ++i) {
            idArray = i == 0 ? idArray + "['" + String.valueOf(((Zoop)lista.get(i)).gettNazivPoslova() + "','" + ((Zoop)lista.get(i)).gettMjestoObavljanjaPoslova() + "']") : idArray + ",['" + String.valueOf(((Zoop)lista.get(i)).gettNazivPoslova() + "','" + ((Zoop)lista.get(i)).gettMjestoObavljanjaPoslova() + "']");
        }
        return idArray;
    }

    private String getOsobe(ObservableList<Zoop> lista) {
        String idArray = "";
        for (int i = 0; i < lista.size(); ++i) {
            idArray = i == 0 ? idArray + "['" + String.valueOf(((Zoop)lista.get(i)).gettImeOsobeOsposobljavanje() + "','" + ((Zoop)lista.get(i)).gettOibOsobeOsposobljavanje() + "']") : idArray + ",['" + String.valueOf(((Zoop)lista.get(i)).gettImeOsobeOsposobljavanje() + "','" + ((Zoop)lista.get(i)).gettOibOsobeOsposobljavanje() + "']");
        }
        return idArray;
    }

    void izmjenaZOOP(Zoop zoopIzmjena) {
        this.izmjenaZOOP = true;
        this.zoopIzmjena = zoopIzmjena;
        this.txtTNazivRadnika.setText(zoopIzmjena.getNazivRadnika());
        this.txtTOibRadnika.setText(zoopIzmjena.getOibRadnika());
        this.popuniTablicuPoslovi(zoopIzmjena);
        this.cboxTMjesto.setValue((Object)zoopIzmjena.getTeorijaMjestoOsposobljavanja());
        this.dateTOsposobljavanja.setValue((Object)zoopIzmjena.getDatumTOsposobljavanja());
        this.popuniTablicuOsobe(zoopIzmjena);
        this.txtTStrucnjakZNR.setText(zoopIzmjena.gettStrucnjakZNR());
        this.txtTOvlastenik.setText(zoopIzmjena.gettOsposobljeniRadnik());
        this.chboxT1.setSelected(zoopIzmjena.isP1());
        this.chboxT2.setSelected(zoopIzmjena.isP2());
        this.chboxT3.setSelected(zoopIzmjena.isP3());
        this.chboxT4.setSelected(zoopIzmjena.isP4());
        this.chboxT5.setSelected(zoopIzmjena.isP5());
        this.chboxT6.setSelected(zoopIzmjena.isP6());
        this.chboxT7.setSelected(zoopIzmjena.isP7());
        this.txtAreaUZaglavlje.setText(zoopIzmjena.getuZaglavlje());
        this.txtUBrojUvjerenja.setText(zoopIzmjena.getuBrojUvjerenja());
        this.txtUPolaznik.setText(zoopIzmjena.getuPolaznik());
        this.txtURoden.setText(zoopIzmjena.getuRodjen());
        this.txtUMjestoRodjenja.setText(zoopIzmjena.getuMjesto());
        this.txtUOpcina.setText(zoopIzmjena.getuOpcina());
        this.txtUZaposlenU.setText(zoopIzmjena.getuZaposlenU());
        this.txtURadnoMjesto.setText(zoopIzmjena.getuRadnoMjesto());
        this.dateUOsposobljavanja.setValue((Object)zoopIzmjena.getDatumUOsposobljavanja());
        this.txtAreaUProgram.setText(zoopIzmjena.getuProgramOsposobljavanja());
        this.txtAreaUOpisZaUvjerenje.setText(zoopIzmjena.getuUvjerenjeOpis());
        this.txtUUvjerenjeVrijediU.setText(zoopIzmjena.getuUvjerenjeVrijediU());
        this.cboxUMjesto.setValue((Object)zoopIzmjena.getuMjestoUvjerenja());
        this.dateUUvjerenja.setValue((Object)zoopIzmjena.getDatumUUvjerenja());
        this.txtUovlasteniPotpisnik.setText(zoopIzmjena.getuOvlasteniPotpisnik());
        this.txtAreaUPodnozje.setText(zoopIzmjena.getUpodnozje());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuPoslovi(Zoop zoopIzmjena) {
        ResultSet rs = BazaZoop.dajPoslove(GlavniPanelController.getOdabranaTvrtka(), zoopIzmjena);
        try {
            while (rs.next()) {
                Zoop z = new Zoop();
                z.settNazivPoslova(rs.getString("posao"));
                z.settMjestoObavljanjaPoslova(rs.getString("mjestoposla"));
                this.listaPoslovi.add((Object)z);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosZOOPController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosZOOPController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuOsobe(Zoop zoopIzmjena) {
        ResultSet rs = BazaZoop.dajOsobe(GlavniPanelController.getOdabranaTvrtka(), zoopIzmjena);
        try {
            while (rs.next()) {
                Zoop z = new Zoop();
                z.settImeOsobeOsposobljavanje(rs.getString("osoba"));
                z.settOibOsobeOsposobljavanje(rs.getString("oib"));
                this.listaOsobe.add((Object)z);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosZOOPController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosZOOPController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void popuniMenuButtonUnosPoslova() {
        MenuItem miPrazanRed = new MenuItem("Unesi prazan red");
        miPrazanRed.setOnAction(event -> {
            Zoop zos = new Zoop();
            this.listaPoslovi.add((Object)zos);
        });
        MenuItem miRadnoMjesto = new MenuItem("Unesi podatke iz radnog mjesta radnika");
        miRadnoMjesto.setOnAction(event -> {
            if (!this.txtTOibRadnika.getText().isEmpty()) {
                Zoop zos = new Zoop();
                ResultSet rs = BazaZOS.dajRadnoMjesto(this.d.getId());
                try {
                    while (rs.next()) {
                        zos.settNazivPoslova(rs.getString("naznakasadrzaja"));
                        zos.settMjestoObavljanjaPoslova(rs.getString("nazivposlovnice") + "\n" + rs.getString("nazivodjela"));
                        this.listaPoslovi.add((Object)zos);
                    }
                }
                catch (SQLException ex) {
                    Logger.getLogger(UnosZOOPController.class.getName()).log(Level.SEVERE, null, ex);
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(UnosZOOPController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        this.btnUnosPoslova.getItems().addAll((Object[])new MenuItem[]{miPrazanRed, new SeparatorMenuItem(), miRadnoMjesto});
    }

    private void popuniMenuButtonUnosOsoba() {
        MenuItem miPrazanRed = new MenuItem("Unesi prazan red");
        miPrazanRed.setOnAction(event -> {
            Zoop zos = new Zoop();
            this.listaOsobe.add((Object)zos);
        });
        MenuItem miIspitivaci = new MenuItem("Unesi podatke iz popisa ispitiva\u010da");
        miIspitivaci.setOnAction(event -> {
            Zoop zos = new Zoop();
            Ispitivac is = FxDialogs.getIspitivaciDijalog();
            if (is != null) {
                zos.settImeOsobeOsposobljavanje(is.getIme());
                zos.settOibOsobeOsposobljavanje(is.getOib());
                this.listaOsobe.add((Object)zos);
            }
        });
        MenuItem miRM = new MenuItem("Unesi podatke iz popisa radnika");
        miRM.setOnAction(event -> {
            Zoop zos = new Zoop();
            Djelatnik d = FxDialogs.getDjelatnikDijalog();
            if (d != null) {
                zos.settImeOsobeOsposobljavanje(d.getIme() + " " + d.getPrezime());
                zos.settOibOsobeOsposobljavanje(d.getOIB());
                this.listaOsobe.add((Object)zos);
            }
        });
        this.btnUnosOsoba.getItems().addAll((Object[])new MenuItem[]{miPrazanRed, new SeparatorMenuItem(), miIspitivaci, new SeparatorMenuItem(), miRM});
    }
}

