/*
 * Decompiled with CFR 0.152.
 */
package zos;

import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.FxUtil;
import Utill.KlasaKorisneMetode;
import ispitivaci.Ispitivac;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import kadrovska.Djelatnik;
import zastitanaradu.GlavniPanelController;
import zos.BazaZOS;
import zos.PopisOsposobljavanjaZOSController;
import zos.Zos;

public class UnosOsposibljavanjaZOSController
implements Initializable {
    @FXML
    private Button btnSpremi;
    @FXML
    private TextField txtTNazivRadnika;
    @FXML
    private Button btnPretragaDjelatnika;
    @FXML
    private TextField txtTOibRadnika;
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnBrisanje;
    @FXML
    private TableView<Zos> tablicaPoslovi;
    @FXML
    private TableColumn<Zos, String> kolPoslovi;
    @FXML
    private TableColumn<Zos, String> kolMjestoPoslova;
    @FXML
    private ComboBox<String> cboxTMjesto;
    @FXML
    private DatePicker dateTOsposobljavanja;
    @FXML
    private Button btnUnosOsobe;
    @FXML
    private Button btnBrisanjeOsobe;
    @FXML
    private TableView<Zos> tablicaOsobe;
    @FXML
    private TableColumn<Zos, String> kolImeOsobe;
    @FXML
    private TableColumn<Zos, String> kolOib;
    @FXML
    private TextField txtTStrucnjakZNR;
    @FXML
    private TextField txtTosposobljeniRadnik;
    @FXML
    private CheckBox chboxP1;
    @FXML
    private CheckBox chboxP2;
    @FXML
    private CheckBox chboxP3;
    @FXML
    private CheckBox chboxP4;
    @FXML
    private CheckBox chboxP5;
    @FXML
    private CheckBox chboxP6;
    @FXML
    private CheckBox chboxP7;
    @FXML
    private CheckBox chboxP8;
    @FXML
    private DatePicker datePDatumProvjere;
    @FXML
    private ComboBox<String> cboxPMjesto;
    @FXML
    private TextField txtPOvlastenik;
    @FXML
    private TextField txtPFunkcija;
    @FXML
    private TextField txtPStrucnjakZNROsposobljavanje;
    @FXML
    private TextField txtPStrucnjakZNR;
    @FXML
    private TextArea txtAreaUZaglavlje;
    @FXML
    private TextField txtUBrojUvjerenja;
    @FXML
    private TextField txtUPolaznik;
    @FXML
    private TextField txtURoden;
    @FXML
    private TextField txtUMjestoRodjenja;
    @FXML
    private TextField txtUOpcina;
    @FXML
    private TextField txtUZaposlenU;
    @FXML
    private TextField txtURadnoMjesto;
    @FXML
    private DatePicker dateUOsposobljavanja;
    @FXML
    private TextArea txtAreaUProgram;
    @FXML
    private TextField txtUUvjerenjeVrijediU;
    @FXML
    private TextArea txtAreaUOpisZaUvjerenje;
    @FXML
    private TextArea txtAreaUPodnozje;
    @FXML
    private ComboBox<String> cboxUMjesto;
    @FXML
    private TextField txtUovlasteniPotpisnik;
    @FXML
    private DatePicker dateUUvjerenja;
    @FXML
    private MenuButton btnUnosPoslova;
    @FXML
    private MenuButton btnUnosOsoba;
    @FXML
    private Button btnPSZNR;
    @FXML
    private Button btnPSZNRO;
    @FXML
    private Button btnTSZNR;
    @FXML
    private Button btnPOvlastenik;
    private static UnosOsposibljavanjaZOSController instance;
    private final ObservableList<Zos> listaPoslovi = FXCollections.observableArrayList();
    private final ObservableList<Zos> listaOsobe = FXCollections.observableArrayList();
    private boolean izmjenaZOS = false;
    private Zos zosIzmjena;
    String zaglavlje = "Temeljom odredbi \u010dlanka 27.Zakona o za\u0161titi na radu(NN 71/14,118/14,154/14,94/18,96/18),\u010dl.5 Pravilnika o ovla\u0161tenjima za poslove za\u0161tite na radu (NN 112/14) i \u010dl.3 Pravilnika o osposobljavanju iz za\u0161tite na radu i polaganja stru\u010dnog ispita (NN 112/14) izdaje se:";
    String opisUvjerenja = "do nastupanja okolnosti koje prema odredbi \u010dl.27.Zakona o za\u0161titi na radu (NN 71/14,118/14,154/14,94/18,96/18) zahtjevaju ponovnu provjeru znanja.";
    String podnozje = "Osposobljavanje je obavljeno temeljom rje\u0161enja Zavoda za unapre\u0111ivanje za\u0161tite na radu Republike Hrvatske klasa:UP/I-115-01/15-01/42,ur.br.:425-01/1-15-3 od 19.06.2015.";
    private Djelatnik d;

    public static UnosOsposibljavanjaZOSController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.urediTablicuPopisRM();
        this.urediTablicuPopisOsoba();
        this.popuniCBoxMjesta();
        this.popuniMenuButtonUnosPoslova();
        this.popuniMenuButtonUnosOsoba();
        this.tablicaPoslovi.setItems(this.listaPoslovi);
        this.tablicaOsobe.setItems(this.listaOsobe);
        this.btnUnos.setOnAction(e -> {
            Zos zos = new Zos();
            this.listaPoslovi.add((Object)zos);
        });
        this.btnBrisanje.disableProperty().bind((ObservableValue)this.tablicaPoslovi.getSelectionModel().selectedItemProperty().isNull());
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int index = this.tablicaPoslovi.getSelectionModel().getSelectedIndex();
            if (index != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati posao")).showAndWait()).get() == ButtonType.OK) {
                this.listaPoslovi.remove(index);
            }
        });
        this.btnUnosOsobe.setOnAction(e -> {
            Zos zos = new Zos();
            this.listaOsobe.add((Object)zos);
        });
        this.btnBrisanjeOsobe.disableProperty().bind((ObservableValue)this.tablicaOsobe.getSelectionModel().selectedItemProperty().isNull());
        this.btnBrisanjeOsobe.setOnAction(e -> {
            Alert alert;
            Optional result;
            int index = this.tablicaOsobe.getSelectionModel().getSelectedIndex();
            if (index != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati osobu")).showAndWait()).get() == ButtonType.OK) {
                this.listaOsobe.remove(index);
            }
        });
        this.btnPretragaDjelatnika.setOnAction(e -> {
            this.d = FxDialogs.getDjelatnikDijalog();
            if (this.d != null) {
                this.popuniDjelatnika(this.d);
            }
        });
        this.btnSpremi.setOnAction(e -> this.unosZOS());
        this.btnTSZNR.setOnAction(e -> {
            Ispitivac is = FxDialogs.getIspitivaciDijalog();
            if (is != null) {
                this.txtTStrucnjakZNR.setText(is.getIme());
            }
        });
        this.btnPSZNR.setOnAction(e -> {
            Ispitivac is = FxDialogs.getIspitivaciDijalog();
            if (is != null) {
                this.txtPStrucnjakZNR.setText(is.getIme());
            }
        });
        this.btnPSZNRO.setOnAction(e -> {
            Ispitivac is = FxDialogs.getIspitivaciDijalog();
            if (is != null) {
                this.txtPStrucnjakZNROsposobljavanje.setText(is.getIme());
            }
        });
        this.btnPOvlastenik.setOnAction(e -> {
            Ispitivac is = FxDialogs.getIspitivaciDijalog();
            if (is != null) {
                this.txtPOvlastenik.setText(is.getIme());
                this.txtPFunkcija.setText(is.getFunkcija());
            }
        });
    }

    private void urediTablicuPopisRM() {
        this.tablicaPoslovi.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    UnosOsposibljavanjaZOSController.this.tablicaPoslovi.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolPoslovi.setCellValueFactory(cellData -> ((Zos)cellData.getValue()).tNazivPoslovaProperty());
        this.kolPoslovi.prefWidthProperty().bind((ObservableValue)this.tablicaPoslovi.widthProperty().divide(2.0));
        this.kolPoslovi.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolPoslovi.setStyle("-fx-alignment: CENTER;");
        this.kolMjestoPoslova.setCellValueFactory(cellData -> ((Zos)cellData.getValue()).tMjestoObavljanjaPoslovaProperty());
        this.kolMjestoPoslova.prefWidthProperty().bind((ObservableValue)this.tablicaPoslovi.widthProperty().divide(2.0408163265306123));
        this.kolMjestoPoslova.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolMjestoPoslova.setStyle("-fx-alignment: CENTER;");
    }

    private void urediTablicuPopisOsoba() {
        this.tablicaOsobe.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    UnosOsposibljavanjaZOSController.this.tablicaOsobe.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolImeOsobe.setCellValueFactory(cellData -> ((Zos)cellData.getValue()).tImeOsobeOsposobljavanjeProperty());
        this.kolImeOsobe.prefWidthProperty().bind((ObservableValue)this.tablicaOsobe.widthProperty().divide(1.4285714285714286));
        this.kolImeOsobe.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolImeOsobe.setStyle("-fx-alignment: CENTER;");
        this.kolOib.setCellValueFactory(cellData -> ((Zos)cellData.getValue()).tOibOsobeOsposobljavanjeProperty());
        this.kolOib.prefWidthProperty().bind((ObservableValue)this.tablicaOsobe.widthProperty().divide(3.4482758620689653));
        this.kolOib.setCellFactory(TextFieldTableCell.forTableColumn());
        this.kolOib.setStyle("-fx-alignment: CENTER;");
    }

    private void popuniDjelatnika(Djelatnik d) {
        this.txtTNazivRadnika.setText(d.getIme() + " " + d.getPrezime());
        this.txtTOibRadnika.setText(d.getOIB());
        this.txtTosposobljeniRadnik.setText(d.getIme() + " " + d.getPrezime());
        this.txtAreaUZaglavlje.setText(this.zaglavlje);
        this.txtUPolaznik.setText(d.getIme() + " " + d.getPrezime());
        this.txtURoden.setText(d.getDatumRodjenja().format(DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM)));
        this.txtUMjestoRodjenja.setText(d.getMjestoRodjenja());
        this.txtUOpcina.setText(d.getOpcinaRodjenja());
        this.txtUZaposlenU.setText(GlavniPanelController.getOdabranaTvrtka().getNazivTvrtka() + "  " + GlavniPanelController.getOdabranaTvrtka().getMjesto() + " ," + GlavniPanelController.getOdabranaTvrtka().getAdresa());
        this.txtUUvjerenjeVrijediU.setText(GlavniPanelController.getOdabranaTvrtka().getNazivTvrtka());
        this.txtAreaUOpisZaUvjerenje.setText(this.opisUvjerenja);
        this.txtURadnoMjesto.setText(d.getRadnoMjesto());
        this.txtAreaUPodnozje.setText(this.podnozje);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniCBoxMjesta() {
        ObservableList listaMjesta = FXCollections.observableArrayList();
        ResultSet rs = BazaZOS.dajMjesta();
        try {
            while (rs.next()) {
                listaMjesta.add((Object)rs.getString("nazivgrada"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosOsposibljavanjaZOSController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosOsposibljavanjaZOSController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.cboxTMjesto.getItems().addAll((Collection)listaMjesta);
        this.cboxPMjesto.getItems().addAll((Collection)listaMjesta);
        this.cboxUMjesto.getItems().addAll((Collection)listaMjesta);
        FxUtil.autoCompleteComboBox(this.cboxTMjesto, FxUtil.AutoCompleteMode.STARTS_WITH);
        FxUtil.autoCompleteComboBox(this.cboxPMjesto, FxUtil.AutoCompleteMode.STARTS_WITH);
        FxUtil.autoCompleteComboBox(this.cboxUMjesto, FxUtil.AutoCompleteMode.STARTS_WITH);
    }

    private void unosZOS() {
        boolean boib;
        boolean bNazivRadnika = FormValidation.textFieldValidationonlyText(this.txtTNazivRadnika);
        if (bNazivRadnika & (boib = FormValidation.textFieldValidationonlyText(this.txtTOibRadnika))) {
            if (this.izmjenaZOS) {
                if (BazaZOS.izmjenaZOS(GlavniPanelController.getOdabranaTvrtka(), this.dajZOS(), this.zosIzmjena.getId())) {
                    PopisOsposobljavanjaZOSController.getInstance().popuniTablicuPopisZos();
                    GlavniPanelController.getInstance().zatvoriTab("Unos ZOS");
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena zos", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena zos", 2, "Error graphic");
                }
            } else if (BazaZOS.unesiNoviZOS(GlavniPanelController.getOdabranaTvrtka(), this.dajZOS())) {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesen zos", 1, "Information graphic");
                PopisOsposobljavanjaZOSController.getInstance().popuniTablicuPopisZos();
                GlavniPanelController.getInstance().zatvoriTab("Unos ZOS");
                this.izmjenaZOS = false;
            } else {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no uneseno zos", 2, "Error graphic");
            }
        } else {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate unjeti text");
            alert.showAndWait();
        }
    }

    Zos dajZOS() {
        Zos z = new Zos();
        z.setNazivRadnika(this.txtTNazivRadnika.getText());
        z.setOibRadnika(this.txtTOibRadnika.getText());
        z.setPoslovi(this.getPoslovi(this.listaPoslovi));
        if (this.cboxTMjesto.getValue() != null) {
            z.setTeorijaMjestoOsposobljavanja((String)this.cboxTMjesto.getValue());
        } else {
            z.setTeorijaMjestoOsposobljavanja("");
        }
        z.setDatumTOsposobljavanja((LocalDate)this.dateTOsposobljavanja.getValue());
        z.setOsobe(this.getOsobe(this.listaOsobe));
        z.settStrucnjakZNR(this.txtTStrucnjakZNR.getText());
        z.settOsposobljeniRadnik(this.txtTosposobljeniRadnik.getText());
        z.setP1(this.chboxP1.isSelected());
        z.setP2(this.chboxP2.isSelected());
        z.setP3(this.chboxP3.isSelected());
        z.setP4(this.chboxP4.isSelected());
        z.setP5(this.chboxP5.isSelected());
        z.setP6(this.chboxP6.isSelected());
        z.setP7(this.chboxP7.isSelected());
        z.setP8(this.chboxP8.isSelected());
        z.setDatumPOsposobljavanja((LocalDate)this.datePDatumProvjere.getValue());
        if (this.cboxPMjesto.getValue() != null) {
            z.setpMjesto((String)this.cboxPMjesto.getValue());
        } else {
            z.setpMjesto("");
        }
        z.setpOvlastenik(this.txtPOvlastenik.getText());
        z.setpFunkcija(this.txtPFunkcija.getText());
        z.setpStrucnjakZNROsposobljavanje(this.txtPStrucnjakZNROsposobljavanje.getText());
        z.setpStrucnjakZNR(this.txtPStrucnjakZNR.getText());
        z.setuZaglavlje(this.txtAreaUZaglavlje.getText());
        z.setuBrojUvjerenja(this.txtUBrojUvjerenja.getText());
        z.setuPolaznik(this.txtUPolaznik.getText());
        z.setuRodjen(this.txtURoden.getText());
        z.setuMjesto(this.txtUMjestoRodjenja.getText());
        z.setuOpcina(this.txtUOpcina.getText());
        z.setuZaposlenU(this.txtUZaposlenU.getText());
        z.setuRadnoMjesto(this.txtURadnoMjesto.getText());
        z.setDatumUOsposobljavanja((LocalDate)this.dateUOsposobljavanja.getValue());
        z.setuProgramOsposobljavanja(this.txtAreaUProgram.getText());
        z.setuUvjerenjeOpis(this.txtAreaUOpisZaUvjerenje.getText());
        z.setuUvjerenjeVrijediU(this.txtUUvjerenjeVrijediU.getText());
        if (this.cboxUMjesto.getValue() != null) {
            z.setuMjestoUvjerenja((String)this.cboxUMjesto.getValue());
        } else {
            z.setuMjestoUvjerenja("");
        }
        z.setDatumUUvjerenja((LocalDate)this.dateUUvjerenja.getValue());
        z.setuOvlasteniPotpisnik(this.txtUovlasteniPotpisnik.getText());
        z.setUpodnozje(this.txtAreaUPodnozje.getText());
        return z;
    }

    private String getPoslovi(ObservableList<Zos> lista) {
        String idArray = "";
        for (int i = 0; i < lista.size(); ++i) {
            idArray = i == 0 ? idArray + "['" + String.valueOf(((Zos)lista.get(i)).gettNazivPoslova() + "','" + ((Zos)lista.get(i)).gettMjestoObavljanjaPoslova() + "']") : idArray + ",['" + String.valueOf(((Zos)lista.get(i)).gettNazivPoslova() + "','" + ((Zos)lista.get(i)).gettMjestoObavljanjaPoslova() + "']");
        }
        return idArray;
    }

    private String getOsobe(ObservableList<Zos> lista) {
        String idArray = "";
        for (int i = 0; i < lista.size(); ++i) {
            idArray = i == 0 ? idArray + "['" + String.valueOf(((Zos)lista.get(i)).gettImeOsobeOsposobljavanje() + "','" + ((Zos)lista.get(i)).gettOibOsobeOsposobljavanje() + "']") : idArray + ",['" + String.valueOf(((Zos)lista.get(i)).gettImeOsobeOsposobljavanje() + "','" + ((Zos)lista.get(i)).gettOibOsobeOsposobljavanje() + "']");
        }
        return idArray;
    }

    void izmjenaZOS(Zos zosIzmjena) {
        this.izmjenaZOS = true;
        this.zosIzmjena = zosIzmjena;
        this.txtTNazivRadnika.setText(zosIzmjena.getNazivRadnika());
        this.txtTOibRadnika.setText(zosIzmjena.getOibRadnika());
        this.popuniTablicuPoslovi(zosIzmjena);
        this.cboxTMjesto.setValue((Object)zosIzmjena.getTeorijaMjestoOsposobljavanja());
        this.dateTOsposobljavanja.setValue((Object)zosIzmjena.getDatumTOsposobljavanja());
        this.popuniTablicuOsobe(zosIzmjena);
        this.txtTStrucnjakZNR.setText(zosIzmjena.gettStrucnjakZNR());
        this.txtTosposobljeniRadnik.setText(zosIzmjena.gettOsposobljeniRadnik());
        this.chboxP1.setSelected(zosIzmjena.isP1());
        this.chboxP2.setSelected(zosIzmjena.isP2());
        this.chboxP3.setSelected(zosIzmjena.isP3());
        this.chboxP4.setSelected(zosIzmjena.isP4());
        this.chboxP5.setSelected(zosIzmjena.isP5());
        this.chboxP6.setSelected(zosIzmjena.isP6());
        this.chboxP7.setSelected(zosIzmjena.isP7());
        this.chboxP8.setSelected(zosIzmjena.isP8());
        this.datePDatumProvjere.setValue((Object)zosIzmjena.getDatumPOsposobljavanja());
        this.cboxPMjesto.setValue((Object)zosIzmjena.getpMjesto());
        this.txtPOvlastenik.setText(zosIzmjena.getpOvlastenik());
        this.txtPFunkcija.setText(zosIzmjena.getpFunkcija());
        this.txtPStrucnjakZNROsposobljavanje.setText(zosIzmjena.getpStrucnjakZNROsposobljavanje());
        this.txtPStrucnjakZNR.setText(zosIzmjena.getpStrucnjakZNR());
        this.txtAreaUZaglavlje.setText(zosIzmjena.getuZaglavlje());
        this.txtUBrojUvjerenja.setText(zosIzmjena.getuBrojUvjerenja());
        this.txtUPolaznik.setText(zosIzmjena.getuPolaznik());
        this.txtURoden.setText(zosIzmjena.getuRodjen());
        this.txtUMjestoRodjenja.setText(zosIzmjena.getuMjesto());
        this.txtUOpcina.setText(zosIzmjena.getuOpcina());
        this.txtUZaposlenU.setText(zosIzmjena.getuZaposlenU());
        this.txtURadnoMjesto.setText(zosIzmjena.getuRadnoMjesto());
        this.dateUOsposobljavanja.setValue((Object)zosIzmjena.getDatumUOsposobljavanja());
        this.txtAreaUProgram.setText(zosIzmjena.getuProgramOsposobljavanja());
        this.txtAreaUOpisZaUvjerenje.setText(zosIzmjena.getuUvjerenjeOpis());
        this.txtUUvjerenjeVrijediU.setText(zosIzmjena.getuUvjerenjeVrijediU());
        this.cboxUMjesto.setValue((Object)zosIzmjena.getuMjestoUvjerenja());
        this.dateUUvjerenja.setValue((Object)zosIzmjena.getDatumUUvjerenja());
        this.txtUovlasteniPotpisnik.setText(zosIzmjena.getuOvlasteniPotpisnik());
        this.txtAreaUPodnozje.setText(zosIzmjena.getUpodnozje());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuPoslovi(Zos zosIzmjena) {
        ResultSet rs = BazaZOS.dajPoslove(GlavniPanelController.getOdabranaTvrtka(), zosIzmjena);
        try {
            while (rs.next()) {
                Zos z = new Zos();
                z.settNazivPoslova(rs.getString("posao"));
                z.settMjestoObavljanjaPoslova(rs.getString("mjestoposla"));
                this.listaPoslovi.add((Object)z);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosOsposibljavanjaZOSController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosOsposibljavanjaZOSController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuOsobe(Zos zosIzmjena) {
        ResultSet rs = BazaZOS.dajOsobe(GlavniPanelController.getOdabranaTvrtka(), zosIzmjena);
        try {
            while (rs.next()) {
                Zos z = new Zos();
                z.settImeOsobeOsposobljavanje(rs.getString("osoba"));
                z.settOibOsobeOsposobljavanje(rs.getString("oib"));
                this.listaOsobe.add((Object)z);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosOsposibljavanjaZOSController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosOsposibljavanjaZOSController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void popuniMenuButtonUnosPoslova() {
        MenuItem miPrazanRed = new MenuItem("Unesi prazan red");
        miPrazanRed.setOnAction(event -> {
            Zos zos = new Zos();
            this.listaPoslovi.add((Object)zos);
        });
        MenuItem miRadnoMjesto = new MenuItem("Unesi podatke iz radnog mjesta radnika");
        miRadnoMjesto.setOnAction(event -> {
            if (!this.txtTOibRadnika.getText().isEmpty()) {
                Zos zos = new Zos();
                ResultSet rs = BazaZOS.dajRadnoMjesto(this.d.getId());
                try {
                    while (rs.next()) {
                        zos.settNazivPoslova(rs.getString("naznakasadrzaja"));
                        zos.settMjestoObavljanjaPoslova(rs.getString("nazivposlovnice") + "\n" + rs.getString("nazivodjela"));
                        this.listaPoslovi.add((Object)zos);
                    }
                }
                catch (SQLException ex) {
                    Logger.getLogger(UnosOsposibljavanjaZOSController.class.getName()).log(Level.SEVERE, null, ex);
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(UnosOsposibljavanjaZOSController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        this.btnUnosPoslova.getItems().addAll((Object[])new MenuItem[]{miPrazanRed, new SeparatorMenuItem(), miRadnoMjesto});
    }

    private void popuniMenuButtonUnosOsoba() {
        MenuItem miPrazanRed = new MenuItem("Unesi prazan red");
        miPrazanRed.setOnAction(event -> {
            Zos zos = new Zos();
            this.listaOsobe.add((Object)zos);
        });
        MenuItem miIspitivaci = new MenuItem("Unesi podatke iz popisa ispitiva\u010da");
        miIspitivaci.setOnAction(event -> {
            Zos zos = new Zos();
            Ispitivac is = FxDialogs.getIspitivaciDijalog();
            if (is != null) {
                zos.settImeOsobeOsposobljavanje(is.getIme());
                zos.settOibOsobeOsposobljavanje(is.getOib());
                this.listaOsobe.add((Object)zos);
            }
        });
        MenuItem miRM = new MenuItem("Unesi podatke iz popisa radnika");
        miRM.setOnAction(event -> {
            Zos zos = new Zos();
            Djelatnik d = FxDialogs.getDjelatnikDijalog();
            if (d != null) {
                zos.settImeOsobeOsposobljavanje(d.getIme() + " " + d.getPrezime());
                zos.settOibOsobeOsposobljavanje(d.getOIB());
                this.listaOsobe.add((Object)zos);
            }
        });
        this.btnUnosOsoba.getItems().addAll((Object[])new MenuItem[]{miPrazanRed, new SeparatorMenuItem(), miIspitivaci, new SeparatorMenuItem(), miRM});
    }
}

