/*
 * Decompiled with CFR 0.152.
 */
package zrastvenaustanova;

import TamplatePaneli.Template;
import Utill.DateCell;
import Utill.DateUtil;
import Utill.FxDialogs;
import Utill.KlasaKorisneMetode;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Callback;
import zastitanaradu.GlavniPanelController;
import zrastvenaustanova.BazaZdrastvenaUstanova;
import zrastvenaustanova.UnosZdrastveneUstanoveController;
import zrastvenaustanova.ZdrastvenaUstanova;

public class PopisZrastveneUstanoveController
implements Initializable {
    @FXML
    private Button btnUnos;
    @FXML
    private Button btnPromjena;
    @FXML
    private Button btnBrisanje;
    @FXML
    private Button btnIspis;
    @FXML
    private TableView<ZdrastvenaUstanova> tablicaPopisZrastvenihUstanova;
    @FXML
    private TableColumn<ZdrastvenaUstanova, String> kolPretraga;
    @FXML
    private TableColumn<ZdrastvenaUstanova, String> kolRedBr;
    @FXML
    private TableColumn<ZdrastvenaUstanova, LocalDate> kolDatumUgovora;
    @FXML
    private TableColumn<ZdrastvenaUstanova, String> kolNazivUstanove;
    @FXML
    private TableColumn<ZdrastvenaUstanova, String> kolNazivLje\u010dnika;
    @FXML
    private TableColumn<ZdrastvenaUstanova, String> kolMjesto;
    private static PopisZrastveneUstanoveController instance;
    private ToolBar tbFilter;
    private TextField tfilter;
    private ComboBox cbFilter;
    private final ObservableList<ZdrastvenaUstanova> listaUstanova = FXCollections.observableArrayList();
    ProgressIndicator progressIndicator = new ProgressIndicator();

    public static PopisZrastveneUstanoveController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        this.kreirajToolBarFilter();
        this.urediTablicuPopisZrastvenihUstanova();
        this.popuniTablicuPopisZrastvenihUstanova();
        this.urediFilter(this.tablicaPopisZrastvenihUstanova);
        this.btnUnos.setOnAction(e -> {
            if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos zrastvene ustanove")) {
                GlavniPanelController.getInstance().zatvoriTab("Unos zrastvene ustanove");
                GlavniPanelController.getInstance().nadodajPanel("Unos zrastvene ustanove", "/zrastvenaustanova/UnosZdrastveneUstanove.fxml");
            } else {
                GlavniPanelController.getInstance().nadodajPanel("Unos zrastvene ustanove", "/zrastvenaustanova/UnosZdrastveneUstanove.fxml");
            }
        });
        this.btnPromjena.setOnAction(e -> {
            ZdrastvenaUstanova se;
            int selectdIndex = this.tablicaPopisZrastvenihUstanova.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (se = (ZdrastvenaUstanova)this.tablicaPopisZrastvenihUstanova.getSelectionModel().getSelectedItem()) != null) {
                if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos zrastvene ustanove")) {
                    GlavniPanelController.getInstance().zatvoriTab("Unos zrastvene ustanove");
                    GlavniPanelController.getInstance().nadodajPanel("Unos zrastvene ustanove", "/zrastvenaustanova/UnosZdrastveneUstanove.fxml");
                    UnosZdrastveneUstanoveController.getInstance().popuniUstanovu(se);
                } else {
                    GlavniPanelController.getInstance().nadodajPanel("Unos zrastvene ustanove", "/zrastvenaustanova/UnosZdrastveneUstanove.fxml");
                    UnosZdrastveneUstanoveController.getInstance().popuniUstanovu(se);
                }
                this.tablicaPopisZrastvenihUstanova.getSelectionModel().clearSelection();
            }
        });
        this.btnBrisanje.setOnAction(e -> {
            Alert alert;
            Optional result;
            int selectdIndex = this.tablicaPopisZrastvenihUstanova.getSelectionModel().getSelectedIndex();
            if (selectdIndex != -1 && (result = (alert = FxDialogs.getDialog(Alert.AlertType.CONFIRMATION, "Brisanje", "\u017delite li obrisati ustanovu")).showAndWait()).get() == ButtonType.OK) {
                if (BazaZdrastvenaUstanova.obrisiUstanovu((ZdrastvenaUstanova)this.tablicaPopisZrastvenihUstanova.getSelectionModel().getSelectedItem())) {
                    this.popuniTablicuPopisZrastvenihUstanova();
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no obrisana ustanova", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no obrisana ustanova", 2, "Error graphic");
                }
            }
        });
    }

    private void kreirajToolBarFilter() {
        this.tbFilter = new ToolBar();
        this.tfilter = new TextField();
        this.tfilter.setPromptText("Filter");
        this.tfilter.setId("textField");
        this.cbFilter = new ComboBox();
        ObservableList filter = FXCollections.observableArrayList((Object[])new String[]{"Naziv ustanove", "Naziv lje\u010dnika", "Mjesto"});
        this.cbFilter.getItems().addAll((Collection)filter);
        this.cbFilter.setValue((Object)"Naziv ustanove");
        this.cbFilter.setPrefWidth(250.0);
        this.cbFilter.setPrefHeight(25.0);
        this.tfilter.setPrefWidth(200.0);
        this.tfilter.setPrefHeight(25.0);
        this.tbFilter.getItems().addAll((Object[])new Node[]{this.tfilter, this.cbFilter});
    }

    private void urediFilter(TableView tablicaPregleda) {
        FilteredList filteredData = new FilteredList(this.listaUstanova, p -> true);
        this.tfilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(pregled -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv ustanove") ? pregled.getNazivUstanove() != null && pregled.getNazivUstanove().toLowerCase().contains(lowerCaseFilter) : (this.cbFilter.getSelectionModel().getSelectedItem().equals("Naziv lje\u010dnika") ? pregled.getNazivLijecnika() != null && pregled.getNazivLijecnika().toLowerCase().contains(lowerCaseFilter) : this.cbFilter.getSelectionModel().getSelectedItem().equals("Mjesto") && pregled.getMjesto() != null && pregled.getMjesto().toLowerCase().startsWith(lowerCaseFilter));
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)tablicaPregleda.comparatorProperty());
        tablicaPregleda.refresh();
        tablicaPregleda.setItems((ObservableList)sortedData);
    }

    private void urediTablicuPopisZrastvenihUstanova() {
        this.tablicaPopisZrastvenihUstanova.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tablicaPopisZrastvenihUstanova.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent e) {
                if (e.getCode() == KeyCode.ESCAPE) {
                    PopisZrastveneUstanoveController.this.tablicaPopisZrastvenihUstanova.getSelectionModel().clearSelection();
                    e.consume();
                    return;
                }
            }
        });
        this.kolRedBr.setCellValueFactory(cellData -> ((ZdrastvenaUstanova)cellData.getValue()).redBrojProperty());
        this.kolRedBr.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZrastvenihUstanova.widthProperty().divide(20.0));
        this.kolRedBr.setStyle("-fx-alignment: CENTER;");
        Callback dateCellFactory = param -> new DateCell();
        this.kolDatumUgovora.setCellValueFactory(cellData -> ((ZdrastvenaUstanova)cellData.getValue()).datumSklapanjaUgovoraProperty());
        this.kolDatumUgovora.setCellFactory(dateCellFactory);
        this.kolDatumUgovora.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZrastvenihUstanova.widthProperty().divide(10.0));
        this.kolDatumUgovora.setStyle("-fx-alignment: CENTER;");
        this.kolDatumUgovora.setEditable(false);
        this.kolNazivUstanove.setCellValueFactory(cellData -> ((ZdrastvenaUstanova)cellData.getValue()).nazivUstanoveProperty());
        this.kolNazivUstanove.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZrastvenihUstanova.widthProperty().divide(3.3333333333333335));
        this.kolNazivUstanove.setStyle("-fx-alignment: CENTER;");
        this.kolNazivLje\u010dnika.setCellValueFactory(cellData -> ((ZdrastvenaUstanova)cellData.getValue()).nazivLijecnikaProperty());
        this.kolNazivLje\u010dnika.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZrastvenihUstanova.widthProperty().divide(3.3333333333333335));
        this.kolNazivLje\u010dnika.setStyle("-fx-alignment: CENTER;");
        this.kolMjesto.setCellValueFactory(cellData -> ((ZdrastvenaUstanova)cellData.getValue()).mjestoProperty());
        this.kolMjesto.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZrastvenihUstanova.widthProperty().divide(7.142857142857143));
        this.kolMjesto.setStyle("-fx-alignment: CENTER;");
        TableColumn kolPregledOzljeda = new TableColumn("Pregled");
        kolPregledOzljeda.setSortable(false);
        kolPregledOzljeda.prefWidthProperty().bind((ObservableValue)this.tablicaPopisZrastvenihUstanova.widthProperty().divide(10.0));
        kolPregledOzljeda.setStyle("-fx-alignment: CENTER;");
        kolPregledOzljeda.setCellFactory((Callback)new Callback<TableColumn<ZdrastvenaUstanova, Boolean>, TableCell<ZdrastvenaUstanova, Boolean>>(){

            public TableCell<ZdrastvenaUstanova, Boolean> call(TableColumn<ZdrastvenaUstanova, Boolean> param) {
                return new ButtonCell();
            }
        });
        this.kolPretraga.setGraphic((Node)this.tbFilter);
        this.kolPretraga.getColumns().add((Object)kolPregledOzljeda);
    }

    public void popuniTablicuPopisZrastvenihUstanova() {
        this.tablicaPopisZrastvenihUstanova.setPlaceholder((Node)this.progressIndicator);
        this.progressIndicator.setMaxSize(200.0, 200.0);
        this.progressIndicator.setVisible(true);
        Task task = this.createTask();
        new Thread((Runnable)task).start();
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.listaUstanova.clear();
        this.tablicaPopisZrastvenihUstanova.getItems().clear();
    }

    private Task createTask() {
        return new Task<Void>(){

            public Void call() {
                try {
                    this.updateProgress(-1.0, 1.0);
                    this.updateMessage("Waiting...");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(PopisZrastveneUstanoveController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    this.updateMessage("Running...");
                    ResultSet rs = BazaZdrastvenaUstanova.dajUstanovu(GlavniPanelController.getOdabranaTvrtka());
                    PopisZrastveneUstanoveController.this.popuniTablicuUstanova(rs);
                }
                finally {
                    Platform.runLater(() -> PopisZrastveneUstanoveController.this.progressIndicator.setVisible(false));
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniTablicuUstanova(ResultSet rs) {
        ZdrastvenaUstanova zu = null;
        int br = 1;
        try {
            while (rs.next()) {
                zu = new ZdrastvenaUstanova();
                zu.setRedBroj(String.valueOf(br));
                zu.setId(rs.getInt("id"));
                zu.setNazivUstanove(rs.getString("nazivustanove"));
                zu.setOib(rs.getString("oib"));
                zu.setAdresa(rs.getString("adresa"));
                zu.setZupanija(rs.getString("zupanija"));
                zu.setPbr(rs.getString("pbr"));
                zu.setMjesto(rs.getString("mjesto"));
                zu.setOpcina(rs.getString("opcina"));
                zu.setDrzava(rs.getString("drzava"));
                zu.setNazivLijecnika(rs.getString("nazivlijecnika"));
                zu.setSifraLijecnika(rs.getString("sifralijecnika"));
                zu.setMedSestra(rs.getString("medsestra"));
                zu.setTelefon(rs.getString("telefon"));
                zu.setFax(rs.getString("fax"));
                zu.setMobitel(rs.getString("mobitel"));
                zu.setIban(rs.getString("iban"));
                zu.setNazivBanke(rs.getString("nazivbanke"));
                zu.setEmail(rs.getString("email"));
                zu.setDatumSklapanjaUgovora(DateUtil.getLocalDate(rs.getDate("datumsklapanjaugovora")));
                zu.setNapomena(rs.getString("napomena"));
                zu.setNazivDokumenta(rs.getString("dokumentugovor"));
                this.listaUstanova.add((Object)zu);
                ++br;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PopisZrastveneUstanoveController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(PopisZrastveneUstanoveController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.tablicaPopisZrastvenihUstanova.getItems().addAll(this.listaUstanova);
    }

    private class ButtonCell
    extends TableCell<ZdrastvenaUstanova, Boolean> {
        Button cellButton = new Button("Pregled");

        ButtonCell() {
            this.cellButton.setId("btnPregled");
            this.cellButton.setContentDisplay(ContentDisplay.LEFT);
            this.cellButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    ZdrastvenaUstanova se;
                    int selectdIndex = PopisZrastveneUstanoveController.this.tablicaPopisZrastvenihUstanova.getSelectionModel().getSelectedIndex();
                    if (selectdIndex != -1 && (se = (ZdrastvenaUstanova)PopisZrastveneUstanoveController.this.tablicaPopisZrastvenihUstanova.getSelectionModel().getSelectedItem()) != null) {
                        Template.getTamplate().showTemplate("zrastvenaustanova/UnosZdrastveneUstanove.fxml", "anchorPanel");
                        UnosZdrastveneUstanoveController.getInstance().popuniUstanovu(se);
                        PopisZrastveneUstanoveController.this.tablicaPopisZrastvenihUstanova.getSelectionModel().clearSelection();
                    }
                }
            });
        }

        protected void updateItem(Boolean t, boolean empty) {
            super.updateItem((Object)t, empty);
            if (!empty) {
                this.setGraphic((Node)this.cellButton);
                this.cellButton.disableProperty().bind((ObservableValue)PopisZrastveneUstanoveController.this.tablicaPopisZrastvenihUstanova.getSelectionModel().selectedIndexProperty().isNotEqualTo(this.getTableRow().getIndex()));
            } else {
                this.setGraphic(null);
                this.cellButton.disableProperty().unbind();
            }
        }
    }
}

