/*
 * Decompiled with CFR 0.152.
 */
package zrastvenaustanova;

import Utill.FormValidation;
import Utill.FxDialogs;
import Utill.FxUtil;
import Utill.KlasaKorisneMetode;
import Utill.ResizeComponent;
import Utill.ScanDokument;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import zastitanaradu.GlavniPanelController;
import zrastvenaustanova.BazaZdrastvenaUstanova;
import zrastvenaustanova.HiperLink;
import zrastvenaustanova.PopisZrastveneUstanoveController;
import zrastvenaustanova.ZdrastvenaUstanova;

public class UnosZdrastveneUstanoveController
implements Initializable {
    @FXML
    private Button btnSpremi;
    @FXML
    private Pane paneOpis;
    @FXML
    private TextField txtEmail;
    @FXML
    private TextField txtPBR;
    @FXML
    private TextField txtAdresa;
    @FXML
    private TextField txtNazivUstanove;
    @FXML
    private TextField txtNazivLijecnika;
    @FXML
    private TextField txtMedSestra;
    @FXML
    private TextField txtOib;
    @FXML
    private ComboBox<String> cboxMjesto;
    @FXML
    private ComboBox<String> cboxZupanija;
    @FXML
    private ComboBox<String> cboxDrzava;
    @FXML
    private TextField txtTelefon;
    @FXML
    private TextField txtFax;
    @FXML
    private TextField txtMobitel;
    @FXML
    private TextField txtIBAN;
    @FXML
    private TextField txtBankaIban;
    @FXML
    private TextField txtSifraLijecnika;
    @FXML
    private ComboBox<String> cboxOpcina;
    @FXML
    private TextArea textAreaNapomena;
    @FXML
    private DatePicker dateDatumSklapanjaUgovora;
    @FXML
    private HBox hBoxDokument;
    private static UnosZdrastveneUstanoveController instance;
    private ProgressIndicator progressPane = new ProgressIndicator();
    private HiperLink hl;
    private Boolean izmjenaUstanove = false;
    private ZdrastvenaUstanova zu = null;

    public static UnosZdrastveneUstanoveController getInstance() {
        return instance;
    }

    public void initialize(URL url, ResourceBundle rb) {
        instance = this;
        ResizeComponent.makeTextFieldResize(this.txtNazivUstanove);
        this.popuniComboBoxove();
        this.urediHBoxDokument();
        this.cboxZupanija.setOnAction(event -> this.popuniMjestaZaOdabranuZupaniju((String)this.cboxZupanija.getValue()));
        this.cboxMjesto.setOnAction(event -> this.txtPBR.setText(this.popuniPBRzaOdabranoMjesto((String)this.cboxMjesto.getValue())));
        this.btnSpremi.setOnAction(e -> this.spremiUstanovuUBazu());
    }

    private void popuniCboxMjesta() {
        ResultSet rs = BazaZdrastvenaUstanova.dajMjesta();
        try {
            while (rs.next()) {
                this.cboxMjesto.getItems().add((Object)rs.getString("nazivgrada"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosZdrastveneUstanoveController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosZdrastveneUstanoveController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void popuniCboxZupanije() {
        ResultSet rs = BazaZdrastvenaUstanova.dajZupanije();
        try {
            while (rs.next()) {
                this.cboxZupanija.getItems().add((Object)rs.getString("nazivzupanije"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosZdrastveneUstanoveController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosZdrastveneUstanoveController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void popuniCboxDrzave() {
        ResultSet rs = BazaZdrastvenaUstanova.dajDrzave();
        try {
            while (rs.next()) {
                this.cboxDrzava.getItems().add((Object)rs.getString("naziv_ispis"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosZdrastveneUstanoveController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosZdrastveneUstanoveController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popuniMjestaZaOdabranuZupaniju(String nazivZupanije) {
        this.cboxMjesto.getItems().clear();
        this.cboxOpcina.getItems().clear();
        ResultSet rs = BazaZdrastvenaUstanova.dohvatiGradove(nazivZupanije);
        try {
            while (rs.next()) {
                this.cboxMjesto.getItems().add((Object)rs.getString("nazivgrada"));
                this.cboxOpcina.getItems().add((Object)rs.getString("nazivgrada"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosZdrastveneUstanoveController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosZdrastveneUstanoveController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.cboxMjesto.getSelectionModel().selectFirst();
        this.cboxOpcina.getSelectionModel().selectFirst();
        this.popuniPBRzaOdabranoMjesto((String)this.cboxMjesto.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String popuniPBRzaOdabranoMjesto(String mjesto) {
        String pbr = "";
        ResultSet rs = BazaZdrastvenaUstanova.dohvatiPbr(mjesto);
        try {
            while (rs.next()) {
                pbr = rs.getString("postbroj");
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosZdrastveneUstanoveController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosZdrastveneUstanoveController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return pbr;
    }

    private void popuniCboxOpcine() {
        ResultSet rs = BazaZdrastvenaUstanova.dajMjesta();
        try {
            while (rs.next()) {
                this.cboxOpcina.getItems().add((Object)rs.getString("nazivgrada"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosZdrastveneUstanoveController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void popuniComboBoxove() {
        this.popuniCboxDrzave();
        this.popuniCboxMjesta();
        this.popuniCboxZupanije();
        this.popuniCboxOpcine();
        FxUtil.autoCompleteComboBox(this.cboxMjesto, FxUtil.AutoCompleteMode.STARTS_WITH);
        FxUtil.autoCompleteComboBox(this.cboxZupanija, FxUtil.AutoCompleteMode.STARTS_WITH);
        FxUtil.autoCompleteComboBox(this.cboxDrzava, FxUtil.AutoCompleteMode.STARTS_WITH);
        FxUtil.autoCompleteComboBox(this.cboxOpcina, FxUtil.AutoCompleteMode.STARTS_WITH);
        this.cboxMjesto.getItems().add((Object)"Sva mjesta");
        this.cboxMjesto.getSelectionModel().select((Object)"Sva mjesta");
        this.cboxOpcina.getItems().add((Object)"Sva mjesta");
        this.cboxOpcina.getSelectionModel().select((Object)"Sva mjesta");
        this.cboxDrzava.getSelectionModel().select((Object)"Hrvatska");
        this.txtPBR.setText("00000");
        this.cboxZupanija.getSelectionModel().selectFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dohvatiUstanovu() {
        ResultSet rs = BazaZdrastvenaUstanova.dajUstanovu(GlavniPanelController.getOdabranaTvrtka());
        ZdrastvenaUstanova zu = null;
        try {
            while (rs.next()) {
                zu = new ZdrastvenaUstanova();
                zu.setId(rs.getInt("id"));
                zu.setNazivUstanove(rs.getString("nazivustanove"));
                zu.setOib(rs.getString("oib"));
                zu.setAdresa(rs.getString("adresa"));
                zu.setZupanija(rs.getString("zupanija"));
                zu.setPbr(rs.getString("pbr"));
                zu.setMjesto(rs.getString("mjesto"));
                zu.setOpcina(rs.getString("opcina"));
                zu.setDrzava(rs.getString("drzava"));
                zu.setNazivLijecnika(rs.getString("nazivlijecnika"));
                zu.setSifraLijecnika(rs.getString("sifralijecnika"));
                zu.setMedSestra(rs.getString("medsestra"));
                zu.setTelefon(rs.getString("telefon"));
                zu.setFax(rs.getString("fax"));
                zu.setMobitel(rs.getString("mobitel"));
                zu.setIban(rs.getString("iban"));
                zu.setNazivBanke(rs.getString("nazivbanke"));
                zu.setEmail(rs.getString("email"));
                zu.setNapomena(rs.getString("napomena"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(UnosZdrastveneUstanoveController.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(UnosZdrastveneUstanoveController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (zu != null) {
            this.popuniUstanovu(zu);
        }
    }

    public void popuniUstanovu(ZdrastvenaUstanova zu) {
        this.izmjenaUstanove = true;
        this.zu = zu;
        this.txtNazivUstanove.setText(zu.getNazivUstanove());
        this.txtOib.setText(zu.getOib());
        this.txtAdresa.setText(zu.getAdresa());
        if (zu.getZupanija() != null) {
            this.cboxZupanija.getSelectionModel().select((Object)zu.getZupanija());
        } else {
            this.cboxZupanija.getSelectionModel().selectFirst();
        }
        if (zu.getPbr() != null) {
            this.txtPBR.setText(zu.getPbr());
        } else {
            this.txtPBR.setText("00000");
        }
        if (zu.getMjesto() != null) {
            this.cboxMjesto.getSelectionModel().select((Object)zu.getMjesto());
        } else {
            this.cboxMjesto.getSelectionModel().select((Object)"Sva mjesta");
        }
        if (zu.getOpcina() != null) {
            this.cboxOpcina.getSelectionModel().select((Object)zu.getOpcina());
        } else {
            this.cboxOpcina.getSelectionModel().select((Object)"Sva mjesta");
        }
        if (zu.getDrzava() != null) {
            this.cboxDrzava.getSelectionModel().select((Object)zu.getDrzava());
        } else {
            this.cboxDrzava.getSelectionModel().select((Object)"Hrvatska");
        }
        this.txtNazivLijecnika.setText(zu.getNazivLijecnika());
        this.txtTelefon.setText(zu.getTelefon());
        this.txtFax.setText(zu.getFax());
        this.txtMobitel.setText(zu.getMobitel());
        this.txtIBAN.setText(zu.getIban());
        this.txtBankaIban.setText(zu.getNazivBanke());
        this.txtSifraLijecnika.setText(zu.getSifraLijecnika());
        this.txtMedSestra.setText(zu.getMedSestra());
        this.txtEmail.setText(zu.getEmail());
        this.textAreaNapomena.setText(zu.getNapomena());
        this.hl.setText(zu.getNazivDokumenta());
        this.dateDatumSklapanjaUgovora.setValue((Object)zu.getDatumSklapanjaUgovora());
    }

    private ZdrastvenaUstanova dajUstanovu() {
        ZdrastvenaUstanova zu = new ZdrastvenaUstanova();
        zu.setNazivUstanove(this.txtNazivUstanove.getText());
        zu.setOib(this.txtOib.getText());
        zu.setAdresa(this.txtAdresa.getText());
        zu.setZupanija((String)this.cboxZupanija.getValue());
        zu.setPbr(this.txtPBR.getText());
        zu.setMjesto((String)this.cboxMjesto.getValue());
        zu.setOpcina((String)this.cboxOpcina.getValue());
        zu.setDrzava((String)this.cboxDrzava.getValue());
        zu.setNazivLijecnika(this.txtNazivLijecnika.getText());
        zu.setSifraLijecnika(this.txtSifraLijecnika.getText());
        zu.setMedSestra(this.txtMedSestra.getText());
        zu.setTelefon(this.txtTelefon.getText());
        zu.setFax(this.txtFax.getText());
        zu.setMobitel(this.txtMobitel.getText());
        zu.setIban(this.txtIBAN.getText());
        zu.setNazivBanke(this.txtBankaIban.getText());
        zu.setEmail(this.txtEmail.getText());
        zu.setNapomena(this.textAreaNapomena.getText());
        zu.setDatumSklapanjaUgovora((LocalDate)this.dateDatumSklapanjaUgovora.getValue());
        zu.setNazivDokumenta(this.hl.getText());
        return zu;
    }

    private void urediHBoxDokument() {
        this.hBoxDokument.setStyle("-fx-border-width: 2;\n    -fx-border-color: #046272");
        this.hBoxDokument.getChildren().addAll((Object[])new Node[]{this.getHiperLink()});
    }

    private HBox getHiperLink() {
        this.hl = new HiperLink();
        HBox hb = new HBox();
        Image img = new Image("/resorces/icon/15/dokumentPlus24.png");
        final ImageView imgView = new ImageView(img);
        Tooltip t = new Tooltip("Odaberite dokument iz zajedni\u010dkih dokumenata");
        Tooltip.install((Node)imgView, (Tooltip)t);
        hb.getChildren().addAll((Object[])new Node[]{imgView, this.hl});
        imgView.setOnMouseClicked(e -> {
            ScanDokument sd = FxDialogs.getDokumentiDijalog();
            if (sd != null) {
                this.hl.setText(sd.getOpisDokumenta());
            }
        });
        imgView.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                imgView.setStyle(" -fx-cursor: hand;");
            }
        });
        return hb;
    }

    private void spremiUstanovuUBazu() {
        boolean bNazivTvrtke = FormValidation.textFieldValidationonlyText(this.txtNazivUstanove);
        if (bNazivTvrtke) {
            if (this.izmjenaUstanove.booleanValue()) {
                if (BazaZdrastvenaUstanova.unesiIzmjenjenuUstanovu(GlavniPanelController.getOdabranaTvrtka(), this.dajUstanovu(), this.zu.getId())) {
                    if (!GlavniPanelController.getInstance().getTabByIdifExist("Unos zrastvene ustanove")) {
                        PopisZrastveneUstanoveController.getInstance().popuniTablicuPopisZrastvenihUstanova();
                    }
                    GlavniPanelController.getInstance().zatvoriTab("Unos zrastvene ustanove");
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161na izmjena ustanove", 1, "Information graphic");
                } else {
                    KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161na izmjena ustanove", 2, "Error graphic");
                }
            } else if (BazaZdrastvenaUstanova.unesiNovuUstanovu(GlavniPanelController.getOdabranaTvrtka().getId(), this.dajUstanovu())) {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.BOTTOM_RIGHT, "Uspje\u0161no unesena ustanova", 1, "Information graphic");
                PopisZrastveneUstanoveController.getInstance().popuniTablicuPopisZrastvenihUstanova();
                GlavniPanelController.getInstance().zatvoriTab("Unos zrastvene ustanove");
                this.izmjenaUstanove = false;
            } else {
                KlasaKorisneMetode.kreirajNotifikaciju(Pos.CENTER, " Neuspje\u0161no unesena ustanova", 2, "Error graphic");
            }
        } else {
            Alert alert = FxDialogs.getDialog(Alert.AlertType.INFORMATION, "Upozorenje", "Morate unjeti naziv Ustanove");
            alert.showAndWait();
        }
    }
}

