/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map.fill;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.fill.FillItem;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.type.ColorEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FillPlaceItem
extends FillItem {
    public static final String PROPERTY_COLOR = "color";
    public static final String EXCEPTION_MESSAGE_KEY_MISSING_COORDINATES = "components.map.missing.coordinates";

    public FillPlaceItem(Item item, JRFillObjectFactory factory) {
        super(item, factory);
    }

    @Override
    public Object getEvaluatedValue(ItemProperty property, JRFillExpressionEvaluator evaluator, byte evaluation) throws JRException {
        Object result = super.getEvaluatedValue(property, evaluator, evaluation);
        return "address".equals(property.getName()) ? this.getCoords((String)result) : (PROPERTY_COLOR.equals(property.getName()) ? JRColorUtil.getColorHexa(JRColorUtil.getColor((String)result, ColorEnum.RED.getColor())) : result);
    }

    @Override
    public void verifyValue(ItemProperty property, Object value) throws JRException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void verifyValues(Map<String, Object> result) throws JRException {
        if (result == null) return;
        Object latitude = result.get("latitude");
        Object longitude = result.get("longitude");
        Object address = result.get("address");
        Float fLatitude = null;
        if (latitude instanceof Number) {
            fLatitude = Float.valueOf(((Number)latitude).floatValue());
        } else {
            String strLatitude = latitude == null ? null : String.valueOf(latitude);
            fLatitude = strLatitude == null || strLatitude.trim().length() == 0 ? null : Float.valueOf(Float.parseFloat(strLatitude));
        }
        Float fLongitude = null;
        if (longitude instanceof Number) {
            fLongitude = Float.valueOf(((Number)longitude).floatValue());
        } else {
            String strLongitude = longitude == null ? null : String.valueOf(longitude);
            Float f = fLongitude = strLongitude == null || strLongitude.trim().length() == 0 ? null : Float.valueOf(Float.parseFloat(strLongitude));
        }
        if (fLatitude != null && fLongitude != null) {
            result.remove("address");
            result.put("latitude", fLatitude);
            result.put("longitude", fLongitude);
            return;
        } else {
            if (address == null) throw new JRException(EXCEPTION_MESSAGE_KEY_MISSING_COORDINATES, new Object[]{fLatitude == null ? "latitude" : "longitude"});
            Float[] coords = (Float[])address;
            if (coords[0] == null || coords[1] == null) throw new JRException("components.map.invalid.address.coordinates", new Object[]{coords[0], coords[1]});
            result.put("latitude", coords[0]);
            result.put("longitude", coords[1]);
            result.remove("address");
        }
    }

    private Float[] getCoords(String address) throws JRException {
        Float[] coords = null;
        if (address != null) {
            try {
                String url = "https://maps.googleapis.com/maps/api/geocode/xml?address=" + URLEncoder.encode(address, "UTF-8") + "&sensor=false&output=xml&oe=utf8";
                byte[] response = this.read(url);
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(response));
                Node statusNode = (Node)new DOMXPath("/GeocodeResponse/status").selectSingleNode((Object)document);
                String status = statusNode.getTextContent();
                if (!"OK".equals(status)) {
                    throw new JRException("components.map.address.request.failed", new Object[]{status});
                }
                coords = new Float[2];
                Node latNode = (Node)new DOMXPath("/GeocodeResponse/result/geometry/location/lat").selectSingleNode((Object)document);
                coords[0] = Float.valueOf(latNode.getTextContent());
                Node lngNode = (Node)new DOMXPath("/GeocodeResponse/result/geometry/location/lng").selectSingleNode((Object)document);
                coords[1] = Float.valueOf(lngNode.getTextContent());
            }
            catch (Exception e) {
                throw new JRException(e);
            }
        }
        return coords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] read(String url) throws IOException {
        InputStream stream = null;
        try {
            int read;
            URL u = new URL(url);
            stream = u.openStream();
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((read = stream.read(buf)) > 0) {
                byteOut.write(buf, 0, read);
            }
            byte[] byArray = byteOut.toByteArray();
            return byArray;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }
}

