/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.sort;

import java.io.IOException;
import net.sf.jasperreports.components.AbstractComponentXmlWriter;
import net.sf.jasperreports.components.sort.SortComponent;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.VersionComparator;
import net.sf.jasperreports.engine.util.XmlNamespace;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class SortComponentXmlWriter
extends AbstractComponentXmlWriter {
    public static final String PROPERTY_HANDLER_FONT_SIZE = "handlerFontSize";

    public SortComponentXmlWriter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public SortComponentXmlWriter(JasperReportsContext jasperReportsContext) {
        this(jasperReportsContext, null, new VersionComparator());
    }

    public SortComponentXmlWriter(JasperReportsContext jasperReportsContext, String version, VersionComparator versionComparator) {
        super(jasperReportsContext);
    }

    @Override
    public boolean isToWrite(JRComponentElement componentElement, JRXmlWriter reportWriter) {
        return this.isNewerVersionOrEqual(componentElement, reportWriter, "4.1.1");
    }

    @Override
    public void writeToXml(JRComponentElement componentElement, JRXmlWriter reportWriter) throws IOException {
        Component component = componentElement.getComponent();
        if (component instanceof SortComponent) {
            this.writeSortComponent(componentElement, reportWriter);
        }
    }

    protected void writeSortComponent(JRComponentElement componentElement, JRXmlWriter reportWriter) throws IOException {
        Component component = componentElement.getComponent();
        SortComponent sortComponent = (SortComponent)component;
        ComponentKey componentKey = componentElement.getComponentKey();
        String namespaceURI = componentKey.getNamespace();
        String schemaLocation = ComponentsEnvironment.getInstance(this.jasperReportsContext).getBundle(namespaceURI).getXmlParser().getPublicSchemaLocation();
        XmlNamespace componentNamespace = new XmlNamespace(namespaceURI, componentKey.getNamespacePrefix(), schemaLocation);
        JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
        writer.startElement("sort", componentNamespace);
        if (this.isOlderVersionThan(componentElement, reportWriter, "4.1.3")) {
            writer.addAttribute("sortFieldName", sortComponent.getSortFieldName());
            writer.addAttribute("sortFieldType", sortComponent.getSortFieldType());
            writer.addAttribute("handlerColor", sortComponent.getHandlerColor());
            writer.addAttribute(PROPERTY_HANDLER_FONT_SIZE, sortComponent.getSymbolFont().getFontsize());
            writer.addAttribute("handlerHorizontalAlign", sortComponent.getHandlerHorizontalImageAlign());
            writer.addAttribute("handlerVerticalAlign", sortComponent.getHandlerVerticalImageAlign());
        }
        if (sortComponent.getEvaluationTime() != EvaluationTimeEnum.NOW) {
            writer.addAttribute("evaluationTime", sortComponent.getEvaluationTime());
        }
        writer.addAttribute("evaluationGroup", sortComponent.getEvaluationGroup());
        if (this.isNewerVersionOrEqual(componentElement, reportWriter, "4.1.3")) {
            writer.startElement("symbol");
            if (sortComponent.getHandlerColor() != null) {
                writer.addAttribute("handlerColor", sortComponent.getHandlerColor());
            }
            writer.addAttribute("sortFieldType", sortComponent.getSortFieldType());
            writer.addAttribute("sortFieldName", sortComponent.getSortFieldName());
            writer.addAttribute("handlerHorizontalAlign", sortComponent.getHandlerHorizontalImageAlign());
            writer.addAttribute("handlerVerticalAlign", sortComponent.getHandlerVerticalImageAlign());
            reportWriter.writeFont(sortComponent.getSymbolFont());
            writer.closeElement();
        }
        writer.closeElement();
    }
}

