/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLStreamHandlerFactory;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.ExporterFilterFactory;
import net.sf.jasperreports.engine.export.ExporterFilterFactoryUtil;
import net.sf.jasperreports.engine.export.JRExporterContext;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.util.DefaultFormatFactory;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;
import net.sf.jasperreports.engine.util.LocalJasperReportsContext;
import net.sf.jasperreports.engine.util.Pair;
import net.sf.jasperreports.export.CompositeExporterConfigurationFactory;
import net.sf.jasperreports.export.Exporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.PropertiesDefaultsConfigurationFactory;
import net.sf.jasperreports.export.PropertiesNoDefaultsConfigurationFactory;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInputItem;
import net.sf.jasperreports.export.parameters.ParametersExporterConfigurationFactory;
import net.sf.jasperreports.export.parameters.ParametersExporterInput;

public abstract class JRAbstractExporter<RC extends ReportExportConfiguration, C extends ExporterConfiguration, O extends ExporterOutput, E extends JRExporterContext>
implements JRExporter<ExporterInput, RC, C, O> {
    public static final String EXCEPTION_MESSAGE_KEY_START_PAGE_INDEX_OUT_OF_RANGE = "export.common.start.page.index.out.of.range";
    public static final String EXCEPTION_MESSAGE_KEY_END_PAGE_INDEX_OUT_OF_RANGE = "export.common.end.page.index.out.of.range";
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_IMAGE_NAME = "export.common.invalid.image.name";
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_ZOOM_RATIO = "export.common.invalid.zoom.ratio";
    public static final String EXCEPTION_MESSAGE_KEY_MIXED_CALLS_NOT_ALLOWED = "export.common.mixed.calls.not.allowed";
    public static final String EXCEPTION_MESSAGE_KEY_PAGE_INDEX_OUT_OF_RANGE = "export.common.page.index.out.of.range";
    public static final String EXCEPTION_MESSAGE_KEY_OUTPUT_WRITER_ERROR = "export.common.output.writer.error";
    public static final String PROPERTY_SUFFIX_DEFAULT_FILTER_FACTORY = "default.filter.factory";
    public static final String PROPERTY_DEFAULT_FILTER_FACTORY = "net.sf.jasperreports.export.default.filter.factory";
    private Boolean useOldApi = null;
    protected JasperReportsContext jasperReportsContext;
    protected JRPropertiesUtil propertiesUtil;
    protected JRStyledTextAttributeSelector allSelector;
    protected JRStyledTextAttributeSelector noBackcolorSelector;
    protected JRStyledTextAttributeSelector noneSelector;
    protected JRStyledTextUtil styledTextUtil;
    protected Map<JRExporterParameter, Object> parameters = new HashMap<JRExporterParameter, Object>();
    protected ExporterInput exporterInput;
    protected RC itemConfiguration;
    protected C exporterConfiguration;
    protected O exporterOutput;
    protected ExporterInputItem crtItem;
    protected RC crtCompositeItemConfiguration;
    protected C crtCompositeConfiguration;
    protected JasperPrint jasperPrint;
    protected ExporterFilter filter;
    private LinkedList<int[]> elementOffsetStack = new LinkedList();
    private int elementOffsetX;
    private int elementOffsetY;
    protected Map<String, DateFormat> dateFormatCache = new HashMap<String, DateFormat>();
    protected Map<String, NumberFormat> numberFormatCache = new HashMap<String, NumberFormat>();
    private Pair<String, Locale> lastTextLocale;
    protected Map<String, Class<?>> textValueClasses = new HashMap();
    private ReportContext reportContext;
    protected E exporterContext;

    protected JRAbstractExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    protected JRAbstractExporter(JasperReportsContext jasperReportsContext) {
        this.setJasperReportsContext(jasperReportsContext);
    }

    private void checkApi(boolean isOldApi) {
        if (this.useOldApi == null) {
            this.useOldApi = isOldApi;
        } else if (this.useOldApi != isOldApi) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_MIXED_CALLS_NOT_ALLOWED, (Object[])null);
        }
    }

    public void reset() {
        this.useOldApi = null;
        HashMap<JRExporterParameter, Object> dep = new HashMap<JRExporterParameter, Object>();
        this.parameters = dep;
        this.elementOffsetStack = new LinkedList();
        this.exporterInput = null;
        this.exporterOutput = null;
        this.exporterConfiguration = null;
        this.itemConfiguration = null;
    }

    @Override
    public void setParameter(JRExporterParameter parameter, Object value) {
        this.checkApi(true);
        this.parameters.put(parameter, value);
        this.exporterInput = null;
        this.exporterOutput = null;
        this.exporterConfiguration = null;
    }

    @Override
    public Object getParameter(JRExporterParameter parameter) {
        return this.parameters.get(parameter);
    }

    @Override
    public void setParameters(Map<JRExporterParameter, Object> parameters) {
        this.checkApi(true);
        this.parameters = parameters;
        this.exporterInput = null;
        this.exporterOutput = null;
        this.exporterConfiguration = null;
    }

    @Override
    public Map<JRExporterParameter, Object> getParameters() {
        return this.parameters;
    }

    protected ExporterInput getExporterInput() {
        return this.exporterInput;
    }

    @Override
    public void setExporterInput(ExporterInput exporterInput) {
        this.checkApi(false);
        this.exporterInput = exporterInput;
    }

    protected O getExporterOutput() {
        return this.exporterOutput;
    }

    @Override
    public void setExporterOutput(O exporterOutput) {
        this.checkApi(false);
        this.exporterOutput = exporterOutput;
    }

    @Override
    public void setConfiguration(RC configuration) {
        this.checkApi(false);
        this.itemConfiguration = configuration;
    }

    @Override
    public void setConfiguration(C configuration) {
        this.checkApi(false);
        this.exporterConfiguration = configuration;
    }

    public JasperReportsContext getJasperReportsContext() {
        return this.jasperReportsContext;
    }

    protected void setJasperReportsContext(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
        this.propertiesUtil = JRPropertiesUtil.getInstance(jasperReportsContext);
        this.allSelector = JRStyledTextAttributeSelector.getAllSelector(jasperReportsContext);
        this.noBackcolorSelector = JRStyledTextAttributeSelector.getNoBackcolorSelector(jasperReportsContext);
        this.noneSelector = JRStyledTextAttributeSelector.getNoneSelector(jasperReportsContext);
        this.styledTextUtil = JRStyledTextUtil.getInstance(jasperReportsContext);
    }

    @Override
    public void setReportContext(ReportContext reportContext) {
        this.reportContext = reportContext;
    }

    @Override
    public ReportContext getReportContext() {
        return this.reportContext;
    }

    public JRPropertiesUtil getPropertiesUtil() {
        return this.propertiesUtil;
    }

    @Override
    public abstract void exportReport() throws JRException;

    protected void setOffset() {
        this.setOffset(true);
    }

    protected void setOffset(boolean setElementOffsets) {
        if (setElementOffsets) {
            RC configuration = this.getCurrentItemConfiguration();
            Integer offsetX = configuration.getOffsetX();
            this.elementOffsetX = offsetX != null ? offsetX : 0;
            Integer offsetY = configuration.getOffsetY();
            this.elementOffsetY = offsetY != null ? offsetY : 0;
        }
    }

    protected void ensureJasperReportsContext() {
        if (this.parameters.containsKey(JRExporterParameter.CLASS_LOADER) || this.parameters.containsKey(JRExporterParameter.URL_HANDLER_FACTORY) || this.parameters.containsKey(JRExporterParameter.FILE_RESOLVER)) {
            LocalJasperReportsContext localJasperReportsContext = new LocalJasperReportsContext(this.jasperReportsContext);
            if (this.parameters.containsKey(JRExporterParameter.CLASS_LOADER)) {
                localJasperReportsContext.setClassLoader((ClassLoader)this.parameters.get(JRExporterParameter.CLASS_LOADER));
            }
            if (this.parameters.containsKey(JRExporterParameter.URL_HANDLER_FACTORY)) {
                localJasperReportsContext.setURLStreamHandlerFactory((URLStreamHandlerFactory)this.parameters.get(JRExporterParameter.URL_HANDLER_FACTORY));
            }
            if (this.parameters.containsKey(JRExporterParameter.FILE_RESOLVER)) {
                localJasperReportsContext.setFileResolver((FileResolver)this.parameters.get(JRExporterParameter.FILE_RESOLVER));
            }
            this.setJasperReportsContext(localJasperReportsContext);
        }
        FontUtil.getInstance(this.jasperReportsContext).resetThreadMissingFontsCache();
    }

    protected void resetExportContext() {
    }

    protected void setClassLoader() {
        this.ensureJasperReportsContext();
    }

    protected void resetClassLoader() {
        this.resetExportContext();
    }

    protected void setCurrentExporterInputItem(ExporterInputItem crtItem) {
        this.crtItem = crtItem;
        this.jasperPrint = crtItem.getJasperPrint();
        this.crtCompositeItemConfiguration = null;
        this.initReport();
    }

    protected RC getCurrentItemConfiguration() {
        if (this.crtCompositeItemConfiguration == null) {
            ReportExportConfiguration crtItemConfiguration = this.crtItem.getConfiguration();
            if (crtItemConfiguration != null) {
                this.checkApi(false);
            }
            if (this.useOldApi.booleanValue()) {
                ReportExportConfiguration depConf = (ReportExportConfiguration)new ParametersExporterConfigurationFactory<RC>(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint()).getConfiguration(this.getItemConfigurationInterface());
                this.crtCompositeItemConfiguration = depConf;
            } else {
                PropertiesDefaultsConfigurationFactory<RC> defaultsFactory = new PropertiesDefaultsConfigurationFactory<RC>(this.jasperReportsContext);
                ReportExportConfiguration defaultsConfiguration = (ReportExportConfiguration)defaultsFactory.getConfiguration(this.getItemConfigurationInterface());
                PropertiesNoDefaultsConfigurationFactory<RC> noDefaultsFactory = new PropertiesNoDefaultsConfigurationFactory<RC>(this.jasperReportsContext);
                ReportExportConfiguration noDefaultsConfiguration = (ReportExportConfiguration)noDefaultsFactory.getConfiguration(this.getItemConfigurationInterface(), this.getCurrentJasperPrint());
                CompositeExporterConfigurationFactory<RC> compositeFactory = new CompositeExporterConfigurationFactory<RC>(this.jasperReportsContext, this.getItemConfigurationInterface());
                ReportExportConfiguration tmpItemConfiguration = compositeFactory.getConfiguration(crtItemConfiguration, noDefaultsConfiguration);
                tmpItemConfiguration = compositeFactory.getConfiguration(this.itemConfiguration, tmpItemConfiguration);
                this.crtCompositeItemConfiguration = compositeFactory.getConfiguration(tmpItemConfiguration, defaultsConfiguration, true);
            }
        }
        return this.crtCompositeItemConfiguration;
    }

    protected C getCurrentConfiguration() {
        if (this.crtCompositeConfiguration == null) {
            if (this.useOldApi.booleanValue()) {
                ExporterConfiguration depConf = (ExporterConfiguration)new ParametersExporterConfigurationFactory<C>(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint()).getConfiguration(this.getConfigurationInterface());
                this.crtCompositeConfiguration = depConf;
            } else {
                PropertiesDefaultsConfigurationFactory<C> defaultsFactory = new PropertiesDefaultsConfigurationFactory<C>(this.jasperReportsContext);
                ExporterConfiguration defaultsConfiguration = (ExporterConfiguration)defaultsFactory.getConfiguration(this.getConfigurationInterface());
                PropertiesNoDefaultsConfigurationFactory<C> noDefaultsFactory = new PropertiesNoDefaultsConfigurationFactory<C>(this.jasperReportsContext);
                ExporterConfiguration noDefaultsConfiguration = (ExporterConfiguration)noDefaultsFactory.getConfiguration(this.getConfigurationInterface(), this.getCurrentJasperPrint());
                CompositeExporterConfigurationFactory<ExporterConfiguration> compositeFactory = new CompositeExporterConfigurationFactory<ExporterConfiguration>(this.jasperReportsContext, this.getConfigurationInterface());
                ExporterConfiguration tmpItemConfiguration = compositeFactory.getConfiguration((ExporterConfiguration)this.exporterConfiguration, noDefaultsConfiguration);
                this.crtCompositeConfiguration = compositeFactory.getConfiguration(tmpItemConfiguration, defaultsConfiguration, true);
            }
        }
        return this.crtCompositeConfiguration;
    }

    protected void setJasperPrint(JasperPrint jasperPrint) {
        this.setCurrentExporterInputItem(new SimpleExporterInputItem(jasperPrint));
    }

    protected abstract Class<C> getConfigurationInterface();

    protected abstract Class<RC> getItemConfigurationInterface();

    protected void ensureInput() {
        if (this.exporterInput == null) {
            this.exporterInput = new ParametersExporterInput(this.parameters);
        }
        this.jasperPrint = this.exporterInput.getItems().get(0).getJasperPrint();
    }

    protected abstract void ensureOutput();

    protected void initExport() {
        this.crtCompositeConfiguration = null;
    }

    protected void initReport() {
        String localeCode = this.jasperPrint.getLocaleCode();
        JRStyledTextParser.setLocale(localeCode == null ? null : JRDataUtils.getLocale(localeCode));
        this.setOffset();
        this.filter = this.getCurrentItemConfiguration().getExporterFilter();
        if (this.filter == null) {
            this.filter = this.createFilter();
        }
    }

    protected PageRange getPageRange() {
        Integer pageIndex;
        RC configuration;
        Integer start;
        Integer startPageIndex = null;
        Integer endPageIndex = null;
        int lastPageIndex = -1;
        if (this.jasperPrint.getPages() != null) {
            lastPageIndex = this.jasperPrint.getPages().size() - 1;
        }
        if ((start = (configuration = this.getCurrentItemConfiguration()).getStartPageIndex()) != null && ((startPageIndex = start) < 0 || startPageIndex > lastPageIndex)) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_START_PAGE_INDEX_OUT_OF_RANGE, new Object[]{startPageIndex, lastPageIndex});
        }
        Integer end = configuration.getEndPageIndex();
        if (end != null) {
            int startPage;
            endPageIndex = end;
            int n = startPage = startPageIndex == null ? 0 : startPageIndex;
            if (endPageIndex < startPage || endPageIndex > lastPageIndex) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_END_PAGE_INDEX_OUT_OF_RANGE, new Object[]{startPage, endPageIndex, lastPageIndex});
            }
        }
        if ((pageIndex = configuration.getPageIndex()) != null) {
            if (pageIndex < 0 || pageIndex > lastPageIndex) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_PAGE_INDEX_OUT_OF_RANGE, new Object[]{pageIndex, lastPageIndex});
            }
            startPageIndex = pageIndex;
            endPageIndex = pageIndex;
        }
        PageRange pageRange = null;
        if (startPageIndex != null || endPageIndex != null) {
            pageRange = new PageRange(startPageIndex, endPageIndex);
        }
        return pageRange;
    }

    protected JRStyledText getStyledText(JRPrintText textElement, boolean setBackcolor) {
        return this.styledTextUtil.getStyledText(textElement, setBackcolor ? this.allSelector : this.noBackcolorSelector);
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        return this.getStyledText(textElement, true);
    }

    protected int getOffsetX() {
        return this.elementOffsetX;
    }

    protected int getOffsetY() {
        return this.elementOffsetY;
    }

    protected void setFrameElementsOffset(JRPrintFrame frame, boolean relative) {
        if (relative) {
            this.setElementOffsets(0, 0);
        } else {
            int topPadding = frame.getLineBox().getTopPadding();
            int leftPadding = frame.getLineBox().getLeftPadding();
            this.setElementOffsets(this.getOffsetX() + frame.getX() + leftPadding, this.getOffsetY() + frame.getY() + topPadding);
        }
    }

    private void setElementOffsets(int offsetX, int offsetY) {
        this.elementOffsetStack.addLast(new int[]{this.elementOffsetX, this.elementOffsetY});
        this.elementOffsetX = offsetX;
        this.elementOffsetY = offsetY;
    }

    protected void restoreElementOffsets() {
        int[] offsets = this.elementOffsetStack.removeLast();
        this.elementOffsetX = offsets[0];
        this.elementOffsetY = offsets[1];
    }

    protected boolean insideFrame() {
        return this.elementOffsetStack != null && this.elementOffsetStack.size() > 0;
    }

    protected String getTextFormatFactoryClass(JRPrintText text) {
        String formatFactoryClass = text.getFormatFactoryClass();
        if (formatFactoryClass == null) {
            formatFactoryClass = this.jasperPrint.getFormatFactoryClass();
        }
        return formatFactoryClass;
    }

    protected Locale getLocale() {
        String localeCode = this.jasperPrint.getLocaleCode();
        return localeCode == null ? null : JRDataUtils.getLocale(localeCode);
    }

    protected Locale getTextLocale(JRPrintText text) {
        String localeCode = text.getLocaleCode();
        if (localeCode == null) {
            localeCode = this.jasperPrint.getLocaleCode();
        }
        if (localeCode == null) {
            return null;
        }
        Pair<String, Locale> last = this.lastTextLocale;
        if (last != null && last.first().equals(localeCode)) {
            return last.second();
        }
        Locale locale = JRDataUtils.getLocale(localeCode);
        this.lastTextLocale = new Pair<String, Locale>(localeCode, locale);
        return locale;
    }

    protected TimeZone getTextTimeZone(JRPrintText text) {
        String tzId = text.getTimeZoneId();
        if (tzId == null) {
            tzId = this.jasperPrint.getTimeZoneId();
        }
        return tzId == null ? null : JRDataUtils.getTimeZone(tzId);
    }

    protected TextValue getTextValue(JRPrintText text, String textStr) {
        TextValue textValue;
        String valueClassName = text.getValueClassName();
        if (valueClassName == null) {
            textValue = this.getTextValueString(text, textStr);
        } else {
            try {
                Class<?> valueClass = this.textValueClasses.get(valueClassName);
                if (valueClass == null) {
                    valueClass = JRClassLoader.loadClassForRealName(valueClassName);
                    this.textValueClasses.put(valueClassName, valueClass);
                }
                textValue = Number.class.isAssignableFrom(valueClass) ? this.getNumberCellValue(text, textStr) : (Date.class.isAssignableFrom(valueClass) ? this.getDateCellValue(text, textStr) : (Boolean.class.equals(valueClass) ? this.getBooleanCellValue(text, textStr) : this.getTextValueString(text, textStr)));
            }
            catch (ParseException e) {
                textValue = this.getTextValueString(text, textStr);
            }
            catch (ClassNotFoundException e) {
                textValue = this.getTextValueString(text, textStr);
            }
        }
        return textValue;
    }

    protected TextValue getTextValueString(JRPrintText text, String textStr) {
        return new StringTextValue(textStr);
    }

    protected TextValue getDateCellValue(JRPrintText text, String textStr) throws ParseException {
        return new DateTextValue(textStr, (Date)text.getValue(), text.getPattern());
    }

    protected TextValue getNumberCellValue(JRPrintText text, String textStr) throws ParseException, ClassNotFoundException {
        return new NumberTextValue(textStr, (Number)text.getValue(), text.getPattern());
    }

    protected Number defaultParseNumber(String textStr, Class<?> valueClass) {
        Number value = null;
        try {
            if (valueClass.equals(Byte.class)) {
                value = Byte.valueOf(textStr);
            } else if (valueClass.equals(Short.class)) {
                value = Short.valueOf(textStr);
            } else if (valueClass.equals(Integer.class)) {
                value = Integer.valueOf(textStr);
            } else if (valueClass.equals(Long.class)) {
                value = Long.valueOf(textStr);
            } else if (valueClass.equals(Float.class)) {
                value = Float.valueOf(textStr);
            } else if (valueClass.equals(Double.class)) {
                value = Double.valueOf(textStr);
            } else if (valueClass.equals(BigInteger.class)) {
                value = new BigInteger(textStr);
            } else if (valueClass.equals(BigDecimal.class)) {
                value = new BigDecimal(textStr);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    protected TextValue getBooleanCellValue(JRPrintText text, String textStr) {
        Boolean value = null;
        if (textStr != null && textStr.length() > 0) {
            value = Boolean.valueOf(textStr);
        }
        return new BooleanTextValue(textStr, value);
    }

    protected DateFormat getDateFormat(String formatFactoryClass, String pattern, Locale lc, TimeZone tz) {
        String key = formatFactoryClass + "|" + pattern + "|" + (lc == null ? "" : JRDataUtils.getLocaleCode(lc)) + "|" + (tz == null ? "" : JRDataUtils.getTimeZoneId(tz));
        DateFormat dateFormat = this.dateFormatCache.get(key);
        if (dateFormat == null) {
            FormatFactory formatFactory = DefaultFormatFactory.createFormatFactory(formatFactoryClass);
            dateFormat = formatFactory.createDateFormat(pattern, lc, tz);
            this.dateFormatCache.put(key, dateFormat);
        }
        return dateFormat;
    }

    protected NumberFormat getNumberFormat(String formatFactoryClass, String pattern, Locale lc) {
        String key = formatFactoryClass + "|" + pattern + "|" + (lc == null ? "" : JRDataUtils.getLocaleCode(lc));
        NumberFormat numberFormat = this.numberFormatCache.get(key);
        if (numberFormat == null) {
            FormatFactory formatFactory = DefaultFormatFactory.createFormatFactory(formatFactoryClass);
            numberFormat = formatFactory.createNumberFormat(pattern, lc);
            this.numberFormatCache.put(key, numberFormat);
        }
        return numberFormat;
    }

    protected ExporterFilter createFilter() {
        String exportDefaultFactoryProperty = this.getExporterPropertiesPrefix() + PROPERTY_SUFFIX_DEFAULT_FILTER_FACTORY;
        String defaultFilterClassName = null;
        if (this.jasperPrint.hasProperties() && (defaultFilterClassName = this.jasperPrint.getPropertiesMap().getProperty(exportDefaultFactoryProperty)) == null) {
            defaultFilterClassName = this.jasperPrint.getPropertiesMap().getProperty(PROPERTY_DEFAULT_FILTER_FACTORY);
        }
        if (defaultFilterClassName == null) {
            defaultFilterClassName = this.getPropertiesUtil().getProperty(exportDefaultFactoryProperty);
        }
        if (defaultFilterClassName == null) {
            defaultFilterClassName = this.getPropertiesUtil().getProperty(PROPERTY_DEFAULT_FILTER_FACTORY);
        }
        ExporterFilter filter = null;
        try {
            ExporterFilterFactory defaultFactory = ExporterFilterFactoryUtil.getFilterFactory(defaultFilterClassName);
            filter = defaultFactory.getFilter((JRExporterContext)this.getExporterContext());
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        return filter;
    }

    public JRHyperlinkProducer getHyperlinkProducer(JRPrintHyperlink link) {
        JRHyperlinkProducerFactory factory = this.getCurrentItemConfiguration().getHyperlinkProducerFactory();
        return factory == null ? null : factory.getHandler(link.getLinkType());
    }

    protected JRHyperlinkProducer getCustomHandler(JRPrintHyperlink link) {
        return this.getHyperlinkProducer(link);
    }

    public abstract String getExporterKey();

    public abstract String getExporterPropertiesPrefix();

    public E getExporterContext() {
        return this.exporterContext;
    }

    public JasperPrint getCurrentJasperPrint() {
        return this.jasperPrint;
    }

    protected class PageRange {
        private Integer startPageIndex;
        private Integer endPageIndex;

        public PageRange(Integer startPageIndex, Integer endPageIndex) {
            this.startPageIndex = startPageIndex;
            this.endPageIndex = endPageIndex;
        }

        public Integer getStartPageIndex() {
            return this.startPageIndex;
        }

        public Integer getEndPageIndex() {
            return this.endPageIndex;
        }
    }

    public abstract class BaseExporterContext
    implements JRExporterContext {
        private Map<String, Object> values = new HashMap<String, Object>();

        @Override
        public JRExporter getExporter() {
            return JRAbstractExporter.this;
        }

        @Override
        public Exporter getExporterRef() {
            return JRAbstractExporter.this;
        }

        @Override
        public JasperReportsContext getJasperReportsContext() {
            return JRAbstractExporter.this.jasperReportsContext;
        }

        @Override
        public JasperPrint getExportedReport() {
            return JRAbstractExporter.this.jasperPrint;
        }

        @Override
        public Map<JRExporterParameter, Object> getExportParameters() {
            return JRAbstractExporter.this.parameters;
        }

        @Override
        public int getOffsetX() {
            return JRAbstractExporter.this.getOffsetX();
        }

        @Override
        public int getOffsetY() {
            return JRAbstractExporter.this.getOffsetY();
        }

        @Override
        public String getExportPropertiesPrefix() {
            return JRAbstractExporter.this.getExporterPropertiesPrefix();
        }

        @Override
        public Object getValue(String key) {
            return this.values.get(key);
        }

        @Override
        public void setValue(String key, Object value) {
            this.values.put(key, value);
        }

        @Override
        public Map<String, Object> getValues() {
            return this.values;
        }
    }
}

